/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dhcpsgui.view;

import COM.ibm.raleigh.awtExt.MultiLineLabel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.dhcpsgui.biz.ConfigItem;
import COM.ibm.raleigh.dhcpsgui.io.ErrorReporter;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;

public class InfoFrame
extends Frame
implements WindowListener,
ActionListener,
KeyListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    static final String TEXT_NO_ITEM_ON_CLIPBOARD = DHCPServerGUI.getResourceString("TEXT_NO_ITEM_ON_CLIPBOARD");
    static final String TEXT_BUTTON_OK = DHCPServerGUI.getResourceString("TEXT_BUTTON_OK");
    Button buttonOK;
    MultiLineLabel infoText;
    MultiLineLabel infoDesc;
    Label blankLabel = new Label(" ");
    static Font textFont = new Font("sansserif", 0, DDNSUtility.getCountryFontSize());
    boolean disposeOfMyself = false;
    ErrorReporter parent;

    public InfoFrame(String string) {
        super(string);
        ((Component)this).setFont(textFont);
        this.layoutFrame();
        this.parent = null;
    }

    public InfoFrame(boolean bl, String string) {
        super(string);
        ((Component)this).setFont(textFont);
        this.layoutFrame();
        this.disposeOfMyself = true;
        ((Component)this).setBackground(Color.lightGray);
        this.parent = null;
    }

    public InfoFrame(boolean bl, ErrorReporter errorReporter, String string) {
        super(string);
        ((Component)this).setFont(textFont);
        this.layoutFrame();
        this.disposeOfMyself = true;
        ((Component)this).setBackground(Color.lightGray);
        this.parent = errorReporter;
    }

    private void layoutFrame() {
        this.setLayout(new BorderLayout());
        Panel panel = new Panel();
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        panel.setLayout(new GridLayout(3, 1));
        ((Component)this).setBackground(Color.white);
        this.infoText = new MultiLineLabel(TEXT_NO_ITEM_ON_CLIPBOARD);
        this.infoDesc = new MultiLineLabel(" ");
        panel.add(this.infoText);
        panel.add(this.blankLabel);
        panel.add(this.infoDesc);
        this.add("Center", panel);
        this.buttonOK = new Button(TEXT_BUTTON_OK);
        this.buttonOK.setBackground(Color.lightGray);
        this.buttonOK.addActionListener(this);
        this.buttonOK.addKeyListener(this);
        panel2.add(this.buttonOK);
        this.add("South", panel2);
        this.addWindowListener(this);
    }

    public void setVisible(boolean bl) {
        ((Component)this).setSize(350, 150);
        super.setVisible(bl);
    }

    public void setItem(ConfigItem configItem) {
        if (configItem == null) {
            this.infoText.setLabel(TEXT_NO_ITEM_ON_CLIPBOARD);
            this.infoDesc.setLabel(" ");
            return;
        }
        String string = "";
        Enumeration enumeration = configItem.getOneLineDescription();
        enumeration.nextElement();
        while (enumeration.hasMoreElements()) {
            string = String.valueOf(string) + (String)enumeration.nextElement();
            if (!enumeration.hasMoreElements()) continue;
            string = String.valueOf(string) + "  ";
        }
        this.infoText.setLabel(configItem.getName());
        this.infoDesc.setLabel(string);
    }

    public void setText(String string) {
        this.infoText.setLabel(string);
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.setVisible(false);
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    private void handleButton(Button button) {
        String string = button.getLabel();
        if (string.equals(TEXT_BUTTON_OK)) {
            this.setVisible(false);
            if (this.parent != null) {
                this.parent.takeErrorAction(TEXT_BUTTON_OK);
            }
        }
        if (this.disposeOfMyself) {
            this.dispose();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

