/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.utilExt;

import COM.ibm.raleigh.dhcpsgui.biz.Message;
import COM.ibm.raleigh.dhcpsgui.biz.TimeInterval;
import COM.ibm.raleigh.dhcpsgui.view.DHCPServerGUI;
import java.text.MessageFormat;

public class BoundedInteger {
    private int min;
    private int max;
    private int currentValue;
    private boolean currentValueSet;
    private int defaultValue;
    private boolean useDefault = false;
    public static final String VALUE_NOT_SET = "";
    public static final String s = "(C) Copyright IBM Corp. 1997, 1998.  All rights reserved.\n";
    private static final String ERROR_INTEGER_OUT_OF_RANGE = DHCPServerGUI.getResourceString("ERROR_INTEGER_OUT_OF_RANGE");

    public void setRange(String string, String string2) {
        this.setRange(Integer.parseInt(string), Integer.parseInt(string2));
    }

    public void setRange(int n, int n2) {
        if (n <= n2) {
            this.min = n;
            this.max = n2;
            return;
        }
        throw new IllegalArgumentException();
    }

    public Message setDefault(int n) {
        Message message = null;
        message = this.setValue(Integer.toString(n));
        if (message == null) {
            this.defaultValue = n;
            this.useDefault = true;
        }
        return message;
    }

    public Message isIntegerWithinRange(String string) {
        return BoundedInteger.isIntegerWithinSpecifiedRange(string, this.min, this.max);
    }

    public static final Message isIntegerWithinSpecifiedRange(String string, int n, int n2) {
        Message message = TimeInterval.isValidInteger(string);
        if (message != null) {
            return message;
        }
        int n3 = Integer.parseInt(string.trim());
        if (n3 >= n && n3 <= n2) {
            return null;
        }
        Object[] objectArray = new Object[]{string, new Integer(n), new Integer(n2)};
        return new Message(MessageFormat.format(ERROR_INTEGER_OUT_OF_RANGE, objectArray));
    }

    public Message setValue(String string) {
        Message message = null;
        if (string == null || string.trim().equals(VALUE_NOT_SET)) {
            if (this.useDefault) {
                return this.setValue(Integer.toString(this.defaultValue));
            }
            this.currentValueSet = false;
        } else {
            message = this.isIntegerWithinRange(string);
            if (message == null) {
                this.currentValue = Integer.parseInt(string);
                this.currentValueSet = true;
            }
        }
        return message;
    }

    public String getValue() {
        if (this.currentValueSet) {
            return Integer.toString(this.currentValue);
        }
        return VALUE_NOT_SET;
    }
}

