/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.colorSelector;

import COM.ibm.eNetwork.jdi.gui.colorSelector.ColoredCanvas;
import COM.ibm.eNetwork.jdi.gui.colorSelector.SpectrumPanel;
import COM.ibm.eNetwork.jdi.gui.jvcScrollbar.JVCScrollbar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class ColorSelectorLayout
implements LayoutManager {
    protected Hashtable hash = new Hashtable();
    public static final String COLORED_CANVAS = "cc";
    public static final String SPECTRUM_PANEL = "sp";
    public static final String SCROLLBAR_RED = "sbRed";
    public static final String SCROLLBAR_GREEN = "sbGreen";
    public static final String SCROLLBAR_BLUE = "sbBlue";
    public static final int SPACER = 5;
    public static final int COLORED_CANVAS_SIZE = 80;
    public static final int SPECTRUM_PANEL_WIDTH = 510;
    public static final int SPECTRUM_PANEL_HEIGHT = 255;
    public static final int SCROLLBAR_WIDTH = 23;
    public static final int WIDTH = 605;
    public static final int HEIGHT = 265;

    public void addLayoutComponent(String string, Component component) {
        this.hash.put(string, component);
    }

    public void removeLayoutComponent(Component component) {
        this.hash.remove(component);
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.minimumLayoutSize(container);
    }

    public Dimension minimumLayoutSize(Container container) {
        return new Dimension(605, 265);
    }

    public void layoutContainer(Container container) {
        try {
            Dimension dimension = container.getSize();
            SpectrumPanel spectrumPanel = (SpectrumPanel)this.hash.get(SPECTRUM_PANEL);
            ColoredCanvas coloredCanvas = (ColoredCanvas)this.hash.get(COLORED_CANVAS);
            JVCScrollbar jVCScrollbar = (JVCScrollbar)this.hash.get(SCROLLBAR_RED);
            JVCScrollbar jVCScrollbar2 = (JVCScrollbar)this.hash.get(SCROLLBAR_GREEN);
            JVCScrollbar jVCScrollbar3 = (JVCScrollbar)this.hash.get(SCROLLBAR_BLUE);
            this.positionSpectrumPanel(spectrumPanel, dimension);
            this.positionColoredCanvas(spectrumPanel, coloredCanvas, dimension);
            this.positionScrollbarRed(spectrumPanel, coloredCanvas, jVCScrollbar, dimension);
            this.positionScrollbarGreen(spectrumPanel, coloredCanvas, jVCScrollbar2, dimension);
            this.positionScrollbarBlue(spectrumPanel, coloredCanvas, jVCScrollbar3, dimension);
            return;
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this) + " layout error");
            return;
        }
    }

    protected void positionSpectrumPanel(SpectrumPanel spectrumPanel, Dimension dimension) {
        try {
            spectrumPanel.setBounds(5, 5, 510, 255);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void positionColoredCanvas(SpectrumPanel spectrumPanel, ColoredCanvas coloredCanvas, Dimension dimension) {
        try {
            int n = spectrumPanel.getLocation().x + spectrumPanel.getSize().width + 5;
            coloredCanvas.setBounds(n, 5, 80, 80);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void positionScrollbarRed(SpectrumPanel spectrumPanel, ColoredCanvas coloredCanvas, JVCScrollbar jVCScrollbar, Dimension dimension) {
        try {
            int n = coloredCanvas.getLocation().x;
            int n2 = coloredCanvas.getLocation().y + coloredCanvas.getSize().height + 5;
            int n3 = spectrumPanel.getLocation().y + spectrumPanel.getSize().height - n2;
            jVCScrollbar.setBounds(n, n2, 23, n3);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void positionScrollbarGreen(SpectrumPanel spectrumPanel, ColoredCanvas coloredCanvas, JVCScrollbar jVCScrollbar, Dimension dimension) {
        try {
            int n = coloredCanvas.getLocation().x + 5 + 23;
            int n2 = coloredCanvas.getLocation().y + coloredCanvas.getSize().height + 5;
            int n3 = spectrumPanel.getLocation().y + spectrumPanel.getSize().height - n2;
            jVCScrollbar.setBounds(n, n2, 23, n3);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void positionScrollbarBlue(SpectrumPanel spectrumPanel, ColoredCanvas coloredCanvas, JVCScrollbar jVCScrollbar, Dimension dimension) {
        try {
            int n = coloredCanvas.getLocation().x + 56;
            int n2 = coloredCanvas.getLocation().y + coloredCanvas.getSize().height + 5;
            int n3 = spectrumPanel.getLocation().y + spectrumPanel.getSize().height - n2;
            jVCScrollbar.setBounds(n, n2, 23, n3);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public String toString() {
        return "ColorSelectorLayout";
    }
}

