/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.colorSelector;

import COM.ibm.eNetwork.jdi.gui.colorSelector.SpectrumCanvas;
import COM.ibm.eNetwork.jdi.gui.colorSelector.SpectrumPanel;
import COM.ibm.eNetwork.jdi.gui.colorSelector.SpectrumPanelEvent;
import COM.ibm.eNetwork.jdi.gui.colorSelector.SpectrumPanelEventListener;
import COM.ibm.eNetwork.jdi.gui.common.Controler;
import COM.ibm.eNetwork.jdi.gui.common.ExtendedCanvas;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;

public class SpectrumPanelControler
extends Controler
implements MouseListener,
FocusListener,
MouseMotionListener {
    protected SpectrumPanel sp;
    protected SpectrumCanvas sc;

    public SpectrumPanelControler(SpectrumPanel spectrumPanel) {
        this.sp = spectrumPanel;
    }

    public void register(ExtendedCanvas extendedCanvas) {
        try {
            SpectrumCanvas spectrumCanvas = (SpectrumCanvas)extendedCanvas;
            spectrumCanvas.addMouseListener(this);
            spectrumCanvas.addMouseMotionListener(this);
            spectrumCanvas.addFocusListener(this);
            this.sc = spectrumCanvas;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void unregister(ExtendedCanvas extendedCanvas) {
        try {
            SpectrumCanvas spectrumCanvas = (SpectrumCanvas)extendedCanvas;
            spectrumCanvas.removeMouseListener(this);
            spectrumCanvas.removeMouseMotionListener(this);
            spectrumCanvas.removeFocusListener(this);
            this.sc = null;
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            this.sc.requestFocus();
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            if (this.bAutoFocus) {
                this.sc.requestFocus();
                return;
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            Point point = mouseEvent.getPoint();
            Color color = this.sc.findColor(point.x, point.y);
            this.sc.setPointer(point.x, point.y);
            this.createEvent(330, color);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }

    protected boolean isMyEvent(AWTEvent aWTEvent) {
        try {
            if (aWTEvent instanceof SpectrumPanelEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent aWTEvent) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            SpectrumPanelEvent spectrumPanelEvent = (SpectrumPanelEvent)aWTEvent;
            if (enumeration.hasMoreElements()) {
                SpectrumPanelEventListener spectrumPanelEventListener = (SpectrumPanelEventListener)enumeration.nextElement();
                return spectrumPanelEvent.sendEvent(spectrumPanelEventListener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected boolean createEvent(int n, Color color) {
        try {
            SpectrumPanelEvent spectrumPanelEvent = new SpectrumPanelEvent(this.sp, n, color);
            return this.postEvent(spectrumPanelEvent);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            Point point = mouseEvent.getPoint();
            Color color = this.sc.findColor(point.x, point.y);
            this.sc.setPointer(point.x, point.y);
            this.createEvent(329, color);
            return;
        }
        catch (Exception exception) {
            return;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

