/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.eNetwork.jdi.gui.statusBar;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import COM.ibm.eNetwork.jdi.gui.statusObject.StatusObjectCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class StatusBarCanvas
extends StatusObjectCanvas
implements Runnable {
    protected Thread thread;
    protected String LEFT_BRAC = "[ ";
    protected String RIGHT_BRAC = " ]";
    protected String sLabel = "";
    protected boolean bThreadedPaint = true;
    protected boolean bPainting = false;

    public StatusBarCanvas(String string, ColorsForCanvas colorsForCanvas, FontsForCanvas fontsForCanvas, ImagesForCanvas imagesForCanvas) {
        this.copyAttribs(colorsForCanvas, fontsForCanvas, imagesForCanvas);
        this.setAttribs();
        this.setLabel(string);
        this.startThread();
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.repaint2();
                    if (!this.bThreadedPaint) break;
                    this.thread.suspend();
                }
                return;
            }
            catch (Exception exception) {
                System.out.println("StatusBar: paint exception caught");
                continue;
            }
            break;
        }
    }

    public void repaint() {
        try {
            if (this.bPainting) {
                return;
            }
            if (this.bThreadedPaint) {
                if (this.thread == null) {
                    this.startThread();
                }
                this.thread.resume();
                return;
            }
            if (this.thread != null) {
                this.stopThread();
            }
            this.run();
            return;
        }
        catch (Exception exception) {
            System.out.println("StatusBar: paint exception caught");
            return;
        }
    }

    public void draw(Graphics graphics) {
        try {
            this.bPainting = true;
            Dimension dimension = this.getSize();
            int n = (int)((float)dimension.width * this.fPercent) - 1;
            Rectangle rectangle = new Rectangle(0, 0, dimension.width - 1, dimension.height - 1);
            graphics.setColor(this.cfcColor.getColor(2));
            graphics.fillRect(rectangle.x, rectangle.y, n, rectangle.height);
            this.drawText(graphics, rectangle);
            this.drawOutline(graphics, dimension);
            this.bPainting = false;
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public void setLabel(String string) {
        this.sLabel = string;
    }

    public void drawOutline(Graphics graphics, Dimension dimension) {
        SystemColor systemColor = SystemColor.control;
        Color color = systemColor.brighter();
        Color color2 = systemColor.darker();
        Color color3 = color2.darker();
        graphics.setColor(color);
        graphics.drawLine(0, 0, dimension.width, 0);
        graphics.drawLine(0, 0, 0, dimension.height);
        graphics.setColor(color2);
        graphics.drawLine(1, dimension.height - 1, dimension.width - 1, dimension.height - 1);
        graphics.drawLine(dimension.width - 1, dimension.height - 1, dimension.width - 1, 1);
        graphics.setColor(color3);
        graphics.drawLine(0, dimension.height, dimension.width, dimension.height);
        graphics.drawLine(dimension.width, dimension.height, dimension.width, 1);
    }

    public void drawText(Graphics graphics, Rectangle rectangle) {
        String string = String.valueOf(this.sLabel) + this.LEFT_BRAC + (int)(this.fPercent * 100.0f) + "%" + this.RIGHT_BRAC;
        int n = this.ffcFont.getStringWidth(string, 0);
        int n2 = (rectangle.height - this.ffcFont.getFontHeight(0)) / 2 + 3;
        graphics.setColor(this.cfcColor.getColor(1));
        graphics.drawString(string, (rectangle.width - n) / 2, rectangle.height - n2);
    }

    public void repaint2() {
        Graphics graphics = this.getGraphics();
        if (graphics == null) {
            super.repaint();
            return;
        }
        this.update(graphics);
    }

    public boolean getThreadedPaint() {
        return this.bThreadedPaint;
    }

    public void setThreadedPaint(boolean bl) {
        this.bThreadedPaint = bl;
    }

    protected void stopThread() {
        try {
            if (this.thread != null) {
                this.thread.stop();
                this.thread = null;
                return;
            }
        }
        catch (Exception exception) {
            System.err.println(exception);
        }
    }

    protected void startThread() {
        try {
            this.thread = new Thread(this);
            this.thread.setDaemon(true);
            this.thread.start();
            this.thread.suspend();
            return;
        }
        catch (Exception exception) {
            System.err.println(exception);
            return;
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }
}

