/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common;

import com.ibm.eNetwork.onDemand.common.CBData;
import com.ibm.eNetwork.onDemand.common.dataStructures.Queue;
import java.lang.reflect.Method;
import java.util.Hashtable;

public class CallbackManager
implements Runnable {
    protected Hashtable hashClients = new Hashtable();
    protected Queue queue = new Queue();
    protected Thread thread = new Thread(this);

    public static CallbackManager getCallbackManager() {
        return null;
    }

    protected CallbackManager() {
        this.thread.start();
    }

    public void run() {
        try {
            CBData data = null;
            while (true) {
                Queue queue = this.queue;
                synchronized (queue) {
                    while (this.queue.isEmpty()) {
                        this.queue.wait();
                    }
                }
                data = (CBData)this.queue.deQueue();
                this.processMethodCall(data);
            }
        }
        catch (Exception e) {
            System.err.println("Severe Error: CallbackManager has failed! run()" + e);
            return;
        }
    }

    protected void processMethodCall(CBData data) {
        try {
            Hashtable hashMethods = (Hashtable)this.hashClients.get(data.oCaller);
            Method method = (Method)hashMethods.get(data.sName);
            method.invoke(data.oCaller, data.oParams);
        }
        catch (Exception e) {
            System.err.println("Severe Error: Callback failed! processMethodCall() " + e);
        }
    }

    public void registerMethod(Object oCaller, String sName) throws NoSuchMethodException {
        if (oCaller == null || sName == null || sName.compareTo("") == 0) {
            throw new NoSuchMethodException(sName);
        }
        Class<?> c = oCaller.getClass();
        Method[] methods = c.getMethods();
        if (methods == null) {
            throw new NoSuchMethodException(sName);
        }
        int iIndex = methods.length;
        if (iIndex < 1) {
            return;
        }
        --iIndex;
        String sTemp = null;
        try {
            while (iIndex > -1) {
                sTemp = methods[iIndex].getName();
                if (sTemp != null && sTemp.compareTo(sName) == 0) {
                    this.hashMethod(oCaller, sName, methods[iIndex]);
                    return;
                }
                --iIndex;
            }
        }
        catch (Exception e) {
            System.err.println("Severe Error: Method not registered! " + e);
            throw new NoSuchMethodException(sName);
        }
    }

    protected void hashMethod(Object oCaller, String sName, Method method) {
        Hashtable<String, Method> hashMethods = (Hashtable<String, Method>)this.hashClients.get(oCaller);
        if (hashMethods == null) {
            hashMethods = new Hashtable<String, Method>();
            this.hashClients.put(oCaller, hashMethods);
        }
        hashMethods.put(sName, method);
    }

    public void doMethod(Object oCaller, String sFuncName, Object[] oParams) {
        try {
            CBData data = new CBData(oCaller, sFuncName, oParams);
            this.queue.enQueue((Object)data);
        }
        catch (Exception e) {
            System.err.println("Severe Error: Method not queued! " + e);
        }
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam) {
        Object[] oArray = new Object[]{oParam};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam, Object oParam2) {
        Object[] oArray = new Object[]{oParam, oParam2};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam, Object oParam2, Object oParam3) {
        Object[] oArray = new Object[]{oParam, oParam2, oParam3};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam, Object oParam2, Object oParam3, Object oParam4) {
        Object[] oArray = new Object[]{oParam, oParam2, oParam3, oParam4};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam, Object oParam2, Object oParam3, Object oParam4, Object oParam5) {
        Object[] oArray = new Object[]{oParam, oParam2, oParam3, oParam4, oParam5};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam, Object oParam2, Object oParam3, Object oParam4, Object oParam5, Object oParam6) {
        Object[] oArray = new Object[]{oParam, oParam2, oParam3, oParam4, oParam5, oParam6};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName, Object oParam, Object oParam2, Object oParam3, Object oParam4, Object oParam5, Object oParam6, Object oParam7) {
        Object[] oArray = new Object[]{oParam, oParam2, oParam3, oParam4, oParam5, oParam6, oParam7};
        this.doMethod(oCaller, sFuncName, oArray);
    }

    public void doMethod(Object oCaller, String sFuncName) {
        this.doMethod(oCaller, sFuncName, null);
    }
}

