/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.animatedProgressPanel;

import com.ibm.eNetwork.onDemand.common.gui.animationCanvas.AnimationCanvas;
import com.ibm.eNetwork.onDemand.common.gui.statusBar.StatusBar;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class AnimatedProgressPanelLayout
implements LayoutManager {
    protected Hashtable hash = new Hashtable();
    protected static final int XOFFSET = 3;
    protected static final int YOFFSET = 3;
    public static final String STATUS_BAR = "sb";
    public static final String ANIM_CANVAS = "ac";
    protected AnimationCanvas ac;
    protected StatusBar sb;

    public void addLayoutComponent(String name, Component comp) {
        this.hash.put(name, comp);
    }

    public void removeLayoutComponent(Component comp) {
        this.hash.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.minimumLayoutSize(parent);
    }

    public Dimension minimumLayoutSize(Container parent) {
        try {
            StatusBar sb = (StatusBar)this.hash.get(STATUS_BAR);
            AnimationCanvas ac = (AnimationCanvas)this.hash.get(ANIM_CANVAS);
            Dimension d = ac.getPreferredSize();
            d.width += 6;
            d.height += 9;
            d.height += sb.getPreferredSize().height;
            return d;
        }
        catch (Exception e) {
            System.err.println(e);
            return new Dimension(150, 150);
        }
    }

    public void layoutContainer(Container parent) {
        try {
            Dimension d = parent.getSize();
            this.resizeCanvas((AnimationCanvas)this.hash.get(ANIM_CANVAS), d);
            this.resizeStatusBar((StatusBar)this.hash.get(STATUS_BAR), d);
        }
        catch (Exception exception) {}
    }

    protected void resizeStatusBar(StatusBar sb, Dimension d) {
        try {
            this.sb = sb;
            Dimension dim = sb.getPreferredSize();
            sb.setBounds(3, d.height - dim.height - 3, d.width - 6, dim.height);
        }
        catch (Exception exception) {}
    }

    protected void resizeCanvas(AnimationCanvas ac, Dimension d) {
        try {
            this.ac = ac;
            Dimension dim = ac.getPreferredSize();
            ac.setBounds((d.width - 6) / 2 - dim.width / 2, 3, dim.width, dim.height);
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return "AnimatedProgressPanelLayout";
    }
}

