/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.attribView;

import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewNode;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableObject;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.common.ViewCanvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Vector;

public class AttribViewCanvas
extends ViewCanvas {
    protected boolean bDragging = false;
    protected int iMaxHeight;
    protected int iXoffset;
    protected Vector vOffsets;
    protected boolean bUpdateVector = true;
    protected AttribViewNode avnEnd;
    protected int iLastX = -1;
    protected int iStartX = -1;
    protected int iEdgeIndex = -1;
    protected AttribViewNode avnOne;
    protected AttribViewNode avnTwo;
    protected static final int DELTA = 10;
    protected static final int MIN_NODE_SIZE = 5;

    public AttribViewCanvas(ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        this.vOffsets = new Vector();
        boolean bPaintBackground = false;
        if (ifcImage.getImage(2) == null) {
            bPaintBackground = true;
        }
        this.avnEnd = new AttribViewNode("", cfcColor, ffcFont, ifcImage);
        this.avnEnd.setSize(10, 10);
        this.avnEnd.setBackgroundPainting(bPaintBackground);
        this.avnEnd.committ();
    }

    public void draw(Graphics g) {
        int iX = 0;
        Rectangle r = null;
        Dimension dim = null;
        Dimension dimCanvas = this.getSize();
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        Object intTemp = null;
        g.setColor(this.cfcColor.getColor(0));
        if (this.ifcImage.getImage(2) == null) {
            g.fillRect(0, 0, dimCanvas.width, dimCanvas.height);
        }
        while (lanTemp != null && iX < dimCanvas.width) {
            dim = lanTemp.getSize();
            r = new Rectangle(iX, 0, dim.width, dim.height);
            ((AttribViewNode)lanTemp).draw(g, r);
            iX += dim.width;
            this.lanCurrentEnd = lanTemp;
            lanTemp = (LeftAlignedNode)lanTemp.getNext();
        }
        if (lanTemp == null) {
            try {
                int iWidth = dimCanvas.width - iX;
                int iHeight = dimCanvas.height;
                this.avnEnd.setSize(iWidth, iHeight);
                r = new Rectangle(iX, 0, iWidth + 1, iHeight);
                this.avnEnd.draw(g, r);
            }
            catch (Exception exception) {}
        }
        this.updateVector();
    }

    public boolean setDragging(boolean bDragging) {
        boolean bSignalChange = false;
        if (!bDragging && this.bDragging) {
            this.completeDragging();
            bSignalChange = true;
        }
        if (bDragging && !this.bDragging) {
            this.startDragging();
        }
        this.bDragging = bDragging;
        return bSignalChange;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    protected void completeDragging() {
        int iDelta = this.iStartX - this.iLastX;
        try {
            Dimension d = this.avnOne.getSize();
            this.avnOne.setSize(d.width - iDelta, d.height);
            this.bUpdateVector = true;
            this.repaint();
        }
        catch (Exception exception) {}
        Point p = new Point(-1, -1);
        this.drag(p);
        this.iStartX = -1;
    }

    protected void startDragging() {
        AttribViewNode avnTemp = (AttribViewNode)this.lanCurrent;
        int i = 1;
        while (i < this.iEdgeIndex) {
            avnTemp = (AttribViewNode)avnTemp.getNext();
            ++i;
        }
        this.avnOne = avnTemp;
        this.avnTwo = (AttribViewNode)avnTemp.getNext();
        if (this.avnTwo == null && this.iEdgeIndex == this.vOffsets.size() - 2) {
            this.avnTwo = this.avnEnd;
        }
        if (this.avnOne == null || this.avnTwo == null) {
            this.avnOne = null;
            this.avnTwo = null;
        }
    }

    protected void XORLine(int x) {
        Dimension d = this.getSize();
        Graphics g = this.getGraphics();
        g.setXORMode(Color.white);
        g.drawLine(x, 0, x, d.height - 1);
        g.drawLine(x + 1, 0, x + 1, d.height - 1);
        g.setPaintMode();
    }

    public void drag(Point p) {
        try {
            if (!this.bDragging) {
                return;
            }
            if (this.avnOne != null) {
                Dimension d = this.avnOne.getSize();
                if (p.x < this.iStartX - d.width + 5) {
                    return;
                }
            }
            if (this.iLastX > 0) {
                this.XORLine(this.iLastX);
            }
            if (p.x > 0) {
                this.XORLine(p.x);
            }
            this.iLastX = p.x;
        }
        catch (Exception exception) {}
    }

    public String toString() {
        return "AttribView Canvas";
    }

    public Vector getFieldOffsets() {
        return this.vOffsets;
    }

    public void addNode(LeftAlignedNode lanNew, LeftAlignedNode lanPrev) {
        super.addNode(lanNew, lanPrev);
        if (lanNew != null && lanNew.getHeight() > this.iMaxHeight) {
            this.iMaxHeight = lanNew.getHeight();
        }
    }

    public void addNode(LeftAlignedNode lanNew) {
        super.addNode(lanNew);
        if (lanNew != null && lanNew.getHeight() > this.iMaxHeight) {
            this.iMaxHeight = lanNew.getHeight();
        }
        if (this.lanCurrent == null) {
            this.lanCurrent = this.lanTop;
        }
    }

    public int getMaxHeight() {
        return this.iMaxHeight;
    }

    public void committ() {
        AttribViewNode avnTemp = (AttribViewNode)this.lanTop;
        avnTemp = (AttribViewNode)this.lanTop;
        while (avnTemp != null) {
            avnTemp.setSize(avnTemp.getWidth(), this.iMaxHeight);
            avnTemp = (AttribViewNode)avnTemp.getNext();
        }
        this.bUpdateVector = true;
        this.updateVector();
        this.repaint();
    }

    private void updateVector() {
        if (!this.bUpdateVector) {
            return;
        }
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        Dimension dim = null;
        Integer intTemp = null;
        int iX = 0;
        this.vOffsets.removeAllElements();
        while (lanTemp != null) {
            dim = lanTemp.getSize();
            intTemp = new Integer(iX);
            this.vOffsets.addElement(intTemp);
            iX += dim.width;
            lanTemp = (LeftAlignedNode)lanTemp.getNext();
        }
        this.avnEnd.setSize(350, 1);
        this.vOffsets.addElement(new Integer(iX));
        this.vOffsets.addElement(new Integer(iX + 350));
        this.bUpdateVector = false;
    }

    public DrawableObject findOnMouseMove(int x, int y) {
        return null;
    }

    public DrawableObject findOnKeyUp(int key) {
        return null;
    }

    public DrawableObject findOnKeyDown(int key) {
        return null;
    }

    public DrawableObject findOnMouseUp(int x, int y) {
        return null;
    }

    public DrawableObject findOnMouseDown(int x, int y) {
        LeftAlignedNode lanTemp = (LeftAlignedNode)this.lanCurrent;
        Dimension dim = null;
        int iX = 0;
        while (lanTemp != null) {
            dim = lanTemp.getSize();
            if (x < (iX += dim.width)) {
                return lanTemp;
            }
            lanTemp = (LeftAlignedNode)lanTemp.getNext();
        }
        return null;
    }

    public DrawableObject findOnGotFocus() {
        return null;
    }

    public DrawableObject findCurrent() {
        return null;
    }

    public boolean isDraggablepoint(Point p) {
        try {
            int iEdge = 0;
            int i = 1;
            while (i < this.vOffsets.size()) {
                iEdge = (Integer)this.vOffsets.elementAt(i);
                if (p.x < iEdge + 10 && p.x > iEdge - 10) {
                    this.iEdgeIndex = i;
                    this.iStartX = p.x;
                    return true;
                }
                ++i;
            }
            return false;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void repaint() {
        Graphics g = this.getGraphics();
        if (g == null) {
            super.repaint();
            return;
        }
        this.update(g);
    }

    public int selectNode(AttribViewNode node) {
        if (node == null) {
            return 0;
        }
        if (this.lanSelected != null && node != this.lanSelected) {
            ((AttribViewNode)this.lanSelected).setSelected2(false);
        }
        int iConstraints = node.setSelected2(true);
        this.lanSelected = node;
        this.repaint();
        return iConstraints;
    }

    public void dispose() {
        super.dispose();
        AttribViewNode.clearImages();
    }
}

