/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.attribView;

import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribField;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribViewConstants;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class AttribViewNode
extends LeftAlignedNode
implements AttribViewConstants {
    protected boolean bFirst = false;
    protected boolean bLast = false;
    protected String sLabel;
    protected AttribField afField;
    protected int iIndex = -1;
    protected Image iSelectedImage;
    protected static Image iUp = null;
    protected static Image iDown = null;
    protected Component c;
    protected static int iPixWidthUp = 11;
    protected static int iPixHeightUp = 7;
    protected static int[] pixUp = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    protected static int iPixWidthDown = 11;
    protected static int iPixHeightDown = 7;
    protected static int[] pixDown = new int[]{-1, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, -1, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, -1, 0xFFFFFF, 0xFFFFFF, -1, -16777216, 0xFFFFFF, -1, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};

    public AttribViewNode(AttribField afField, Component c) {
        super(afField.getText(), afField.getColors(), afField.getFonts(), afField.getImage());
        this.afField = afField;
        this.createSelectedImages(c);
        this.c = c;
    }

    protected void createSelectedImages(Component c) {
        int i;
        int iLength;
        int iNewColor;
        if (iUp == null) {
            iNewColor = SystemColor.control.brighter().getRGB();
            iLength = iPixWidthUp * iPixHeightUp;
            try {
                i = 0;
                while (i < iLength) {
                    if (pixUp[i] == -1) {
                        AttribViewNode.pixUp[i] = iNewColor;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            iUp = ImagesForCanvas.createImage(c, iPixWidthUp, iPixHeightUp, pixUp);
        }
        if (iDown == null) {
            iNewColor = SystemColor.control.brighter().getRGB();
            iLength = iPixWidthDown * iPixHeightDown;
            try {
                i = 0;
                while (i < iLength) {
                    if (pixDown[i] == -1) {
                        AttribViewNode.pixDown[i] = iNewColor;
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            iDown = ImagesForCanvas.createImage(c, iPixWidthUp, iPixHeightDown, pixDown);
        }
    }

    public static void clearImages() {
        if (iDown != null) {
            iDown.flush();
            iDown = null;
        }
        if (iUp != null) {
            iUp.flush();
            iUp = null;
        }
    }

    public AttribViewNode(String sLabel, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(sLabel, cfcColor, ffcFont, ifcImage);
    }

    public int setSelected2(boolean bSelected) {
        int iConstraints = 0;
        if (this.getSelected() && bSelected) {
            if (this.iSelectedImage == iUp) {
                this.iSelectedImage = iDown;
                iConstraints = 1;
            } else {
                this.iSelectedImage = iUp;
                iConstraints = -1;
            }
        } else if (bSelected) {
            this.iSelectedImage = iDown;
            iConstraints = 1;
        } else {
            this.iSelectedImage = null;
        }
        this.setSelected(bSelected);
        return iConstraints;
    }

    public void draw(Graphics g, Rectangle area) {
        super.draw(g, area);
        if (this.getSortable()) {
            this.drawSelectedGraphic(g, area);
        }
        this.drawOutline(g, new Rectangle(area.x, area.y, area.width - 2, area.height - 2));
    }

    protected void drawSelectedGraphic(Graphics g, Rectangle area) {
        if (this.iSelectedImage == null) {
            return;
        }
        int iY = 0;
        int iImageHeight = this.ifcImage.getImageHeight(this.iSelectedImage);
        int iHeight = this.getSize().height;
        iY = (iHeight - iImageHeight) / 2;
        g.drawImage(this.iSelectedImage, this.getLocation().x + this.getSize().width - this.ifcImage.getImageWidth(iUp) - this.iHorzSpace, iY, null, this.c);
    }

    protected String computeText(int iFontType) {
        try {
            int iStringWidth;
            if (!this.getSortable()) {
                return super.computeText(iFontType);
            }
            int iWidth = this.getWidth() - this.ifcImage.getImageWidth(iFontType) - 2 * this.iHorzSpace;
            String sTemp = this.getText();
            if (this.iSelectedImage != null) {
                iWidth -= this.ifcImage.getImageWidth(this.iSelectedImage) + this.iHorzSpace;
            }
            if ((iStringWidth = this.ffcFont.getStringWidth(sTemp, iFontType)) < iWidth) {
                return sTemp;
            }
            int iDiff = iStringWidth - iWidth;
            int iCharSize = this.ffcFont.getFontAverageWidth(iFontType);
            int iDecChars = (int)((float)iDiff / (float)iCharSize + 3.0f);
            int iSize = sTemp.length() - iDecChars - 1;
            if (iSize < 1) {
                return "";
            }
            return String.valueOf(sTemp.substring(0, iSize)) + "...";
        }
        catch (Exception exception) {
            return "";
        }
    }

    public void drawOutline(Graphics g, Rectangle area) {
        Color cBack = this.cfcColor.getColor(0);
        Color cLight = cBack.brighter();
        Color cMed = cBack.darker();
        Color cDark = cMed.darker();
        g.setColor(cLight);
        g.drawLine(area.x, area.y, area.x + area.width, area.y);
        g.drawLine(area.x, area.y, area.x, area.y + area.height);
        g.setColor(cMed);
        g.drawLine(area.x + 1, area.y + area.height - 1, area.x + area.width - 1, area.y + area.height - 1);
        g.drawLine(area.x + area.width - 1, area.y + area.height - 1, area.x + area.width - 1, area.y + 1);
        g.setColor(cDark);
        g.drawLine(area.x, area.y + area.height, area.x + area.width, area.y + area.height);
        g.drawLine(area.x + area.width, area.y + area.height, area.x + area.width, area.y + 1);
    }

    public void committ() {
        Image iTemp;
        if (this.afField != null) {
            this.ffcFont = this.afField.getFonts();
            this.cfcColor = this.afField.getColors();
            this.ifcImage = this.afField.getImage();
            this.sText = this.afField.getText();
        }
        if (this.ifcImage.getImage(1) == null && (iTemp = this.ifcImage.getImage(0)) != null) {
            this.ifcImage.addImage(iTemp, 1);
        }
        super.committ();
        if (this.afField != null) {
            if (this.afField.getWidth() != -1) {
                this.setSize(this.afField.getWidth(), this.getSize().height);
            } else {
                Dimension d = this.getSize();
                if (this.getSortable()) {
                    d.width += this.ifcImage.getImageWidth(iUp) + this.iHorzSpace;
                }
                this.setSize(d.width, d.height);
            }
        }
    }

    protected void setFirst(boolean bFirst) {
        this.bFirst = bFirst;
    }

    protected void setLast(boolean bLast) {
        this.bLast = bLast;
    }

    public AttribField getAttribField() {
        return this.afField;
    }

    public int getIndex() {
        return this.iIndex;
    }

    public void setIndex(int iIndex) {
        this.iIndex = iIndex;
    }

    public boolean getSortable() {
        return this.afField.getSortable();
    }
}

