/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.dbCanvasImageIndexMap;
import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;

public abstract class DBCanvas
extends Canvas
implements dbCanvasImageIndexMap {
    protected Graphics gOffscreen;
    protected Image iOffscreen;
    protected Dimension dSize = new Dimension(13333, 1);
    public ImagesForCanvas ifcImage = new ImagesForCanvas();
    public ColorsForCanvas cfcColor = new ColorsForCanvas();

    public abstract void draw(Graphics var1);

    public Graphics startPaint(Graphics g) {
        if (this.canUseDoubleBuffering()) {
            return this.gOffscreen;
        }
        return g;
    }

    public void endPaint(Graphics g) {
        if (this.iOffscreen != null) {
            g.drawImage(this.iOffscreen, 0, 0, this);
        }
    }

    private boolean canUseDoubleBuffering() {
        Dimension dSize = this.getSize();
        if (dSize.width > 0 && dSize.height > 0) {
            if (this.dSize.width != dSize.width || this.dSize.height != dSize.height) {
                try {
                    if (this.iOffscreen != null) {
                        this.iOffscreen.flush();
                        this.iOffscreen = null;
                    }
                    this.iOffscreen = this.createImage(dSize.width, dSize.height);
                }
                catch (Exception exception) {
                    return false;
                }
                if (this.iOffscreen == null) {
                    return false;
                }
                if (this.gOffscreen != null) {
                    this.gOffscreen.dispose();
                    System.gc();
                }
                this.gOffscreen = this.iOffscreen.getGraphics();
                if (this.gOffscreen == null) {
                    return false;
                }
                this.dSize = dSize;
                return true;
            }
            return true;
        }
        return false;
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Graphics g1 = this.startPaint(g);
        Dimension d = this.getSize();
        if (!this.tileBackground(g1, d.width, d.height)) {
            this.paintBackground(g1, d);
        }
        this.draw(g1);
        this.endPaint(g);
    }

    protected void paintBackground(Graphics g, Dimension dim) {
        g.setColor(this.cfcColor.getColor(0));
        g.fillRect(0, 0, dim.width, dim.height);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean tileBackground(Graphics g, int width, int height) {
        int iWidth = 0;
        int iHeight = 0;
        int x = 0;
        int y = 0;
        Image iImage = null;
        if (this.ifcImage == null) return false;
        iImage = this.ifcImage.getImage(2);
        if (iImage == null) return false;
        iWidth = this.ifcImage.getImageWidth(2);
        iHeight = this.ifcImage.getImageHeight(2);
        if (iWidth == 0 || iHeight == 0) {
            return false;
        }
        do {
            x = 0;
            do {
                g.drawImage(iImage, x, y, this.ifcImage);
            } while ((x += iWidth) < width);
        } while ((y += iHeight) < height);
        return true;
    }

    public void copyAttribs(ColorsForCanvas cfcColor, ImagesForCanvas ifcImage) {
        this.cfcColor = cfcColor == null ? new ColorsForCanvas() : cfcColor;
        this.ifcImage = ifcImage == null ? new ImagesForCanvas() : ifcImage;
    }

    public void setAttribs() {
        this.setColors(this.cfcColor);
        this.setGraphics(this.ifcImage);
    }

    public void setColors(ColorsForCanvas cfcColor) {
        this.cfcColor = cfcColor == null ? new ColorsForCanvas() : cfcColor;
        this.setBackground(this.cfcColor.getColor(0));
        this.setForeground(this.cfcColor.getColor(1));
    }

    public void setGraphics(ImagesForCanvas ifcImage) {
        this.ifcImage = ifcImage == null ? new ImagesForCanvas() : ifcImage;
    }

    public void dispose() {
        try {
            this.finalize();
        }
        catch (Throwable t) {
            System.err.println("TreeViewCanvas " + t);
        }
    }

    protected void finalize() throws Throwable {
        if (this.iOffscreen != null) {
            this.iOffscreen.flush();
            this.iOffscreen = null;
        }
        if (this.gOffscreen != null) {
            this.gOffscreen.dispose();
            this.gOffscreen = null;
        }
        super.finalize();
    }
}

