/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.common;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedNode;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class DrawableNode
extends ExtendedNode {
    protected DrawableNode dnNext;
    protected DrawableNode dnPrev;
    public static final int ICON = 0;
    public static final int BACKGROUND = 1;
    protected boolean bPaintBackground = true;
    protected boolean bSelected = false;
    protected boolean bOnScreen = false;

    public DrawableNode(String sText, DrawableNode dnPrev, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(sText, cfcColor, ffcFont, ifcImage);
        this.insertPrevNode(dnPrev);
    }

    public DrawableNode(String sText, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        super(sText, cfcColor, ffcFont, ifcImage);
    }

    public void insertNextNode(DrawableNode dnNext) {
        DrawableNode dnTemp = this.dnNext;
        this.setNext(dnNext);
        if (dnNext != null) {
            dnNext.setPrev(this);
            if (dnTemp != null) {
                dnTemp.setPrev(dnNext);
                dnNext.setNext(dnTemp);
            }
        }
    }

    public void setNext(DrawableNode dnNext) {
        this.dnNext = dnNext;
    }

    public void setPrev(DrawableNode dnPrev) {
        this.dnPrev = dnPrev;
    }

    public void insertPrevNode(DrawableNode dnPrev) {
        DrawableNode dnPrevNext = null;
        if (dnPrev != null) {
            dnPrevNext = dnPrev.getNext();
            dnPrev.setNext(this);
            this.setNext(dnPrevNext);
            if (dnPrevNext != null) {
                dnPrevNext.setPrev(this);
            }
        }
        this.setPrev(dnPrev);
    }

    public DrawableNode getPrev() {
        return this.dnPrev;
    }

    public DrawableNode getNext() {
        return this.dnNext;
    }

    public boolean removeMe() {
        if (this.dnPrev != null) {
            this.dnPrev.setNext(this.dnNext);
        }
        if (this.dnNext != null) {
            this.dnNext.setPrev(this.dnPrev);
        }
        return true;
    }

    public DrawableNode killMe() {
        DrawableNode dnNext = this.dnNext;
        this.dnPrev = null;
        this.dnNext = null;
        return dnNext;
    }

    public void setBackgroundPainting(boolean bPaintBackground) {
        this.bPaintBackground = bPaintBackground;
    }

    protected void paintBackground(Graphics g, Rectangle area) {
        if (!this.bPaintBackground) {
            return;
        }
        g.setColor(this.cfcColor.getColor(0));
        g.fillRect(area.x, area.y, area.width, area.height);
    }

    public boolean getSelected() {
        return this.bSelected;
    }

    public void setSelected(boolean bSelected) {
        this.bSelected = bSelected;
    }

    public boolean isOnScreen() {
        return this.bOnScreen;
    }

    public void onScreen(boolean bOnScreen) {
        this.bOnScreen = bOnScreen;
    }
}

