/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.explorerView;

import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribField;
import com.ibm.eNetwork.onDemand.common.gui.attribView.AttribFieldEventListener;
import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.explorerView.ExplorerDetailsView;
import com.ibm.eNetwork.onDemand.common.gui.explorerView.ExplorerTreeView;
import com.ibm.eNetwork.onDemand.common.gui.explorerView.ExplorerViewControler;
import com.ibm.eNetwork.onDemand.common.gui.explorerView.ExplorerViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.explorerView.ExplorerViewLayout;
import com.ibm.eNetwork.onDemand.common.gui.splitterPanel.SplitterPanel;
import com.ibm.eNetwork.onDemand.common.gui.treeView.CommitTypes;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.treeViewDragManager;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.PopupMenu;
import java.util.Vector;

public class ExplorerView
extends ExtendedPanel
implements CommitTypes {
    protected ExplorerViewControler evCon;
    protected ExplorerTreeView tv;
    protected ExplorerDetailsView dv;
    protected addableToTreeView attvRoot;
    protected Dimension dimView;
    protected ExplorerViewLayout explorerLayoutManager;

    public ExplorerView(addableToTreeView attvRoot, Dimension dimView, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage, Image iPlus, Image iMinus) {
        this.attvRoot = attvRoot;
        this.dimView = dimView;
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        SplitterPanel sp = new SplitterPanel();
        this.setLayout(new BorderLayout());
        this.add("Center", sp);
        this.tv = new ExplorerTreeView(attvRoot, new Dimension((int)((double)dimView.width * 0.4), dimView.height), cfcColor, ffcFont, ifcImage, iPlus, iMinus);
        this.createDetailsView(iPlus, iMinus);
        sp.add(this.tv);
        sp.add(this.dv);
        this.evCon = new ExplorerViewControler(this, this.tv, this.dv);
        this.setSize(dimView);
    }

    public addableToTreeView getRootNode() {
        return this.attvRoot;
    }

    public void createDetailsView(Image iPlus, Image iMinus) {
        ImagesForCanvas ifcTemp = new ImagesForCanvas();
        ifcTemp.addImage(this.ifcImage.getImage(0), 2);
        this.dv = new ExplorerDetailsView(this.attvRoot, new Dimension((int)((double)this.dimView.width * 0.6000000000000001), this.dimView.height), this.cfcColor, this.ffcFont, ifcTemp, iPlus, iMinus);
        this.dv.setNodeLineDrawing(false);
    }

    public void empty() {
        this.tv.empty();
        this.dv.empty();
    }

    public void committ(boolean bNumNodesChanged) {
        this.tv.committ(bNumNodesChanged);
        this.updateDetailsView();
        this.dv.committ(bNumNodesChanged);
    }

    public void commit(int iType) {
        this.tv.commit(iType);
        this.updateDetailsView();
        this.dv.commit(iType);
    }

    protected void updateDetailsView() {
        addableToTreeView node = this.findSelectedTreeViewFolder();
        if (node != null) {
            this.evCon.setDetailsViewNode(node, false);
        }
    }

    public addableToTreeView findSelectedTreeViewNode() {
        return this.dv.findSelectedTreeViewNode();
    }

    public Vector findSelectedTreeViewNodes() {
        return this.dv.findSelectedTreeViewNodes();
    }

    public addableToTreeView findSelectedTreeViewFolder() {
        return this.tv.findSelectedTreeViewNode();
    }

    public String toString() {
        return "ExplorerView [root=" + this.attvRoot.getText() + "]";
    }

    public void showTreeViewNode(addableToTreeView attvNode) {
        addableToTreeView parent = attvNode.getParentNode();
        this.updateTreeViewFolder(parent);
    }

    public void showTreeViewFolder(addableToTreeView attvNode) {
        addableToTreeView child = attvNode.getChildNode();
        this.updateTreeViewFolder(child);
        this.tv.showTreeViewNode(attvNode);
    }

    public void selectTreeViewNode(addableToTreeView attvNode) {
        try {
            this.dv.selectTreeViewNode(attvNode);
            this.tv.selectTreeViewNode(attvNode);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void unSelectTreeViewNode() {
        try {
            this.dv.unSelectTreeViewNode();
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void unSelectTreeViewFolder() {
        this.tv.unSelectTreeViewNode();
        this.dv.unSelectTreeViewNode();
    }

    public void expandTreeViewFolder(addableToTreeView attvNode, boolean bExpanded, boolean bCommitt) {
        this.tv.expandTreeViewNode(attvNode, bExpanded, bCommitt);
    }

    public void setAutoFocus(boolean bAutoFocus) {
        this.tv.setAutoFocus(bAutoFocus);
        this.dv.setAutoFocus(bAutoFocus);
    }

    public void expandAllFolders() {
        this.tv.expandAllNodes();
    }

    public void collapseAllFolders() {
        this.tv.collapseAllNodes();
    }

    public void addExplorerViewEventListener(ExplorerViewEventListener listener) {
        this.evCon.addListener(listener);
    }

    public void removeExplorerViewEventListener(ExplorerViewEventListener listener) {
        this.evCon.removeListener(listener);
    }

    public void setPopupMenuForNode(PopupMenu pop) {
        this.dv.setPopupMenu(pop);
    }

    public void setPopupMenuForFolder(PopupMenu pop) {
        this.tv.setPopupMenu(pop);
    }

    public PopupMenu getPopupMenuForNode() {
        return this.dv.getPopupMenu();
    }

    public PopupMenu getPopupMenuForFolder() {
        return this.tv.getPopupMenu();
    }

    public void addAttribField(AttribField afNode) {
        this.dv.addAttribField(afNode);
    }

    public void removeAttribField(AttribField afNode) {
        this.dv.removeAttribField(afNode);
    }

    public void setWaitCursor() {
        this.tv.setWaitCursor();
        this.dv.setWaitCursor();
    }

    public void clearWaitCursor() {
        this.tv.clearWaitCursor();
        this.dv.clearWaitCursor();
    }

    public void updateTreeViewFolder(addableToTreeView node) {
        this.evCon.updateTreeViewFolder(node);
    }

    public void setMultiSelect(boolean bMultiSelect) {
        this.dv.setMultiSelect(bMultiSelect);
        this.tv.setMultiSelect(false);
    }

    public void setPopupMenuForMultiSelect(PopupMenu pop) {
        this.dv.setMultiPopupMenu(pop);
        this.tv.setMultiPopupMenu(null);
    }

    public void setExplorerViewDragManager(treeViewDragManager manager) {
        this.tv.setTreeViewDragManager(manager);
        this.dv.setTreeViewDragManager(manager);
    }

    public void dispose() {
        this.tv.dispose();
        this.dv.dispose();
    }

    public void setAttribFieldEventListener(AttribFieldEventListener listener) {
        this.dv.setAttribFieldEventListener(listener);
    }
}

