/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar;

import com.ibm.eNetwork.onDemand.common.Timer;
import com.ibm.eNetwork.onDemand.common.TimerListener;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.imageButton.ImageButton;
import java.awt.Image;
import java.awt.event.MouseEvent;

public class JVCScrollbarButton
extends ImageButton
implements TimerListener {
    public static final int UP = 1;
    public static final int DOWN = 2;
    public static final int LEFT = 3;
    public static final int RIGHT = 4;
    protected int iType = 1;
    protected static int iRightWidth = 4;
    protected static int iRightHeight = 7;
    protected static int[] pixRight = new int[]{-16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    protected static int iDownWidth = 7;
    protected static int iDownHeight = 4;
    protected static int[] pixDown = new int[]{-16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF};
    protected static int iLeftWidth = 4;
    protected static int iLeftHeight = 7;
    protected static int[] pixLeft = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216};
    protected static int iUpWidth = 7;
    protected static int iUpHeight = 4;
    protected static int[] pixUp = new int[]{0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, 0xFFFFFF, 0xFFFFFF, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, 0xFFFFFF, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};
    protected static Timer timer = null;
    protected boolean bTimerStarted = false;
    public static int SCROLL_DELAY = 100;

    public JVCScrollbarButton(int iType) {
        Image image = this.createButtonImage(iType);
        this.setSettings(image, null, null, "", false, 2, 10, false, false);
        this.iType = iType;
        this.commit();
        if (timer == null) {
            timer = new Timer(SCROLL_DELAY);
        }
    }

    protected Image createButtonImage(int iType) {
        try {
            int width = 0;
            int height = 0;
            int[] pix = null;
            switch (iType) {
                case 2: {
                    width = iDownWidth;
                    height = iDownHeight;
                    pix = pixDown;
                    break;
                }
                case 3: {
                    width = iLeftWidth;
                    height = iLeftHeight;
                    pix = pixLeft;
                    break;
                }
                case 4: {
                    width = iRightWidth;
                    height = iRightHeight;
                    pix = pixRight;
                    break;
                }
                default: {
                    width = iUpWidth;
                    height = iUpHeight;
                    pix = pixUp;
                }
            }
            Image image = ImagesForCanvas.createImage(this, width, height, pix);
            return image;
        }
        catch (Exception exception) {
            System.err.println("Image for button[] not created");
            return null;
        }
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public int getType() {
        return this.iType;
    }

    public void setEnabled(boolean bEnabled) {
        super.setEnabled(bEnabled);
        this.repaint();
    }

    public void mousePressed(MouseEvent e) {
        super.mousePressed(e);
        timer.addTimerListener(this);
        this.bTimerStarted = true;
    }

    public void mouseEntered(MouseEvent e) {
        if (this.bTimerStarted) {
            timer.addTimerListener(this);
        }
        super.mouseEntered(e);
    }

    public void mouseExited(MouseEvent e) {
        if (this.bTimerStarted) {
            timer.removeTimerListener(this);
        }
        super.mouseExited(e);
    }

    public void mouseReleased(MouseEvent e) {
        super.mouseReleased(e);
        timer.removeTimerListener(this);
        this.bTimerStarted = false;
    }

    public void timerFired() {
        MouseEvent e = new MouseEvent(this, 0, System.currentTimeMillis(), 0, 1, 1, 1, false);
        super.mousePressed(e);
        super.mouseReleased(e);
    }
}

