/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbarSlider;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.orientations;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.SystemColor;

public class JVCScrollbarCanvas
extends ExtendedCanvas
implements orientations {
    protected int iMax = 10;
    protected int iMin = 1;
    protected int iOrientation = 1;
    protected int iVisible = 1;
    protected int iUnitInc = 1;
    protected int iBlockInc = 1;
    protected int iValue = 1;
    public static final int UNIT_INCREMENT = -1;
    public static final int UNIT_DECREMENT = -2;
    public static final int BLOCK_INCREMENT = -3;
    public static final int BLOCK_DECREMENT = -4;
    public static final int BELOW_SLIDER = 1;
    public static final int ABOVE_SLIDER = 2;
    public static final int ON_SLIDER = 3;
    public static final int NO_POS = 4;
    protected Point pSlider;
    protected Dimension dSlider;
    protected JVCScrollbarSlider slider;
    protected boolean bDragging = false;

    public JVCScrollbarCanvas() {
        this.cfcColor.addColor(new Color(214, 214, 214), 0);
        this.pSlider = new Point(1, 1);
        this.dSlider = new Dimension(10, 10);
        this.slider = new JVCScrollbarSlider(this.cfcColor, this.ffcFont, this.ifcImage);
    }

    public JVCScrollbarCanvas(ColorsForCanvas cfcColor, ImagesForCanvas ifcImage) {
        this.copyAttribs(cfcColor, this.ffcFont, ifcImage);
        this.setAttribs();
        this.pSlider = new Point(1, 1);
        this.dSlider = new Dimension(10, 10);
        this.slider = new JVCScrollbarSlider(cfcColor, this.ffcFont, ifcImage);
    }

    public void committ() {
    }

    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.calcSliderSize();
    }

    public void setSize(Dimension d) {
        this.setSize(d.width, d.height);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.calcSliderSize();
    }

    protected void calcSliderSize() {
        try {
            Dimension d = this.getSize();
            if (this.iOrientation == 1) {
                d.height /= this.iMax;
                if (d.height < 5) {
                    d.height = 5;
                }
            } else {
                d.width /= this.iMax;
                if (d.width < 5) {
                    d.width = 5;
                }
            }
            this.dSlider = d;
        }
        catch (Exception exception) {}
    }

    public void draw(Graphics g) {
        try {
            Dimension d = this.getSize();
            Rectangle area = new Rectangle(0, 0, d.width, d.height);
            g.setColor(SystemColor.control.brighter());
            if (this.iOrientation == 1) {
                g.drawRect(area.x, area.y - 1, area.width - 1, area.height + 1);
                this.slider.draw(g, new Rectangle(this.pSlider.x, this.pSlider.y, this.dSlider.width - 3, this.dSlider.height));
            } else {
                g.drawRect(area.x - 1, area.y, area.width + 1, area.height - 1);
                this.slider.draw(g, new Rectangle(this.pSlider.x, this.pSlider.y, this.dSlider.width, this.dSlider.height - 3));
            }
        }
        catch (Exception exception) {}
    }

    public void setMaximum(int iMax) {
        if (iMax < 1) {
            iMax = 1;
        }
        this.iMax = iMax;
        this.calcSliderSize();
        this.setValue(this.iValue);
    }

    public int getMaximum() {
        return this.iMax;
    }

    public int getValue() {
        return this.iValue;
    }

    public void setValue(int iValue) {
        if (iValue == -1) {
            this.setValue(this.iValue + this.iUnitInc);
            return;
        }
        if (iValue == -2) {
            this.setValue(this.iValue - this.iUnitInc);
            return;
        }
        if (iValue == -4) {
            this.setValue(this.iValue - this.iBlockInc);
            return;
        }
        if (iValue == -3) {
            this.setValue(this.iValue + this.iBlockInc);
            return;
        }
        if (iValue < this.iMin) {
            iValue = this.iMin;
        }
        if (iValue > this.iMax) {
            iValue = this.iMax;
        }
        this.iValue = iValue;
        this.calcSliderPos();
        this.repaint();
    }

    protected void calcSliderPos() {
        try {
            float fPercent = (float)(this.iValue - this.iMin) / (float)(this.iMax - this.iMin);
            Dimension d = this.getSize();
            if (this.iOrientation == 1) {
                d.height -= this.dSlider.height;
                this.pSlider.y = (int)((float)d.height * fPercent);
            } else {
                d.width -= this.dSlider.width;
                this.pSlider.x = (int)((float)d.width * fPercent);
            }
        }
        catch (Exception exception) {}
    }

    public void setMinimum(int iMin) {
        if (iMin < 0) {
            return;
        }
        this.iMin = iMin;
    }

    public int getMinimum() {
        return this.iMin;
    }

    public void setVisibleAmount(int iVisible) {
        this.iVisible = iVisible;
    }

    public int getVisibleAmount() {
        return this.iVisible;
    }

    public void setOrientation(int iOrientation) {
        this.iOrientation = iOrientation;
    }

    public int getOrientation() {
        return this.iOrientation;
    }

    public void setBlockIncrement(int iBlockInc) {
        if (iBlockInc > this.iMax / 2) {
            iBlockInc = this.iMax / 2;
        }
        this.iBlockInc = iBlockInc;
    }

    public int getBlockIncrement() {
        return this.iBlockInc;
    }

    public void setUnitIncrement(int iUnitInc) {
        this.iUnitInc = iUnitInc;
    }

    public int getUnitIncrement() {
        return this.iUnitInc;
    }

    public void setDragging(boolean bDragging) {
        this.bDragging = bDragging;
    }

    public int getMouseToSliderPos(Point pHit) {
        if (this.iOrientation == 1) {
            if (pHit.y < this.pSlider.y) {
                return 2;
            }
            if (pHit.y > this.pSlider.y + this.dSlider.height) {
                return 1;
            }
            return 3;
        }
        if (this.iOrientation == 0) {
            if (pHit.x < this.pSlider.x) {
                return 2;
            }
            if (pHit.x > this.pSlider.x + this.dSlider.width) {
                return 1;
            }
            return 3;
        }
        return 4;
    }

    public boolean dragSlider(Point pDrag) {
        if (!this.bDragging) {
            return false;
        }
        int iValue = 0;
        float fPercent = 0.0f;
        Dimension d = this.getSize();
        if (this.iOrientation == 1) {
            fPercent = (float)pDrag.y / (float)d.height;
            iValue = (int)(fPercent * (float)(this.iMax - this.iMin)) + this.iMin;
        } else {
            fPercent = (float)pDrag.x / (float)d.width;
            iValue = (int)(fPercent * (float)(this.iMax - this.iMin)) + this.iMin;
        }
        this.setValue(iValue);
        return true;
    }

    public boolean isFocusTraversable() {
        return false;
    }

    public String toString() {
        if (this.iOrientation == 1) {
            return "Vertical JVCScrollbar Canvas";
        }
        return "Horizontal JVCScrollbar Canvas";
    }
}

