/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.layoutManagers;

import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Panel;
import java.util.Enumeration;
import java.util.Vector;

public class VerticalLayout
implements LayoutManager,
LayoutManager2 {
    boolean bSizesEstablished = false;
    int nVGap;
    int nWidth;
    int nHeight;
    Vector vComponents;
    protected static final boolean DEBUG = true;

    public VerticalLayout() {
        this(0);
    }

    public VerticalLayout(int nVGap) {
        this.nVGap = nVGap;
        this.vComponents = new Vector(10);
    }

    public static void main(String[] args) {
        Frame f = new Frame();
        Panel p = new Panel();
        p.setLayout(new VerticalLayout(5));
        p.add(new Button("hey!"));
        p.add(new Button("chicken"));
        p.add(new Button("and jelly!!!"));
        p.add(new Button("is good"));
        p.add(new Button("on"));
        p.add(new Button("biscuits"));
        ((Component)f).setBackground(Color.lightGray);
        f.add(p);
        f.pack();
        f.show();
    }

    public void addLayoutComponent(String name, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension preferredLayoutSize(Container parent) {
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Insets i = parent.getInsets();
        return new Dimension(this.nWidth + i.left + i.right, this.nHeight + i.top + i.bottom);
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets i = parent.getInsets();
        Dimension d = new Dimension(this.nWidth + i.left + i.right, this.nHeight + i.top + i.bottom);
        return d;
    }

    protected void establishSizes() {
        Enumeration e = this.vComponents.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            Dimension d = c.getPreferredSize();
            this.nWidth = Math.max(this.nWidth, d.width);
            this.nHeight += d.height + this.nVGap;
        }
        this.bSizesEstablished = true;
    }

    public void layoutContainer(Container parent) {
        Dimension dParent = parent.getSize();
        Insets i = parent.getInsets();
        int nVPos = i.top;
        if (!this.bSizesEstablished) {
            this.establishSizes();
        }
        Enumeration e = this.vComponents.elements();
        while (e.hasMoreElements()) {
            Component c = (Component)e.nextElement();
            if (!c.isVisible()) continue;
            Dimension d = c.getPreferredSize();
            c.setSize(this.nWidth, d.height);
            c.setLocation(i.left, nVPos);
            nVPos += d.height + this.nVGap;
        }
    }

    public void addLayoutComponent(Component comp, Object constraints) {
        if (comp != null) {
            this.vComponents.addElement(comp);
            this.bSizesEstablished = false;
        } else {
            System.out.println("ASSERT VerticalLayout.addLayoutComponent:  could not add " + comp);
        }
    }

    public Dimension maximumLayoutSize(Container parent) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public float getLayoutAlignmentX(Container parent) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container parent) {
        return 0.0f;
    }

    public void invalidateLayout(Container parent) {
    }
}

