/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.memoryTextField;

import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;

public class MemoryTextField
extends TextField
implements KeyListener {
    protected Vector cmdHist;
    protected int chp = -1;

    public MemoryTextField(String text, int length, int iHistory) {
        super(text, length);
        this.addKeyListener(this);
        this.cmdHist = new Vector(iHistory);
        this.cmdHist.addElement("");
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyPressed(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int key = e.getKeyCode();
        switch (key) {
            case 10: {
                String sTemp = this.getText();
                if (sTemp.equals("")) break;
                this.processCmd(sTemp);
                break;
            }
            case 38: {
                if (this.chp == -1) {
                    this.chp = this.cmdHist.size();
                }
                --this.chp;
                if (this.chp < 0) {
                    this.chp = this.cmdHist.size() - 1;
                }
                ((TextComponent)this).setText((String)this.cmdHist.elementAt(this.chp));
                break;
            }
            case 40: {
                ++this.chp;
                if (this.chp >= this.cmdHist.size()) {
                    this.chp = 0;
                }
                ((TextComponent)this).setText((String)this.cmdHist.elementAt(this.chp));
                break;
            }
        }
    }

    public void processCmd(String cmd) {
        int ind = this.cmdHist.indexOf(cmd);
        if (ind != -1) {
            this.cmdHist.removeElementAt(ind);
        }
        this.cmdHist.addElement(cmd);
        this.chp = -1;
    }
}

