/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.menuPanel;

import com.ibm.eNetwork.onDemand.common.gui.menuPanel.JDIMenu;
import com.ibm.eNetwork.onDemand.common.gui.menuPanel.MenuListener;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Menu;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Enumeration;
import java.util.Vector;

public class MenuPanel
extends Panel
implements WindowListener,
KeyListener {
    protected static final int THICKNESS = 1;
    Vector vMenus;
    int nMetaMask;
    Vector vMenuListeners;
    Container cParent;

    public static void main(String[] args) {
        Frame f = new Frame();
        MenuPanel menu = new MenuPanel();
        PopupMenu popup = new PopupMenu("File");
        popup.add(new MenuItem("New"));
        popup.add(new MenuItem("Open"));
        popup.addSeparator();
        popup.add(new MenuItem("Close"));
        menu.add(popup, new MenuShortcut(70));
        popup = new PopupMenu("Edit");
        popup.add(new MenuItem("Copy"));
        popup.add(new MenuItem("Paste"));
        popup.addSeparator();
        popup.add(new MenuItem("Delete"));
        Menu nestedMenu = new Menu("Try this");
        nestedMenu.add(new MenuItem("Option A"));
        nestedMenu.add(new MenuItem("Option B"));
        popup.add(nestedMenu);
        menu.add(popup, new MenuShortcut(69));
        f.addWindowListener(menu);
        f.add((Component)menu, "North");
        ((Component)f).setSize(400, 300);
        f.show();
        menu.setEnableShortcuts(f);
    }

    public void paint(Graphics g) {
        Dimension d = this.getSize();
        SystemColor light = SystemColor.controlLtHighlight;
        SystemColor dark = SystemColor.controlShadow;
        g.setColor(light);
        int i = 0;
        while (i < 1) {
            g.drawLine(i, i, d.width - i - 2, i);
            g.drawLine(i, i + 1, i, d.height - i - 1);
            ++i;
        }
        g.setColor(dark);
        int i2 = 0;
        while (i2 < 1) {
            g.drawLine(i2 + 1, d.height - i2 - 1, d.width - i2 - 1, d.height - i2 - 1);
            g.drawLine(d.width - i2 - 1, i2, d.width - i2 - 1, d.height - i2 - 2);
            ++i2;
        }
    }

    public MenuPanel() {
        this.setLayout(new FlowLayout(0));
        this.setBackground(SystemColor.control);
        this.vMenus = new Vector();
        this.vMenuListeners = new Vector();
        this.nMetaMask = 8;
    }

    public void add(PopupMenu popup, MenuShortcut shortcut) {
        JDIMenu label = new JDIMenu(popup, shortcut, this.vMenuListeners);
        label.add(popup);
        this.vMenus.addElement(label);
        this.add(label);
    }

    public void add(PopupMenu popup) {
        this.add(popup, null);
    }

    public void setEnabled(PopupMenu popup, boolean bEnabled) {
        Enumeration e = this.vMenus.elements();
        while (e.hasMoreElements()) {
            JDIMenu label = (JDIMenu)e.nextElement();
            if (label == null || popup != label.getPopupMenu()) continue;
            label.setEnabled(bEnabled);
        }
    }

    public void setEnabled(int nMenuIndex, boolean bEnabled) {
        JDIMenu label = (JDIMenu)this.vMenus.elementAt(nMenuIndex);
        if (label != null) {
            label.setEnabled(bEnabled);
        }
    }

    public void setEnabled(boolean bEnabled) {
        Enumeration e = this.vMenus.elements();
        while (e.hasMoreElements()) {
            JDIMenu label = (JDIMenu)e.nextElement();
            if (label == null) continue;
            label.setEnabled(bEnabled);
        }
    }

    public void addMenuListener(MenuListener listener) {
        this.vMenuListeners.addElement(listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.vMenuListeners.removeElement(listener);
    }

    public void windowActivated(WindowEvent e) {
    }

    public void windowClosing(WindowEvent e) {
        if (e.getSource() instanceof Frame) {
            System.exit(0);
        }
    }

    public void windowDeactivated(WindowEvent e) {
    }

    public void windowIconified(WindowEvent e) {
    }

    public void windowDeiconified(WindowEvent e) {
    }

    public void windowOpened(WindowEvent e) {
    }

    public void windowClosed(WindowEvent e) {
    }

    public void keyPressed(KeyEvent e) {
        if ((e.getModifiers() & this.nMetaMask) != 0) {
            Enumeration enumeration = this.vMenus.elements();
            while (enumeration.hasMoreElements()) {
                JDIMenu label = (JDIMenu)enumeration.nextElement();
                if (label == null || label.getShortcutKeyCode() != e.getKeyCode()) continue;
                label.showMenu();
                return;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    public void setEnableShortcuts(Container parent) {
        if (this.cParent != null) {
            this.unHookChildren(this.cParent);
        }
        this.cParent = parent;
        System.out.println("Hooking children!");
        this.hookChildren(parent);
    }

    protected void hookChildren(Container parent) {
        Component[] c = parent.getComponents();
        System.out.println("hooking " + c.length + " components");
        int i = c.length;
        while (i-- > 0) {
            c[i].addKeyListener(this);
            if (!(c[i] instanceof Container)) continue;
            this.hookChildren((Container)c[i]);
        }
    }

    protected void unHookChildren(Container parent) {
        Component[] c = parent.getComponents();
        int i = c.length;
        while (i-- > 0) {
            c[i].removeKeyListener(this);
            if (!(c[i] instanceof Container)) continue;
            this.unHookChildren((Container)c[i]);
        }
    }
}

