/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.statusPanel;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;

public class StatusPanelBar
extends ExtendedCanvas {
    protected String sText = "";
    protected int iFontHeight = 1;
    protected Dimension dim;
    protected static final int X_OFFSET = 8;
    protected static final int Y_OFFSET = 5;
    protected static final String DEFAULT_TEXT = "";

    public StatusPanelBar(ColorsForCanvas cfcColor, FontsForCanvas ffcFont) {
        this.copyAttribs(cfcColor, ffcFont, this.ifcImage);
        this.setAttribs();
    }

    public void setText(String sText) {
        this.sText = sText == null ? DEFAULT_TEXT : sText;
    }

    public void draw(Graphics g) {
        try {
            Dimension d = this.size();
            g.setColor(SystemColor.control);
            g.fillRect(0, 0, d.width, d.height);
            g.setColor(this.cfcColor.getColor(1));
            g.setFont(this.ffcFont.getFont(0));
            String sTemp = this.computeText(0);
            g.drawString(sTemp, 8, this.iFontHeight + 5);
        }
        catch (Exception exception) {}
    }

    public void committ() {
        try {
            int iFontDescent = this.ffcFont.getFontDescent(0);
            this.iFontHeight = this.ffcFont.getFontHeight(0) - iFontDescent - 4;
            int iHeight = this.iFontHeight + 10 + iFontDescent;
            this.dim = new Dimension(1, iHeight);
            this.setSize(1, iHeight);
        }
        catch (Exception exception) {}
    }

    protected String computeText(int iFontType) {
        try {
            Dimension d = this.getSize();
            int iWidth = d.width;
            String sTemp = this.sText;
            int iStringWidth = this.ffcFont.getStringWidth(sTemp, iFontType);
            if (iStringWidth < iWidth) {
                return sTemp;
            }
            int iDiff = iStringWidth - iWidth;
            int iCharSize = this.ffcFont.getFontAverageWidth(iFontType);
            int iDecChars = (int)((float)iDiff / (float)iCharSize + 3.0f);
            int iSize = sTemp.length() - iDecChars - 1;
            if (iSize < 1) {
                return DEFAULT_TEXT;
            }
            return String.valueOf(sTemp.substring(0, iSize)) + "...";
        }
        catch (Exception exception) {
            return DEFAULT_TEXT;
        }
    }

    public Dimension getPreferredSize() {
        return this.dim;
    }

    public void repaint() {
        Graphics g = this.getGraphics();
        if (g == null) {
            super.repaint();
        }
        this.update(g);
    }
}

