/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.tabView.CardViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.CardViewLayout;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;

public class CardView
extends ExtendedPanel {
    protected static final int HORZ_GAP = 3;
    protected static final int VERT_GAP = 3;
    protected CardLayout layout;
    protected String sSelectedPanel;
    protected TabViewNode tvnSelected;
    protected CardViewCanvas cvc;
    protected Panel pCardLayout;

    public CardView(Dimension dimSize, ColorsForCanvas cfcColor) {
        this.copyAttribs(cfcColor, this.ffcFont, this.ifcImage);
        this.setAttribs();
        this.cvc = new CardViewCanvas(cfcColor);
        this.pCardLayout = new Panel();
        this.setLayout(new CardViewLayout());
        this.add("pcv", this.pCardLayout);
        this.add("cvc", this.cvc);
        this.layout = new CardLayout();
        this.pCardLayout.setLayout(this.layout);
    }

    public void removePanel(TabViewNode tvn) {
        try {
            Panel p = tvn.getPanel();
            this.pCardLayout.remove(p);
        }
        catch (Exception exception) {
            System.err.println("Error: " + tvn.toString() + " not removed");
        }
    }

    public void addPanel(TabViewNode tvn) {
        try {
            String sNewPanel = tvn.toString();
            Panel p = tvn.getPanel();
            this.pCardLayout.add((Component)p, sNewPanel);
            if (this.sSelectedPanel == null) {
                this.sSelectedPanel = sNewPanel;
                this.tvnSelected = tvn;
            }
            this.layout.layoutContainer(p);
        }
        catch (Exception e) {
            System.err.println("CardView: Panel not created: " + e);
        }
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
    }

    public void selectPanel(TabViewNode tvn) {
        this.sSelectedPanel = tvn.toString();
        this.tvnSelected = tvn;
        this.showSelectedPanel();
    }

    public TabViewNode getSelectedPanel() {
        return this.tvnSelected;
    }

    private void showSelectedPanel() {
        this.layout.show(this.pCardLayout, this.sSelectedPanel);
    }

    public Dimension getDisplaySize() {
        Dimension dimPanel = this.pCardLayout.getSize();
        return dimPanel;
    }
}

