/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.dbCanvasImageIndexMap;
import com.ibm.eNetwork.onDemand.common.gui.tabView.CardView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewLayout;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabsView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.ableToUseTabsView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.tabOrientation;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.SystemColor;
import java.util.Enumeration;
import java.util.Vector;

public class TabView
extends ExtendedPanel
implements ableToUseTabsView,
tabOrientation,
dbCanvasImageIndexMap {
    protected TabsView tv;
    protected CardView cv;
    protected Dimension dimView;
    protected int iTabOrientation;
    public static final int PANEL_EXPOSED = 1;
    protected String sTab;
    protected Vector vTabs = new Vector(10, 10);

    public TabView(Point ptStart, Dimension dimMin, FontsForCanvas ffcFont, ColorsForCanvas cfcColor, ImagesForCanvas ifcImage, int iTabOrientation) {
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        this.dimView = dimMin;
        this.iTabOrientation = iTabOrientation;
        this.setLayout(new TabViewLayout());
        this.setBounds(ptStart.x, ptStart.y, dimMin.width, dimMin.height);
        this.createComponents(ptStart, dimMin, this.cfcColor, this.ffcFont, this.ifcImage, iTabOrientation);
        this.setBackground(SystemColor.control);
    }

    public int getOrientation() {
        return this.iTabOrientation;
    }

    private void createComponents(Point ptStart, Dimension dimMin, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage, int iTabOrientation) {
        this.tv = new TabsView(this, dimMin, cfcColor, ffcFont, ifcImage, iTabOrientation);
        this.cv = new CardView(dimMin, cfcColor);
        this.add("tv", this.tv);
        this.add("cv", this.cv);
    }

    public void setAutoFocus(boolean bAutoFocus) {
        try {
            this.tv.setAutoFocus(bAutoFocus);
        }
        catch (Exception exception) {
            return;
        }
    }

    public Dimension getMinSize() {
        return this.dimView;
    }

    public void addTab(TabViewNode tvn) {
        this.cv.addPanel(tvn);
        this.tv.addTab(tvn);
        this.vTabs.addElement(tvn);
    }

    public void removeTab(TabViewNode tvn) {
        this.cv.removePanel(tvn);
        this.tv.removeTab(tvn);
        this.vTabs.removeElement(tvn);
    }

    public void removeAllTabs() {
        try {
            Enumeration enumeration = this.vTabs.elements();
            TabViewNode tvn = null;
            while (enumeration.hasMoreElements()) {
                tvn = (TabViewNode)enumeration.nextElement();
                this.cv.removePanel(tvn);
                this.tv.removeTab(tvn);
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void addControler(Controler con) {
        this.tv.setControler(con);
    }

    public void tabSelected(TabViewNode tvn) {
        this.cv.selectPanel(tvn);
    }

    public void selectTab(TabViewNode tvn) {
        this.selectTab(tvn, false);
    }

    public void selectTab(TabViewNode tvn, boolean bShow) {
        this.tv.selectTab(tvn);
        if (bShow) {
            this.tv.showTab(tvn);
        }
    }

    public TabViewNode getSelectedTab() {
        return this.cv.getSelectedPanel();
    }

    public Dimension getDisplaySize() {
        return this.cv.getDisplaySize();
    }

    public void committ() {
        this.tv.committ();
        this.repaint();
    }

    public void addTabViewEventListener(TabViewEventListener listener) {
        this.tv.addListener(listener);
    }

    public void removeTabViewEventListener(TabViewEventListener listener) {
        this.tv.removeListener(listener);
    }
}

