/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedPanel;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.tabView.BottomTab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.LeftTab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.LtoRTabCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.RightTab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.Tab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewNode;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabsViewControler;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TopTab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TtoBTabCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.ableToUseTabsView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.tabOrientation;
import java.awt.Dimension;
import java.awt.SystemColor;

public class TabsView
extends ExtendedPanel
implements tabOrientation {
    protected int iOrientation = 2;
    protected ableToUseTabsView atutvParent;
    protected JVCScrollbar sb;
    protected Dimension dimtc;
    protected TabCanvas tc;
    protected TabsViewControler tvc;
    protected boolean bPaintTabBackground = true;

    public TabsView(ableToUseTabsView atutvParent, Dimension dimView, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage, int iOrientation) {
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        this.iOrientation = iOrientation;
        this.atutvParent = atutvParent;
        this.setLayout(null);
        this.sb = this.createScrollBar();
        this.add(this.sb);
        this.tc = this.createTabCanvas();
        this.add(this.tc);
        this.setSize(dimView);
        if (ifcImage.getImage(2) != null) {
            this.bPaintTabBackground = false;
        }
        this.setBackground(SystemColor.control);
    }

    protected JVCScrollbar createScrollBar() {
        int iAlignment = 0;
        if (this.iOrientation == 1 || this.iOrientation == 2) {
            iAlignment = 0;
        } else if (this.iOrientation == 8 || this.iOrientation == 4) {
            iAlignment = 1;
        }
        return new JVCScrollbar(iAlignment, 1, 1, 1, 2);
    }

    public void setSize(Dimension dim) {
        this.setSize(dim.width, dim.height);
    }

    public void setAutoFocus(boolean bAutoFocus) {
        this.tvc.setAutoFocus(bAutoFocus);
    }

    public void selectTab(TabViewNode tvn) {
        Tab tabTemp = this.tc.findTab(tvn);
        this.tvc.selectTab(tabTemp);
    }

    public void showTab(TabViewNode tvn) {
        Tab tabTemp = this.tc.findTab(tvn);
        this.tvc.showTab(tabTemp);
    }

    public void setSize(int width, int height) {
        super.setSize(width, height);
        this.positionScrollbar();
        this.positionTabCanvas();
        this.tc.repaint();
    }

    private void positionScrollbar() {
        int iWidth = this.getSize().width;
        int iHeight = this.getSize().height;
        switch (this.iOrientation) {
            case 1: {
                int iScrollHeight = 15;
                int iScrollWidth = 30;
                this.sb.setBounds(iWidth - iScrollWidth, iHeight - iScrollHeight, iScrollWidth, iScrollHeight);
                this.dimtc = new Dimension(iWidth - iScrollWidth, iHeight);
                break;
            }
            case 4: {
                int iScrollHeight = 30;
                int iScrollWidth = 15;
                this.sb.setBounds(iWidth - iScrollWidth, iHeight - iScrollHeight, iScrollWidth, iScrollHeight);
                this.dimtc = new Dimension(iWidth, iHeight - iScrollHeight);
                break;
            }
            case 8: {
                int iScrollHeight = 30;
                int iScrollWidth = 15;
                this.sb.setBounds(0, iHeight - iScrollHeight, iScrollWidth, iScrollHeight);
                this.dimtc = new Dimension(iWidth, iHeight - iScrollHeight);
                break;
            }
            default: {
                int iScrollHeight = 15;
                int iScrollWidth = 30;
                this.sb.setBounds(iWidth - iScrollWidth, 0, iScrollWidth, iScrollHeight);
                this.dimtc = new Dimension(iWidth - iScrollWidth, this.getSize().height);
            }
        }
        this.sb.setVisible(true);
    }

    protected TabCanvas createTabCanvas() {
        if (this.iOrientation == 1 || this.iOrientation == 2) {
            LtoRTabCanvas tc = new LtoRTabCanvas(this.cfcColor, this.ffcFont, this.ifcImage);
            this.tvc = new TabsViewControler((TabView)this.atutvParent);
            tc.setControler(this.tvc);
            this.tvc.registerScrollbar(this.sb);
            return tc;
        }
        if (this.iOrientation == 8 || this.iOrientation == 4) {
            TtoBTabCanvas tc = new TtoBTabCanvas(this.cfcColor, this.ffcFont, this.ifcImage);
            this.tvc = new TabsViewControler((TabView)this.atutvParent);
            tc.setControler(this.tvc);
            this.tvc.registerScrollbar(this.sb);
            return tc;
        }
        return null;
    }

    public void setControler(Controler con) {
        this.tc.setControler(con);
    }

    protected void positionTabCanvas() {
        if (this.iOrientation == 1 || this.iOrientation == 2) {
            this.tc.setBounds(0, 0, this.dimtc.width, this.dimtc.height);
        } else if (this.iOrientation == 8 || this.iOrientation == 4) {
            this.tc.setBounds(0, 0, this.dimtc.width, this.dimtc.height);
        }
    }

    public int getMaxWidth() {
        if (this.iOrientation == 4 || this.iOrientation == 8) {
            return ((TtoBTabCanvas)this.tc).getMaxWidth();
        }
        return 0;
    }

    public int getMaxHeight() {
        if (this.iOrientation == 2 || this.iOrientation == 1) {
            return ((LtoRTabCanvas)this.tc).getMaxHeight();
        }
        return 0;
    }

    public void addTab(TabViewNode tvn) {
        if (tvn == null) {
            return;
        }
        this.sb.setValue(this.sb.getValue() + 1);
        switch (this.iOrientation) {
            case 1: {
                TopTab tab = new TopTab(tvn);
                tab.setParentBackground(SystemColor.control);
                tab.setBackgroundPainting(this.bPaintTabBackground);
                tab.committ();
                this.tc.addNode(tab);
                return;
            }
            case 8: {
                RightTab tab = new RightTab(tvn);
                tab.setParentBackground(SystemColor.control);
                tab.setBackgroundPainting(this.bPaintTabBackground);
                tab.committ();
                this.tc.addNode(tab);
                return;
            }
            case 4: {
                LeftTab tab = new LeftTab(tvn);
                tab.setParentBackground(SystemColor.control);
                tab.setBackgroundPainting(this.bPaintTabBackground);
                tab.committ();
                this.tc.addNode(tab);
                return;
            }
        }
        BottomTab tab = new BottomTab(tvn);
        tab.setParentBackground(SystemColor.control);
        tab.setBackgroundPainting(this.bPaintTabBackground);
        tab.committ();
        this.tc.addNode(tab);
    }

    public void removeTab(TabViewNode tvn) {
        try {
            Tab tabNew;
            Tab tab = this.tc.findTab(tvn);
            boolean bUpdateSelectedTab = tab.getSelected();
            this.tc.deleteNode(tab);
            if (bUpdateSelectedTab && (tabNew = this.tc.findSelectedTab()) != null) {
                TabViewNode tvnNew = tabNew.getTabViewNode();
                this.atutvParent.tabSelected(tvnNew);
            }
        }
        catch (Exception exception) {}
    }

    public void committ() {
        this.tc.committ();
    }

    public void addListener(TabViewEventListener listener) {
        this.tvc.addListener(listener);
    }

    public void removeListener(TabViewEventListener listener) {
        this.tvc.removeListener(listener);
    }
}

