/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.tabView;

import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.tabView.Tab;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabCanvas;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabView;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewEvent;
import com.ibm.eNetwork.onDemand.common.gui.tabView.TabViewEventListener;
import java.awt.AWTEvent;
import java.awt.Point;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;

public class TabsViewControler
extends Controler
implements MouseListener,
KeyListener,
FocusListener,
AdjustmentListener,
ComponentListener {
    protected TabCanvas tvc;
    protected TabView tv;
    protected JVCScrollbar sb;
    protected boolean bLeftMouseButtonClicked = false;

    public TabsViewControler(TabView tv) {
        this.tv = tv;
    }

    public void register(ExtendedCanvas ec) {
        try {
            TabCanvas tvc = (TabCanvas)ec;
            tvc.addMouseListener(this);
            tvc.addKeyListener(this);
            tvc.addFocusListener(this);
            tvc.addComponentListener(this);
            this.tvc = tvc;
        }
        catch (Exception exception) {}
    }

    public void unregister(ExtendedCanvas ec) {
        try {
            TabCanvas tvc = (TabCanvas)ec;
            tvc.removeMouseListener(this);
            tvc.removeKeyListener(this);
            tvc.removeFocusListener(this);
            tvc.removeComponentListener(this);
            this.tvc = null;
        }
        catch (Exception exception) {}
    }

    public void keyPressed(KeyEvent e) {
        try {
            Tab tab = (Tab)this.tvc.findCurrent();
            Tab tab2 = null;
            int key = e.getKeyCode();
            boolean bCont = true;
            switch (key) {
                case 39: {
                    tab2 = (Tab)tab.getNext();
                    bCont = this.preSelectEvent(tab2);
                    if (bCont) {
                        this.tvc.selectNextTab();
                        this.postSelectEvent(tab2);
                    }
                    break;
                }
                case 37: {
                    tab2 = (Tab)tab.getPrev();
                    bCont = this.preSelectEvent(tab2);
                    if (bCont) {
                        this.tvc.selectPrevTab();
                        this.postSelectEvent(tab2);
                    }
                    break;
                }
                case 40: {
                    tab2 = (Tab)tab.getNext();
                    bCont = this.preSelectEvent(tab2);
                    if (bCont) {
                        this.tvc.selectNextTab();
                        this.postSelectEvent(tab2);
                    }
                    break;
                }
                case 38: {
                    tab2 = (Tab)tab.getPrev();
                    bCont = this.preSelectEvent(tab2);
                    if (bCont) {
                        this.tvc.selectPrevTab();
                        this.postSelectEvent(tab2);
                    }
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        try {
            this.tvc.requestFocus();
            Point point = e.getPoint();
            Tab tab = (Tab)this.tvc.findOnMouseUp(point.x, point.y);
            boolean bCont = this.preSelectEvent(tab);
            if (bCont) {
                this.tvc.selectTab(tab);
                this.postSelectEvent(tab);
            }
        }
        catch (Exception exception) {}
    }

    protected boolean leftMouseClick(MouseEvent e) {
        try {
            int iModifiers = e.getModifiers();
            if (iModifiers == 16) {
                return true;
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    public void mouseEntered(MouseEvent e) {
        try {
            if (this.bAutoFocus) {
                this.tvc.requestFocus();
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        this.bLeftMouseButtonClicked = true;
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        try {
            if (!this.tvc.getFocus()) {
                this.tvc.setFocus(true);
                this.tvc.repaint();
            }
        }
        catch (Exception exception) {}
    }

    public void focusLost(FocusEvent e) {
        try {
            if (this.tvc.getFocus()) {
                this.tvc.setFocus(false);
                this.tvc.repaint();
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isMyEvent(AWTEvent e) {
        try {
            if (e instanceof TabViewEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent e) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            TabViewEvent tve = (TabViewEvent)e;
            if (enumeration.hasMoreElements()) {
                TabViewEventListener listener = (TabViewEventListener)enumeration.nextElement();
                return tve.sendEvent(listener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected boolean preSelectEvent(Tab tab) {
        try {
            return this.createEvent(329, tab);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean postSelectEvent(Tab tab) {
        try {
            this.tv.tabSelected(tab.getTabViewNode());
            return this.createEvent(332, tab);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean createEvent(int id, Tab tab) {
        try {
            TabViewEvent tve = new TabViewEvent(this.tv, tab, id);
            return this.postEvent(tve);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void selectTab(Tab tab) {
        boolean bCont = this.preSelectEvent(tab);
        if (bCont) {
            this.tvc.selectTab(tab);
            this.postSelectEvent(tab);
        }
    }

    public void showTab(Tab tab) {
        this.tvc.showTab(tab);
    }

    public void registerScrollbar(JVCScrollbar sb) {
        try {
            sb.addAdjustmentListener(this);
            this.sb = sb;
        }
        catch (Exception exception) {}
    }

    public void unregisterScrollbars(JVCScrollbar sb) {
        try {
            sb.removeAdjustmentListener(this);
            this.sb = null;
        }
        catch (Exception exception) {}
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        try {
            JVCScrollbar sbTemp = (JVCScrollbar)e.getAdjustable();
            if (sbTemp == this.sb) {
                this.scrollEvent(e);
            }
        }
        catch (Exception exception) {}
    }

    protected void scrollEvent(AdjustmentEvent e) {
        try {
            int iType = e.getAdjustmentType();
            switch (iType) {
                case 1: {
                    this.tvc.moveToNextTab();
                    return;
                }
                case 2: {
                    this.tvc.moveToPrevTab();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    protected void scrollbarEnablementCheck() {
        try {
            Tab tab = (Tab)this.tvc.findHeadNode();
            boolean bEnable = true;
            int iArrow = 1;
            if (tab != null && tab.getPrev() == null) {
                bEnable = false;
            }
            if (this.sb.getOrientation() == 0) {
                iArrow = 3;
            }
            this.sb.setArrowEnabled(iArrow, bEnable);
            tab = (Tab)this.tvc.findEndNode();
            bEnable = true;
            iArrow = 2;
            if (tab != null && tab.getNext() == null) {
                bEnable = false;
            }
            if (this.sb.getOrientation() == 0) {
                iArrow = 4;
            }
            this.sb.setArrowEnabled(iArrow, bEnable);
        }
        catch (Exception exception) {}
    }

    public void componentHidden(ComponentEvent e) {
    }

    public void componentMoved(ComponentEvent e) {
    }

    public void componentResized(ComponentEvent e) {
    }

    public void componentShown(ComponentEvent e) {
    }
}

