/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.common.ColorsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableNode;
import com.ibm.eNetwork.onDemand.common.gui.common.DrawableObject;
import com.ibm.eNetwork.onDemand.common.gui.common.FontsForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.common.ViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.CommitTypes;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Vector;

public class TreeViewCanvas
extends ViewCanvas
implements ableToUseTreeViewNode,
CommitTypes {
    protected int iTopBuffer = 10;
    protected int iInset = 20;
    protected boolean bResetNodeLocation = true;
    protected Image iPlus;
    protected Image iMinus;
    protected int iNumNodes;
    protected TreeViewNode tvnBottom;
    protected ableToUseTreeViewCanvas atutvcParent;
    protected int iNumNodesOnPage;
    protected int iCurrentNodePos = 1;
    protected TreeViewNode tvnPrev;
    protected TreeViewNode tvnOldTop;
    protected TreeViewNode tvnOldBottom;
    protected TreeViewNode tvnDropZone;
    protected addableToTreeView attvDesiredTop;
    protected int iExtraWidth;
    protected int iHorzOffset;
    protected int iPopupOffset;
    protected int iOptimisedPaint = 0;
    protected static final int MAGNIFICATION = 1;
    protected boolean bDrawNodeLines = true;
    protected boolean bNonUserSelect = false;
    private Point pTemp;
    private Point pTemp2;
    private Dimension dTemp;
    private Dimension dTemp2;
    private TreeViewNode tvnTemp;
    protected boolean bDrawAsDraggable = false;
    protected boolean bMultiSelect = false;
    protected Vector vSelectedNodes;
    protected static final int NO_OPTIMIZATION = 0;
    protected static final int ADJACENT_NODES = 1;
    protected long lCommittTime;

    public TreeViewCanvas(ableToUseTreeViewCanvas atutvcParent, addableToTreeView attvRoot, ColorsForCanvas cfcColor, FontsForCanvas ffcFont, ImagesForCanvas ifcImage) {
        this.copyAttribs(cfcColor, ffcFont, ifcImage);
        this.setAttribs();
        this.atutvcParent = atutvcParent;
        this.calcBuffers();
        this.addRootNode(attvRoot);
    }

    public void setImages(Image iPlus, Image iMinus) {
        try {
            this.iPlus = iPlus;
            this.iMinus = iMinus;
            this.iInset = this.ifcImage.getImageWidth(iPlus);
            this.recommittNodes();
        }
        catch (Exception exception) {
            System.err.println("Error in " + this + "[setImages()]");
        }
    }

    protected void recommittNodes() {
        this.tvnTemp = (TreeViewNode)this.lanTop;
        while (this.tvnTemp != null) {
            this.tvnTemp.committ();
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
    }

    protected void calcBuffers() {
        this.iTopBuffer = this.ffcFont.getFontHeight(0) / 2;
        this.iInset = this.ffcFont.getFontMaxWidth(0);
    }

    public TreeViewCanvas() {
    }

    public DrawableObject findOnGotFocus() {
        return this.findSelectedTreeViewNode();
    }

    public DrawableObject findCurrent() {
        return this.findSelectedTreeViewNode();
    }

    public DrawableObject findOnMouseUp(int x, int y) {
        return this.findTreeViewNode(x, y);
    }

    public DrawableObject findOnMouseDown(int x, int y) {
        return this.findTreeViewNode(x, y);
    }

    public DrawableObject findOnMouseMove(int x, int y) {
        return this.findTreeViewNode(x, y);
    }

    public DrawableObject findOnKeyUp(int key) {
        return this.findSelectedTreeViewNode();
    }

    public DrawableObject findOnKeyDown(int key) {
        return this.findSelectedTreeViewNode();
    }

    protected void startingNode(TreeViewNode tvn) {
        if (tvn == null) {
            return;
        }
        this.lanCurrent = tvn;
    }

    public void moveToNextNode() {
        TreeViewNode tvnNext = (TreeViewNode)this.lanCurrent.getNext();
        this.startingNode(tvnNext);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        if (tvnNext != null) {
            this.atutvcParent.currentNodePos(++this.iCurrentNodePos);
        }
        this.repaint();
    }

    public void moveToNextPage(boolean bPaint) {
        this.startingNode(this.tvnBottom);
        this.iCurrentNodePos += this.iNumNodesOnPage - 1;
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        if (bPaint) {
            this.repaint();
        }
    }

    public void moveToPrevNode() {
        TreeViewNode tvnPrev = (TreeViewNode)this.lanCurrent.getPrev();
        this.startingNode(tvnPrev);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        if (tvnPrev != null) {
            this.atutvcParent.currentNodePos(--this.iCurrentNodePos);
        }
        this.repaint();
    }

    public void moveToPrevPage(boolean bPaint) {
        this.startingNode(this.calcNewTop((TreeViewNode)this.lanCurrent));
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        if (bPaint) {
            this.repaint();
        }
    }

    protected TreeViewNode calcNewTop(TreeViewNode tvnBottom) {
        TreeViewNode tvn = (TreeViewNode)tvnBottom.getNext();
        int iHeight = this.getSize().height;
        int y = 0;
        if (tvn == null) {
            tvn = tvnBottom;
        } else {
            ++this.iCurrentNodePos;
        }
        while (tvn != null && y < iHeight - tvn.getHeight()) {
            y += tvn.getHeight();
            --this.iCurrentNodePos;
            tvn = (TreeViewNode)tvn.getPrev();
        }
        if (tvn == null) {
            this.iCurrentNodePos = 1;
            tvn = (TreeViewNode)this.lanTop;
        }
        return tvn;
    }

    public void selectNextNode() {
        if (this.lanSelected == null) {
            this.selectNode((TreeViewNode)this.lanTop);
            this.repaint();
        } else if (this.lanSelected.getNext() != null) {
            if ((TreeViewNode)this.lanSelected == this.tvnBottom) {
                this.moveToNextPage(true);
            } else {
                this.tvnTemp = (TreeViewNode)this.lanSelected.getNext();
                if (this.lanSelected != this.lanTop && this.tvnTemp != this.lanBottom) {
                    this.pTemp = this.lanSelected.getLocation();
                    this.pTemp2 = this.tvnTemp.getLocation();
                    this.dTemp = new Dimension(this.tvnTemp.getMaxWidth(), this.tvnTemp.getHeight());
                    this.dTemp2 = new Dimension(((TreeViewNode)this.lanSelected).getMaxWidth(), this.lanSelected.getHeight());
                    this.selectNode(this.tvnTemp);
                    this.iOptimisedPaint = 1;
                    this.repaint(Math.min(this.pTemp.x, this.pTemp2.x), Math.min(this.pTemp.y, this.pTemp2.y), Math.max(this.dTemp.width, this.dTemp2.width), this.dTemp.height + (this.pTemp2.y - this.pTemp.y));
                } else {
                    this.selectNode(this.tvnTemp);
                    this.repaint();
                }
            }
        }
    }

    public void selectPrevNode() {
        if (this.lanSelected == null) {
            this.selectNode((TreeViewNode)this.lanTop);
            this.repaint();
        } else if (this.lanSelected.getPrev() != null) {
            if (this.lanSelected == this.lanCurrent) {
                this.moveToPrevPage(true);
            } else {
                this.tvnTemp = (TreeViewNode)this.lanSelected.getPrev();
                if (this.lanSelected != this.lanBottom && this.tvnTemp != this.lanTop) {
                    this.pTemp = this.lanSelected.getLocation();
                    this.pTemp2 = this.tvnTemp.getLocation();
                    this.dTemp = new Dimension(((TreeViewNode)this.lanSelected).getMaxWidth(), this.lanSelected.getHeight());
                    this.dTemp2 = new Dimension(this.tvnTemp.getMaxWidth(), this.tvnTemp.getHeight());
                    this.selectNode(this.tvnTemp);
                    this.iOptimisedPaint = 1;
                    this.repaint(Math.min(this.pTemp.x, this.pTemp2.x), Math.min(this.pTemp.y, this.pTemp2.y), Math.max(this.dTemp.width, this.dTemp2.width), this.dTemp.height + (this.pTemp.y - this.pTemp2.y));
                } else {
                    this.selectNode(this.tvnTemp);
                    this.repaint();
                }
            }
        }
    }

    public void selectNode(TreeViewNode tvn) {
        if (this.bMultiSelect) {
            this.unselectAllNodes();
        }
        this.singleSelectNode(tvn);
    }

    protected void singleSelectNode(TreeViewNode tvn) {
        if (this.lanSelected != null) {
            this.lanSelected.setSelected(false);
            this.tvnPrev = (TreeViewNode)this.lanSelected;
        }
        this.lanSelected = tvn;
        if (this.lanSelected != null) {
            this.lanSelected.setSelected(true);
        }
    }

    public void multiSelectNode(TreeViewNode tvn) {
        if (!this.bMultiSelect || tvn == null) {
            return;
        }
        try {
            if (this.lanSelected != null && this.vSelectedNodes.indexOf(this.lanSelected) == -1) {
                this.vSelectedNodes.addElement(this.lanSelected);
            }
            this.vSelectedNodes.addElement(tvn);
            this.singleSelectNode(tvn);
            this.tvnPrev.setSelected(true);
            this.tvnPrev.setFocus(false);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void unselectNode(TreeViewNode tvn) {
        try {
            if (!this.bMultiSelect) {
                return;
            }
            tvn.setSelected(false);
            this.vSelectedNodes.removeElement(tvn);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void unselectAllNodes() {
        try {
            if (!this.bMultiSelect) {
                return;
            }
            Enumeration enumeration = ((Vector)this.vSelectedNodes.clone()).elements();
            while (enumeration.hasMoreElements()) {
                this.unselectNode((TreeViewNode)enumeration.nextElement());
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void selectNode(addableToTreeView attvNode) {
        this.bNonUserSelect = true;
        TreeViewNode tvn = this.createBastardTreeNode((TreeViewNode)this.lanTop, attvNode, this.lCommittTime);
        this.selectNode(tvn);
        this.repaint();
        this.bNonUserSelect = false;
    }

    public void expandAllNodes(boolean bExpand) {
        this.traverseAndExpandAllNodes((TreeViewNode)this.lanTop, bExpand);
        this.commit(1);
    }

    protected void traverseAndExpandAllNodes(TreeViewNode tvn, boolean bExpand) {
        try {
            long lCurrentTime = System.currentTimeMillis();
            TreeViewNode tvnTemp = tvn;
            while (tvnTemp != null) {
                tvnTemp.setExpanded(bExpand);
                if (tvnTemp.hasChild()) {
                    TreeViewNode tvnChild = tvn.createChildTreeNode(this.lCommittTime);
                    this.traverseAndExpandAllNodes(tvnChild, bExpand);
                }
                tvnTemp = tvnTemp.createNextTreeNode(lCurrentTime);
            }
        }
        catch (Exception exception) {}
    }

    public void expandNode(addableToTreeView attvNode, boolean bExpand, boolean bCommitt) {
        TreeViewNode tvn = this.createBastardTreeNode((TreeViewNode)this.lanTop, attvNode, this.lCommittTime);
        tvn.setExpanded(bExpand);
        if (bCommitt) {
            this.commit(1);
        }
    }

    public void addNode(LeftAlignedNode lanNew, LeftAlignedNode lanPrev) {
        super.addNode(lanNew, lanPrev);
        if (this.lanCurrent == null) {
            this.lanCurrent = lanNew;
        }
    }

    public void addNode(LeftAlignedNode lanNew) {
        super.addNode(lanNew);
        if (this.lanCurrent == null) {
            this.lanCurrent = lanNew;
            this.selectNode((TreeViewNode)lanNew);
        }
    }

    public void draw(Graphics g) {
        if (this.iOptimisedPaint > 0) {
            if (this.ifcImage.getImage(2) == null) {
                Color c = this.cfcColor.getColor(0);
                this.tvnPrev.setBackgroundPainting(true);
                ((TreeViewNode)this.lanSelected).setBackgroundPainting(true);
            }
            this.pTemp = this.tvnPrev.getLocation();
            Rectangle area = new Rectangle(this.pTemp.x, this.pTemp.y, this.tvnPrev.getMaxWidth(), this.tvnPrev.getHeight());
            if (this.tvnPrev.isOnScreen()) {
                this.tvnPrev.draw(g, area);
                this.tvnPrev.setLocation(this.pTemp);
            }
            this.pTemp = this.lanSelected.getLocation();
            area = new Rectangle(this.pTemp.x, this.pTemp.y, ((TreeViewNode)this.lanSelected).getMaxWidth(), this.lanSelected.getHeight());
            this.lanSelected.draw(g, area);
            this.lanSelected.setLocation(this.pTemp);
            if (this.ifcImage.getImage(2) == null) {
                this.tvnPrev.setBackgroundPainting(false);
                ((TreeViewNode)this.lanSelected).setBackgroundPainting(false);
            }
        } else {
            this.setNodeLocations();
            this.drawNodes(g);
        }
        this.tvnPrev = null;
        this.iOptimisedPaint = 0;
        this.drawDraggableBox(g);
    }

    protected void drawDraggableBox(Graphics g) {
        try {
            if (!this.bDrawAsDraggable) {
                return;
            }
            Rectangle r = this.getBounds();
            g.setColor(Color.black);
            g.drawRect(2, 2, r.width - 4, r.height - 4);
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    protected TreeViewNode findTreeViewNode(int x, int y) {
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        this.pTemp = null;
        int offset = this.ifcImage.getImageWidth(this.iPlus);
        while (this.tvnTemp != null) {
            this.pTemp = this.tvnTemp.getLocation();
            if (x > this.pTemp.x - offset && y > this.pTemp.y && x < this.pTemp.x + this.tvnTemp.getMaxWidth() && this.tvnTemp.isOnScreen() && y < this.pTemp.y + this.tvnTemp.getHeight()) {
                return this.tvnTemp;
            }
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
        return null;
    }

    public TreeViewNode findSelectedTreeViewNode() {
        return (TreeViewNode)this.lanSelected;
    }

    public void committ() {
        this.committ(true);
    }

    public void committ(boolean bRecalcNodes) {
        if (bRecalcNodes) {
            this.commit(3);
        } else {
            this.commit(2);
        }
    }

    public synchronized void commit(int iCommittType) {
        boolean bResetDesired = false;
        this.setWaitCursor();
        if ((iCommittType & 1) == 1) {
            if (this.lanCurrent != null && this.attvDesiredTop == null) {
                bResetDesired = true;
                this.attvDesiredTop = ((TreeViewNode)this.lanCurrent).getAddableToTreeView();
            }
            if ((iCommittType & 2) == 2) {
                this.updateCommittTime();
            }
            this.buildDisplayList();
        } else if ((iCommittType & 2) == 2) {
            this.recommittNodes();
        }
        this.repaint();
        this.clearWaitCursor();
        if (bResetDesired) {
            this.attvDesiredTop = null;
        }
    }

    protected void buildDisplayList() {
        this.iNumNodes = 0;
        ((TreeViewNode)this.lanTop).setLineDrawing(this.bDrawNodeLines);
        if (this.lanTop.getNext() != null) {
            this.removeTreeLinks((TreeViewNode)this.lanTop.getNext());
        }
        this.lanTop.setNext(null);
        this.lanTop.committ();
        this.resetVars();
        this.addTreeToDisplayList(null, (TreeViewNode)this.lanTop);
        this.atutvcParent.numNodesChanged(this.iNumNodes);
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
    }

    public void showNode(addableToTreeView attvNode) {
        addableToTreeView attvTemp = attvNode;
        TreeViewNode tvn = null;
        if (attvTemp == null) {
            return;
        }
        this.attvDesiredTop = attvTemp;
        while (attvTemp != null) {
            tvn = this.createBastardTreeNode((TreeViewNode)this.lanTop, attvTemp, this.lCommittTime);
            if (tvn == null) break;
            tvn.setExpanded(true);
            attvTemp = attvTemp.getParentNode();
        }
        this.commit(1);
        this.attvDesiredTop = null;
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
    }

    protected TreeViewNode addTreeToDisplayList(TreeViewNode tvnParent, TreeViewNode tvnNew) {
        this.setWaitCursor();
        int iDepth = 0;
        TreeViewNode tvnTemp = tvnParent;
        TreeViewNode tvnChild = null;
        TreeViewNode tvnLast = null;
        if (tvnNew == null) {
            return null;
        }
        tvnNew.resetNode();
        if (tvnParent != null) {
            tvnParent.resetNode();
            iDepth = tvnParent.getDepth();
        }
        ++iDepth;
        while (tvnNew != null) {
            ++this.iNumNodes;
            if (tvnNew.getAddableToTreeView() == this.attvDesiredTop) {
                this.lanCurrent = tvnNew;
                this.iCurrentNodePos = this.iNumNodes;
                this.atutvcParent.currentNodePos(this.iCurrentNodePos);
            }
            if (tvnNew.getSelected()) {
                this.lanSelected = tvnNew;
            }
            tvnNew.setDepth(iDepth);
            this.addNode(tvnNew, tvnTemp);
            tvnTemp = tvnNew.hasChild() && tvnNew.getExpanded() ? ((tvnChild = this.createChildTreeNode(tvnNew, this.lCommittTime)) != null ? this.addTreeToDisplayList(tvnNew, tvnChild) : tvnNew) : tvnNew;
            tvnLast = tvnNew;
            tvnNew = this.createNextTreeNode(tvnNew, this.lCommittTime);
        }
        tvnLast.setLeafNode(true);
        this.clearWaitCursor();
        return tvnTemp;
    }

    protected TreeViewNode createChildTreeNode(TreeViewNode tvnParent, long lCommittTime) {
        TreeViewNode tvn = tvnParent.createChildTreeNode(lCommittTime);
        return tvn;
    }

    protected TreeViewNode createNextTreeNode(TreeViewNode tvnParent, long lCommittTime) {
        TreeViewNode tvn = tvnParent.createNextTreeNode(lCommittTime);
        return tvn;
    }

    protected TreeViewNode createBastardTreeNode(TreeViewNode tvnParent, addableToTreeView attvNode, long lCommittTime) {
        TreeViewNode tvn = tvnParent.createBastardTreeNode(attvNode, lCommittTime);
        return tvn;
    }

    protected synchronized void setNodeLocations() {
        if (!this.bResetNodeLocation) {
            return;
        }
        this.bResetNodeLocation = false;
        this.tvnTemp = this.tvnOldTop;
        boolean bRun = true;
        int height = this.getSize().height;
        int y = this.iTopBuffer;
        int x = this.iInset;
        Point p = null;
        int iWidth = this.getSize().width;
        do {
            if (this.tvnTemp == null) continue;
            this.tvnTemp.onScreen(false);
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        } while (this.tvnTemp != null && this.tvnTemp != this.tvnOldBottom);
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        while (this.tvnTemp != null && y < height - this.tvnTemp.getHeight()) {
            int temp;
            x = this.tvnTemp.getDepth() * this.iInset;
            p = new Point(x, y);
            this.tvnTemp.setLocation(p);
            this.tvnTemp.onScreen(true);
            if (this.tvnTemp.getSelected()) {
                this.lanSelected = this.tvnTemp;
            }
            y += this.tvnTemp.getHeight();
            if (x + this.tvnTemp.getMaxWidth() > iWidth && (temp = x + this.tvnTemp.getMaxWidth() - iWidth) > this.iExtraWidth) {
                this.iExtraWidth = temp;
            }
            this.tvnBottom = this.tvnTemp;
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
        this.atutvcParent.offscreenWidth(this.iExtraWidth + 1);
    }

    public void setHorzOffset(int iHorzOffset) {
        Point p = this.getLocation();
        Dimension d = this.getSize();
        int iOffset = iHorzOffset - this.iPopupOffset;
        this.iPopupOffset = -1 * iHorzOffset;
        this.setLocation(-1 * iHorzOffset, p.y);
        super.setSize(d.width + iHorzOffset, d.height);
        this.repaint();
    }

    protected void drawNodes(Graphics g) {
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        boolean bRun = true;
        int height = this.getSize().height;
        int y = this.iTopBuffer;
        int x = this.iInset;
        boolean bPaintBackground = false;
        Rectangle area = new Rectangle(1, 1, 1, 1);
        Point p = null;
        this.iNumNodesOnPage = 0;
        while (this.tvnTemp != null && y < height - this.tvnTemp.getHeight()) {
            p = this.tvnTemp.getLocation();
            area.x = p.x;
            area.y = p.y;
            area.width = this.tvnTemp.getMaxWidth();
            area.height = this.tvnTemp.getHeight();
            this.tvnTemp.setBackgroundPainting(bPaintBackground);
            this.tvnTemp.draw(g, area);
            this.tvnTemp.setLocation(p);
            y += this.tvnTemp.getHeight();
            ++this.iNumNodesOnPage;
            this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
        }
    }

    public void addRootNode(addableToTreeView attvRoot) {
        if (attvRoot == null) {
            System.out.println("Fatal Error: Null root node");
            return;
        }
        this.lanTop = null;
        TreeViewScheme scheme = (TreeViewScheme)attvRoot.getScheme();
        TreeViewNode tvnRoot = this.createRootTreeViewNode(attvRoot, scheme);
        tvnRoot.setExpanded(true);
        tvnRoot.committ();
        this.addNode(tvnRoot);
        tvnRoot.setSelected(false);
    }

    protected TreeViewNode createRootTreeViewNode(addableToTreeView attvRoot, TreeViewScheme scheme) {
        return new TreeViewNode(0, this, attvRoot, scheme, true, this.lCommittTime);
    }

    public Image getPlusImage() {
        return this.iPlus;
    }

    public Image getMinusImage() {
        return this.iMinus;
    }

    public int getInset() {
        return this.iInset;
    }

    public int numNodes() {
        return this.iNumNodes;
    }

    public void toggleTreeViewNode(TreeViewNode tvn) {
        if (tvn == null) {
            return;
        }
        if (!tvn.hasChild()) {
            return;
        }
        if (!tvn.getExpanded()) {
            this.addTreeToDisplayList(tvn, this.createChildTreeNode(tvn, this.lCommittTime));
            this.atutvcParent.numNodesChanged(this.iNumNodes);
            tvn.setExpanded(true);
        } else {
            this.subTreeFromDisplayList(tvn);
            this.atutvcParent.numNodesChanged(this.iNumNodes);
            tvn.setExpanded(false);
        }
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.repaint();
    }

    protected void subTreeFromDisplayList(TreeViewNode tvn) {
        DrawableNode tvnNext = null;
        TreeViewNode tvnTemp = null;
        TreeViewNode tvnOldNext = null;
        int iDepth = 0;
        int iTemp = 0;
        if (tvn == null) {
            return;
        }
        iDepth = tvn.getDepth();
        tvnOldNext = tvnTemp = (TreeViewNode)tvn.getNext();
        while (tvnTemp != null) {
            --this.iNumNodes;
            iTemp = tvnTemp.getDepth();
            if (iTemp <= iDepth) {
                tvnNext = tvnTemp;
                ++this.iNumNodes;
                break;
            }
            tvnTemp = (TreeViewNode)tvnTemp.getNext();
        }
        if (tvnOldNext != null && tvnOldNext != tvnTemp) {
            TreeViewNode tvnPrev;
            if (tvnNext != null && (tvnPrev = (TreeViewNode)tvnNext.getPrev()) != null) {
                tvnPrev.setNext(null);
            }
            this.removeTreeLinks(tvnOldNext);
        }
        tvn.setNext(tvnNext);
        if (tvnNext != null) {
            tvnNext.setPrev(tvn);
        }
    }

    public void setSize(Dimension dim) {
        this.setSize(dim.width, dim.height);
    }

    public void setSize(int width, int height) {
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        super.setSize(width, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        super.setBounds(x, y, width, height);
    }

    protected void removeTreeLinks(TreeViewNode tvn) {
        while (tvn != null) {
            tvn = (TreeViewNode)tvn.killMe();
        }
    }

    public void moveToNodeX(int iPos) {
        this.tvnTemp = (TreeViewNode)this.lanCurrent;
        int iDiff = 0;
        if (this.iCurrentNodePos == iPos) {
            return;
        }
        if (this.iCurrentNodePos > iPos) {
            iDiff = this.iCurrentNodePos - iPos;
            while (iDiff-- > 0 && this.tvnTemp != null) {
                this.tvnTemp = (TreeViewNode)this.tvnTemp.getPrev();
                if (this.tvnTemp == null) continue;
                this.lanCurrent = this.tvnTemp;
                --this.iCurrentNodePos;
            }
        } else {
            iDiff = iPos - this.iCurrentNodePos;
            while (iDiff-- > 0 && this.tvnTemp != null) {
                this.tvnTemp = (TreeViewNode)this.tvnTemp.getNext();
                if (this.tvnTemp == null) continue;
                ++this.iCurrentNodePos;
                this.lanCurrent = this.tvnTemp;
            }
        }
        this.atutvcParent.currentNodePos(this.iCurrentNodePos);
        this.bResetNodeLocation = true;
        this.saveOldNodes();
        this.repaint();
    }

    protected void saveOldNodes() {
        this.tvnOldTop = (TreeViewNode)this.lanSelected;
        this.tvnOldBottom = this.tvnBottom;
    }

    public TreeViewNode selectNextPage() {
        if ((TreeViewNode)this.lanSelected == this.tvnBottom) {
            this.moveToNextPage(true);
        } else {
            this.selectNode(this.tvnBottom);
        }
        this.repaint();
        return this.tvnBottom;
    }

    public TreeViewNode selectPrevPage() {
        if (this.lanSelected == this.lanCurrent) {
            this.moveToPrevPage(true);
        } else {
            this.selectNode((TreeViewNode)this.lanCurrent);
        }
        this.repaint();
        return this.tvnBottom;
    }

    public void empty() {
        this.removeTreeLinks((TreeViewNode)this.lanTop);
        this.resetVars();
    }

    protected void resetVars() {
        this.lanCurrent = null;
        this.tvnBottom = null;
        this.lanSelected = null;
        this.tvnPrev = null;
        this.tvnOldTop = null;
        this.tvnOldBottom = null;
        if (this.bMultiSelect) {
            this.unselectAllNodes();
            this.vSelectedNodes.removeAllElements();
            this.vSelectedNodes = new Vector(10, 10);
        }
    }

    public void setNodeLineDrawing(boolean bDrawNodeLines) {
        this.bDrawNodeLines = bDrawNodeLines;
    }

    public void calibratePoint(Point point) {
    }

    public void setDropZone(TreeViewNode tvn) {
        if (this.tvnDropZone != null) {
            this.tvnDropZone.setDropZone(false);
        }
        this.tvnDropZone = tvn;
        if (tvn != null) {
            tvn.setDropZone(true);
        }
        this.repaint();
    }

    public void absoluteRepaint() {
        Graphics g = this.getGraphics();
        this.iOptimisedPaint = 0;
        if (g == null) {
            super.repaint();
            return;
        }
        this.update(g);
    }

    public void drawAsDraggableTarget(boolean bDrawAsDraggable) {
        try {
            this.bDrawAsDraggable = bDrawAsDraggable;
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public void setMultiSelect(boolean bMulitSelect) {
        try {
            this.bMultiSelect = bMulitSelect;
            if (this.bMultiSelect) {
                this.vSelectedNodes = new Vector(10, 10);
            } else if (this.vSelectedNodes != null) {
                this.vSelectedNodes.removeAllElements();
                this.vSelectedNodes = null;
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }

    public Vector findSelectedTreeViewNodes() {
        return this.vSelectedNodes;
    }

    protected void updateCommittTime() {
        this.lCommittTime = System.currentTimeMillis();
    }

    public void finalize() throws Throwable {
        this.empty();
        this.iPlus = null;
        this.iMinus = null;
        this.tvnBottom = null;
        this.atutvcParent = null;
        this.tvnPrev = null;
        this.tvnOldTop = null;
        this.tvnOldBottom = null;
        this.tvnDropZone = null;
        this.attvDesiredTop = null;
        this.pTemp = null;
        this.pTemp2 = null;
        this.dTemp = null;
        this.dTemp2 = null;
        this.tvnTemp = null;
        if (this.vSelectedNodes != null && this.vSelectedNodes.size() > 0) {
            this.vSelectedNodes.removeAllElements();
        }
        this.vSelectedNodes = null;
        super.finalize();
    }
}

