/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.common.Controler;
import com.ibm.eNetwork.onDemand.common.gui.common.ExtendedCanvas;
import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.treeView.DragManager;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewCanvas;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewEvent;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewEventListener;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseDragManager;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import com.ibm.eNetwork.onDemand.common.gui.treeView.treeViewDragManager;
import java.awt.AWTEvent;
import java.awt.Cursor;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Enumeration;
import java.util.Vector;

public class TreeViewControler
extends Controler
implements MouseListener,
KeyListener,
FocusListener,
AdjustmentListener,
ableToUseDragManager,
MouseMotionListener {
    protected TreeViewCanvas tvc;
    protected JVCScrollbar sbHorz;
    protected JVCScrollbar sbVert;
    protected TreeView tv;
    protected boolean bRightMouseButtonClicked = false;
    protected int iKeyCounter;
    protected boolean bMultiSelect = false;
    protected DragManager dm;
    protected treeViewDragManager dragManager;
    protected boolean bMouseDragging = false;
    protected Cursor cOld;
    protected static Cursor cHand = Cursor.getPredefinedCursor(12);

    public TreeViewControler(TreeView tv) {
        this.tv = tv;
        this.dm = DragManager.getDragManager();
    }

    public void register(ExtendedCanvas ec) {
        try {
            TreeViewCanvas tvc = (TreeViewCanvas)ec;
            this.tv.addFocusListener(this);
            tvc.addMouseListener(this);
            tvc.addKeyListener(this);
            tvc.addFocusListener(this);
            tvc.addMouseMotionListener(this);
            this.tvc = tvc;
        }
        catch (Exception exception) {}
    }

    public void unregister(ExtendedCanvas ec) {
        try {
            TreeViewCanvas tvc = (TreeViewCanvas)ec;
            tvc.removeMouseListener(this);
            tvc.removeKeyListener(this);
            tvc.removeFocusListener(this);
            tvc.removeMouseMotionListener(this);
            this.tvc = null;
        }
        catch (Exception exception) {}
    }

    public void registerScrollbars(JVCScrollbar sbHorz, JVCScrollbar sbVert) {
        try {
            sbHorz.addAdjustmentListener(this);
            sbVert.addAdjustmentListener(this);
            this.sbHorz = sbHorz;
            this.sbVert = sbVert;
        }
        catch (Exception exception) {}
    }

    public void unregisterScrollbars(JVCScrollbar sbHorz, JVCScrollbar sbVert) {
        try {
            sbHorz.removeAdjustmentListener(this);
            sbVert.removeAdjustmentListener(this);
            this.sbHorz = null;
            this.sbVert = null;
        }
        catch (Exception exception) {}
    }

    public void keyPressed(KeyEvent e) {
        try {
            TreeViewNode tvn = (TreeViewNode)this.tvc.findCurrent();
            int key = e.getKeyCode();
            boolean bCont = true;
            switch (key) {
                case 10: {
                    this.createEvent(231, tvn);
                    break;
                }
                case 39: {
                    bCont = this.preToggleEvent(tvn);
                    if (bCont) {
                        this.tvc.toggleTreeViewNode(tvn);
                        this.postToggleEvent(tvn);
                    }
                    break;
                }
                case 37: {
                    bCont = this.preToggleEvent(tvn);
                    if (bCont) {
                        this.tvc.toggleTreeViewNode(tvn);
                        bCont = this.postToggleEvent(tvn);
                    }
                    break;
                }
                case 40: {
                    ++this.iKeyCounter;
                    bCont = this.createEvent(232, (TreeViewNode)tvn.getNext());
                    if (bCont) {
                        this.tvc.selectNextNode();
                        this.createEvent(228, (TreeViewNode)tvn.getNext());
                    }
                    break;
                }
                case 38: {
                    ++this.iKeyCounter;
                    bCont = this.createEvent(232, (TreeViewNode)tvn.getPrev());
                    if (bCont) {
                        this.tvc.selectPrevNode();
                        this.createEvent(228, (TreeViewNode)tvn.getPrev());
                    }
                    break;
                }
                case 33: {
                    tvn = this.tvc.selectPrevPage();
                    this.createEvent(228, tvn);
                    break;
                }
                case 34: {
                    tvn = this.tvc.selectNextPage();
                    this.createEvent(228, tvn);
                    break;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {}
    }

    public void keyReleased(KeyEvent e) {
        if (this.iKeyCounter > 2) {
            this.tvc.absoluteRepaint();
        }
        this.iKeyCounter = 0;
    }

    public void keyTyped(KeyEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        try {
            this.bRightMouseButtonClicked = this.rightMouseClick(e);
            this.tvc.requestFocus();
            Point point = e.getPoint();
            this.tvc.calibratePoint(point);
            TreeViewNode tvn = (TreeViewNode)this.tvc.findOnMouseUp(point.x, point.y);
            boolean bCont = true;
            if (tvn == null && this.bRightMouseButtonClicked) {
                PopupMenu pop = this.tv.getPopupMenu();
                Point p = e.getPoint();
                if (pop == null) {
                    return;
                }
                this.tv.add(pop);
                pop.show(this.tv, p.x, p.y);
                return;
            }
            if (tvn == null) {
                return;
            }
            if (tvn.hitPlus(point.x)) {
                bCont = this.preToggleEvent(tvn);
                if (bCont) {
                    this.tvc.toggleTreeViewNode(tvn);
                    this.postToggleEvent(tvn);
                }
            } else if (e.getClickCount() > 1 && !this.bRightMouseButtonClicked) {
                this.createEvent(231, tvn);
            } else if (this.bMultiSelect && !tvn.getSelected() && this.ctrlKeyPressed(e)) {
                bCont = this.createEvent(232, tvn);
                if (bCont) {
                    this.tvc.multiSelectNode(tvn);
                    this.tvc.repaint();
                    this.createEvent(228, tvn);
                }
            } else if (!this.bMultiSelect || tvn.getSelected() || !this.shiftKeyPressed(e)) {
                if (!tvn.getSelected()) {
                    bCont = this.createEvent(232, tvn);
                    if (bCont) {
                        this.tvc.selectNode(tvn);
                        this.tvc.repaint();
                        this.createEvent(228, tvn);
                    }
                } else if (!this.bRightMouseButtonClicked && tvn.getSelected() && this.ctrlKeyPressed(e)) {
                    this.tvc.unselectNode(tvn);
                    this.tvc.repaint();
                } else if (tvn.getPopupMenu() != null && this.bRightMouseButtonClicked && !this.multipleNodesSelected()) {
                    PopupMenu pop = tvn.getPopupMenu();
                    Point p = e.getPoint();
                    this.tv.add(pop);
                    pop.show(this.tv, p.x, p.y);
                } else if (this.tv.getMultiPopupMenu() != null && this.bRightMouseButtonClicked && this.multipleNodesSelected()) {
                    PopupMenu pop = this.tv.getMultiPopupMenu();
                    Point p = e.getPoint();
                    this.tv.add(pop);
                    pop.show(this.tv, p.x, p.y);
                }
            }
            return;
        }
        catch (Exception exp) {
            System.err.println(exp);
            return;
        }
    }

    protected boolean multipleNodesSelected() {
        try {
            Vector v = this.tvc.findSelectedTreeViewNodes();
            if (v == null) {
                return false;
            }
            return v.size() >= 2;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected boolean ctrlKeyPressed(MouseEvent e) {
        try {
            int iModifiers = e.getModifiers();
            return (iModifiers & 2) == 2;
        }
        catch (Exception exp) {
            System.err.println(exp);
            return false;
        }
    }

    protected boolean shiftKeyPressed(MouseEvent e) {
        try {
            int iModifiers = e.getModifiers();
            return (iModifiers & 1) == 1;
        }
        catch (Exception exp) {
            System.err.println(exp);
            return false;
        }
    }

    protected boolean rightMouseClick(MouseEvent e) {
        try {
            int iModifiers = e.getModifiers();
            return iModifiers == 4;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void mouseEntered(MouseEvent e) {
        try {
            if (this.bAutoFocus) {
                this.tvc.requestFocus();
            }
        }
        catch (Exception exception) {}
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseReleased(MouseEvent e) {
        if (this.bMouseDragging) {
            this.bMouseDragging = false;
            Point p = e.getPoint();
            this.dm.stopDrag(this.tvc, p);
            this.tvc.setCursor(this.cOld);
        }
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void focusGained(FocusEvent e) {
        try {
            Object o = e.getSource();
            if (o instanceof TreeView) {
                this.tvc.requestFocus();
            } else if (o instanceof TreeViewCanvas) {
                TreeViewNode tvn = (TreeViewNode)this.tvc.findOnGotFocus();
                tvn.setFocus(true);
                this.tvc.repaint();
            }
        }
        catch (Exception exception) {}
    }

    public void focusLost(FocusEvent e) {
        try {
            TreeViewNode tvn = (TreeViewNode)this.tvc.findOnGotFocus();
            tvn.setFocus(false);
            this.tvc.repaint();
        }
        catch (Exception exception) {}
    }

    public void adjustmentValueChanged(AdjustmentEvent e) {
        try {
            JVCScrollbar sbTemp = (JVCScrollbar)e.getAdjustable();
            if (sbTemp == this.sbHorz) {
                this.horzScrollEvent(e);
            } else if (sbTemp == this.sbVert) {
                this.vertScrollEvent(e);
            }
        }
        catch (Exception exception) {}
    }

    protected boolean isMyEvent(AWTEvent e) {
        try {
            if (e instanceof TreeViewEvent) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    protected boolean sendEvent(AWTEvent e) {
        try {
            Enumeration enumeration = this.hListeners.elements();
            TreeViewEvent tve = (TreeViewEvent)e;
            if (enumeration.hasMoreElements()) {
                TreeViewEventListener listener = (TreeViewEventListener)enumeration.nextElement();
                return tve.sendEvent(listener);
            }
        }
        catch (Exception exception) {}
        return true;
    }

    protected void vertScrollEvent(AdjustmentEvent e) {
        try {
            int iType = e.getAdjustmentType();
            switch (iType) {
                case 1: {
                    this.tvc.moveToNextNode();
                    return;
                }
                case 4: {
                    this.tvc.moveToNextPage(true);
                    return;
                }
                case 2: {
                    this.tvc.moveToPrevNode();
                    return;
                }
                case 3: {
                    this.tvc.moveToPrevPage(true);
                    return;
                }
                case 5: {
                    this.tvc.moveToNodeX(e.getValue());
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    public void horzScrollEvent(AdjustmentEvent e) {
        try {
            if (e.getAdjustmentType() != 5) {
                this.tvc.setHorzOffset(e.getValue());
            }
        }
        catch (Exception exception) {}
    }

    protected boolean preToggleEvent(TreeViewNode tvn) {
        try {
            if (!tvn.hasChild()) {
                return false;
            }
            if (tvn.getExpanded()) {
                return this.createEvent(234, tvn);
            }
            return this.createEvent(233, tvn);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean postToggleEvent(TreeViewNode tvn) {
        try {
            if (tvn.getExpanded()) {
                return this.createEvent(229, tvn);
            }
            return this.createEvent(230, tvn);
        }
        catch (Exception exception) {
            return true;
        }
    }

    protected boolean createEvent(int id, TreeViewNode tvn) {
        try {
            TreeViewEvent tve = new TreeViewEvent(this.tv, tvn, id);
            return this.postEvent(tve);
        }
        catch (Exception exception) {
            return true;
        }
    }

    public void mouseDragged(MouseEvent e) {
        if (this.dragManager == null) {
            return;
        }
        if (!this.bMouseDragging) {
            this.bMouseDragging = true;
            TreeViewNode tvn = (TreeViewNode)this.tvc.findCurrent();
            if (tvn == null) {
                return;
            }
            addableToTreeView attvNode = tvn.getData();
            this.dragManager.elementDragStarted(this.tv, tvn.getData());
            this.dm.startDrag(this.tvc, attvNode);
            this.cOld = this.tvc.getCursor();
            this.tvc.setCursor(cHand);
        }
        this.dm.drag(this.tvc, e.getPoint());
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void setMultiSelect(boolean bMultiSelect) {
        this.bMultiSelect = bMultiSelect;
    }

    public void setDragManager(treeViewDragManager dragManager) {
        this.dragManager = dragManager;
        if (dragManager != null) {
            this.dm.registerView(this.tvc, this);
        } else {
            this.dm.unregisterView(this.tvc, this);
        }
    }

    public void drawGhostAt(Point p) {
        TreeViewNode tvn = (TreeViewNode)this.tvc.findOnMouseUp(p.x, p.y);
        this.tvc.setDropZone(tvn);
    }

    public boolean droppedAt(Point p, addableToTreeView attvData) {
        this.tvc.setDropZone(null);
        TreeViewNode tvn = (TreeViewNode)this.tvc.findOnMouseUp(p.x, p.y);
        if (tvn == null) {
            return false;
        }
        this.dragManager.elementDropped(this.tv, tvn.getData());
        return true;
    }

    public void dropAccomplished(boolean bAccomplished, addableToTreeView attvData) {
        this.dragManager.elementDragStoped(this.tv, attvData, bAccomplished);
    }

    public void dispose() {
        this.tvc = null;
        this.sbHorz = null;
        this.sbVert = null;
        this.tv = null;
        this.dragManager = null;
        this.dm = null;
    }
}

