/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.jvcScrollbar.JVCScrollbar;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewCanvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.Hashtable;

public class TreeViewLayout
implements LayoutManager {
    public static final String VERTICAL_SCROLLBAR = "sbVert";
    public static final String HORIZONTAL_SCROLLBAR = "sbHorz";
    public static final String TREEVIEW_CANVAS = "tvc";
    protected TreeViewCanvas tvc;
    protected JVCScrollbar sbVert;
    protected JVCScrollbar sbHorz;
    protected Hashtable hash = new Hashtable();
    protected Dimension dimView;
    protected int iScrollOffset = 15;
    protected int iOffset;

    public void addLayoutComponent(String name, Component comp) {
        this.hash.put(name, comp);
    }

    public void removeLayoutComponent(Component comp) {
        this.hash.remove(comp);
    }

    public Dimension preferredLayoutSize(Container parent) {
        return this.dimView;
    }

    public Dimension minimumLayoutSize(Container parent) {
        return this.dimView;
    }

    public void setPreferredSize(Dimension d) {
        this.dimView = d;
    }

    public void layoutContainer(Container parent) {
        try {
            Dimension d = parent.getSize();
            this.positionVertScrollBar((JVCScrollbar)this.hash.get(VERTICAL_SCROLLBAR), d);
            this.positionHorzScrollBar((JVCScrollbar)this.hash.get(HORIZONTAL_SCROLLBAR), d);
            this.positionTreeView((TreeViewCanvas)this.hash.get(TREEVIEW_CANVAS), d);
        }
        catch (Exception exception) {
            System.err.println(String.valueOf(this) + " layout falied");
        }
    }

    protected void positionVertScrollBar(JVCScrollbar sbVert, Dimension d) {
        int iWidth = d.width;
        int iHeight = d.height;
        this.sbVert = sbVert;
        sbVert.setBounds(iWidth - this.iScrollOffset - this.iOffset, this.iOffset, this.iScrollOffset, iHeight - this.iOffset * 2 - this.iScrollOffset);
        sbVert.invalidate();
        sbVert.doLayout();
    }

    protected void positionHorzScrollBar(JVCScrollbar sbHorz, Dimension d) {
        int iWidth = d.width;
        int iHeight = d.height;
        this.sbHorz = sbHorz;
        sbHorz.setBounds(this.iOffset, iHeight - this.iScrollOffset - this.iOffset, iWidth - this.iOffset * 2 - this.iScrollOffset, this.iScrollOffset);
        sbHorz.invalidate();
        sbHorz.doLayout();
    }

    protected void positionTreeView(TreeViewCanvas tvc, Dimension d) {
        this.tvc = tvc;
        tvc.setBounds(this.iOffset, this.iOffset, d.width - this.iScrollOffset - this.iOffset * 2, d.height - this.iScrollOffset - this.iOffset * 2);
        tvc.invalidate();
        tvc.doLayout();
    }

    public String toString() {
        return "TreeViewLayout";
    }

    public void dispose() {
        this.tvc = null;
        this.sbVert = null;
        this.sbHorz = null;
        this.hash.clear();
        this.hash = null;
    }
}

