/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.gui.treeView;

import com.ibm.eNetwork.onDemand.common.gui.common.ImagesForCanvas;
import com.ibm.eNetwork.onDemand.common.gui.common.LeftAlignedNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewNodeState;
import com.ibm.eNetwork.onDemand.common.gui.treeView.TreeViewScheme;
import com.ibm.eNetwork.onDemand.common.gui.treeView.ableToUseTreeViewNode;
import com.ibm.eNetwork.onDemand.common.gui.treeView.addableToTreeView;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.BitSet;

public class TreeViewNode
extends LeftAlignedNode {
    protected int iDepth = -1;
    protected boolean bLeafNode = false;
    protected boolean bDrawDropZone = false;
    protected ableToUseTreeViewNode atutvnParent;
    public static final int NORMAL_ICON = 0;
    public static final int SELECTED_ICON = 1;
    protected addableToTreeView attvNode;
    protected boolean bDrawLines = true;
    int iIndex;
    protected boolean bHasChild = false;
    protected boolean bChildSet = false;
    protected BitSet bitset;

    public TreeViewNode(int iIndex, ableToUseTreeViewNode atutvnParent, addableToTreeView attvNode, TreeViewScheme scheme, boolean bDrawLines, long lCommittTime) {
        super(attvNode.getText().getText(iIndex), scheme.getColors(iIndex), scheme.getFonts(iIndex), scheme.getImages(iIndex));
        this.atutvnParent = atutvnParent;
        this.attvNode = attvNode;
        this.iIndex = iIndex;
        if (attvNode.getState() == null) {
            TreeViewNodeState tvns = this.createTreeViewNodeState(lCommittTime);
            attvNode.setState(tvns);
        }
        this.bDrawLines = bDrawLines;
    }

    protected TreeViewNodeState createTreeViewNodeState(long lCommittTime) {
        TreeViewNodeState tvns = new TreeViewNodeState();
        tvns.tvn = this;
        tvns.lCommittTime = lCommittTime;
        return tvns;
    }

    public addableToTreeView getData() {
        return this.attvNode;
    }

    public void setLineDrawing(boolean bDrawLines) {
        this.bDrawLines = bDrawLines;
    }

    public void setLeafNode(boolean bLeafNode) {
        this.bLeafNode = bLeafNode;
    }

    public boolean getLeafNode() {
        return this.bLeafNode;
    }

    public void setDepth(int iDepth) {
        this.iDepth = iDepth;
    }

    public int getDepth() {
        return this.iDepth;
    }

    public boolean hasChild() {
        if (!this.bChildSet) {
            this.bChildSet = true;
            this.bHasChild = this.attvNode.getChildNode() != null;
        }
        return this.bHasChild;
    }

    public void resetNode() {
        this.bChildSet = false;
        this.bitset = null;
        this.bLeafNode = false;
    }

    public void setSelected(boolean bSelected) {
        try {
            super.setSelected(bSelected);
            TreeViewNodeState tvns = (TreeViewNodeState)this.attvNode.getState();
            tvns.bSelected = bSelected;
            this.setFocus(bSelected);
        }
        catch (Exception exception) {}
    }

    public boolean getSelected() {
        try {
            TreeViewNodeState tvns = (TreeViewNodeState)this.attvNode.getState();
            return tvns.bSelected;
        }
        catch (Exception exception) {
            return false;
        }
    }

    protected void setDropZone(boolean bDropZone) {
        this.bDrawDropZone = bDropZone;
    }

    public void draw(Graphics g, Rectangle area) {
        Image iImage = this.ifcImage.getImage(0);
        Image iImage2 = this.ifcImage.getImage(1);
        boolean bHasChild = this.hasChild();
        TreeViewScheme scheme = (TreeViewScheme)this.attvNode.getScheme();
        ImagesForCanvas gfcFolders = scheme.getFolders();
        if (bHasChild) {
            this.ifcImage.addImage(gfcFolders.getImage(1), 1);
            this.ifcImage.addImage(gfcFolders.getImage(0), 0);
        }
        if (this.getSelected()) {
            this.drawHighlight(g, area, bHasChild);
        }
        if (this.bDrawDropZone) {
            this.drawDropZone(g, area, bHasChild);
        }
        if (this.bDrawLines) {
            this.drawLines(g, area);
        }
        if (bHasChild) {
            this.drawPlus(g, area);
        }
        super.draw(g, area);
        if (bHasChild) {
            if (iImage != null) {
                this.ifcImage.addImage(iImage, 0);
            } else {
                this.ifcImage.removeImage(0);
            }
            if (iImage2 != null) {
                this.ifcImage.addImage(iImage2, 1);
            } else {
                this.ifcImage.removeImage(1);
            }
        }
    }

    public String toString() {
        try {
            String sText = this.attvNode.getText().getText(this.iIndex);
            return sText;
        }
        catch (Exception exception) {
            return "toString() failed";
        }
    }

    protected void drawPlus(Graphics g, Rectangle area) {
        Image iImage = null;
        int iOffset = 0;
        iImage = this.getExpanded() ? this.atutvnParent.getMinusImage() : this.atutvnParent.getPlusImage();
        iOffset = (this.getHeight() - this.ifcImage.getImageHeight(iImage)) / 2;
        if (iImage != null) {
            g.drawImage(iImage, area.x - this.ifcImage.getImageWidth(iImage) + this.atutvnParent.getInset() / 2, area.y + iOffset, null);
        }
    }

    public void drawHighlight(Graphics g, Rectangle area, boolean bHasChild) {
        int iHeight = this.getHeight();
        int iWidth = this.getWidth();
        int iOffset = this.iHorzSpace;
        if (bHasChild) {
            iOffset += this.ifcImage.getImageWidth(0);
        }
        g.setColor(this.cfcColor.getColor(2));
        g.fillRect(area.x + iOffset, area.y, iWidth - iOffset - this.iHorzSpace - 1, iHeight - 1);
        if (this.hasFocus()) {
            g.setColor(Color.black);
            g.drawRect(area.x + iOffset, area.y, iWidth - iOffset - this.iHorzSpace - 1, iHeight - 1);
        }
    }

    public void drawDropZone(Graphics g, Rectangle area, boolean bHasChild) {
        int iHeight = this.getHeight();
        int iWidth = this.getWidth();
        int iOffset = this.iHorzSpace;
        if (bHasChild) {
            iOffset += this.ifcImage.getImageWidth(0);
        }
        g.setColor(Color.green);
        g.fillRect(area.x + iOffset, area.y, iWidth - iOffset - this.iHorzSpace - 1, iHeight - 1);
    }

    public TreeViewNode createNextTreeNode(long lCommittTime) {
        addableToTreeView attvNew = this.attvNode.getNextNode();
        return this.createNewNode(attvNew, lCommittTime);
    }

    public TreeViewNode createBastardTreeNode(addableToTreeView attvNew, long lCommittTime) {
        return this.createNewNode(attvNew, 0L);
    }

    public TreeViewNode createChildTreeNode(long lCommittTime) {
        addableToTreeView attvNew = this.attvNode.getChildNode();
        return this.createNewNode(attvNew, lCommittTime);
    }

    protected TreeViewNode createNewNode(addableToTreeView attvNew, long lCommittTime) {
        if (attvNew == null) {
            return null;
        }
        TreeViewNode tvn = null;
        TreeViewNodeState tvns = (TreeViewNodeState)attvNew.getState();
        if (tvns != null) {
            tvn = tvns.tvn;
        }
        if (tvn == null) {
            TreeViewScheme scheme = (TreeViewScheme)attvNew.getScheme();
            TreeViewNode tvnNew = new TreeViewNode(0, this.atutvnParent, attvNew, scheme, this.bDrawLines, lCommittTime);
            tvnNew.committ();
            return tvnNew;
        }
        if (tvns.lCommittTime < lCommittTime) {
            tvn.committ();
            tvns.lCommittTime = lCommittTime;
        }
        tvn.resetNode();
        return tvn;
    }

    public void setExpanded(boolean bExpanded) {
        try {
            TreeViewNodeState tvns = (TreeViewNodeState)this.attvNode.getState();
            tvns.bExpanded = bExpanded;
        }
        catch (Exception exception) {}
    }

    public boolean getExpanded() {
        try {
            TreeViewNodeState tvns = (TreeViewNodeState)this.attvNode.getState();
            return tvns.bExpanded;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void committ() {
        TreeViewScheme scheme = (TreeViewScheme)this.attvNode.getScheme();
        this.updateAttribs(scheme.getColors(this.iIndex), scheme.getFonts(this.iIndex), scheme.getImages(this.iIndex));
        this.sText = this.attvNode.getText().getText(this.iIndex);
        if (this.sText == null) {
            this.sText = "";
        }
        this.setPopupMenu(scheme.getPopupMenu(this.iIndex));
        super.committ();
    }

    protected void paintBackground(Graphics g, Rectangle area) {
        int iHeight = 0;
        int iWidth = 0;
        int iOffset = 0;
        if (this.bPaintBackground && !this.getSelected()) {
            iHeight = area.height;
            iWidth = area.width;
            iOffset = this.iHorzSpace;
            g.setColor(this.cfcColor.getColor(0));
            g.fillRect(area.x + iOffset, area.y, iWidth - iOffset - this.iHorzSpace, iHeight);
        }
    }

    protected void drawLines(Graphics g, Rectangle area) {
        addableToTreeView attvNode = null;
        Object attvNode2 = null;
        int cnt = 0;
        int offset = 0;
        int iHeight = this.getHeight();
        int iInset = this.atutvnParent.getInset();
        attvNode = this.attvNode;
        g.setColor(this.cfcColor.getColor(1));
        this.createLineBitSet();
        cnt = this.iDepth;
        while (cnt > 0) {
            if (this.bitset.get(cnt)) {
                g.drawLine(area.x - iInset * (this.iDepth - cnt + 1), area.y, area.x - iInset * (this.iDepth - cnt + 1), area.y + iHeight);
            }
            --cnt;
        }
        if (this.iDepth != 1) {
            if (this.bLeafNode) {
                offset = iHeight / 2;
            }
            g.drawLine(area.x, area.y, area.x, area.y + iHeight - offset);
        }
        offset = iHeight / 2;
        g.drawLine(area.x, area.y + iHeight - offset, area.x + this.iHorzSpace, area.y + iHeight - offset);
    }

    protected void createLineBitSet() {
        if (this.bitset != null) {
            return;
        }
        addableToTreeView attvNode = this.attvNode;
        addableToTreeView attvNode2 = null;
        int cnt = 0;
        this.bitset = new BitSet(this.iDepth);
        cnt = this.iDepth;
        while (cnt > 0) {
            if ((attvNode = attvNode.getParentNode()) == null) break;
            attvNode2 = attvNode.getNextNode();
            if (attvNode2 != null) {
                this.bitset.set(cnt);
            }
            --cnt;
        }
    }

    public boolean hitPlus(int x) {
        try {
            Point p = null;
            p = this.getLocation();
            if (x < p.x + this.iHorzSpace / 2) {
                return true;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    public addableToTreeView getAddableToTreeView() {
        return this.attvNode;
    }

    protected void calcSpaces() {
        super.calcSpaces();
        this.iVertSpace = 0;
    }

    public int getMaxWidth() {
        return this.getWidth();
    }
}

