/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.eNetwork.onDemand.common.sort;

import com.ibm.eNetwork.onDemand.common.sort.Comparable;
import com.ibm.eNetwork.onDemand.common.sort.SortAlgorithm;
import java.util.Vector;

public class QuickSort
extends SortAlgorithm {
    private static final int CUTOFF_VALUE = 20;

    private final int partition(Vector v, int left, int right, Object constraints, boolean bAscending) throws Exception {
        int mid = (left + right) / 2;
        if (bAscending) {
            if (this.compare(v, left, mid, constraints) > 0) {
                this.swap(v, left, mid);
            }
            if (this.compare(v, left, right, constraints) > 0) {
                this.swap(v, left, right);
            }
            if (this.compare(v, mid, right, constraints) > 0) {
                this.swap(v, mid, right);
            }
        } else {
            if (this.compare(v, left, mid, constraints) < 0) {
                this.swap(v, left, mid);
            }
            if (this.compare(v, left, right, constraints) < 0) {
                this.swap(v, left, right);
            }
            if (this.compare(v, mid, right, constraints) < 0) {
                this.swap(v, mid, right);
            }
        }
        int j = right - 1;
        this.swap(v, mid, j);
        int i = left;
        Comparable element = (Comparable)v.elementAt(j);
        do {
            if (bAscending) {
                while (this.compare(v, ++i, element, constraints) < 0) {
                }
                while (this.compare(v, --j, element, constraints) > 0) {
                }
            } else {
                while (this.compare(v, ++i, element, constraints) > 0) {
                }
                while (this.compare(v, --j, element, constraints) < 0) {
                }
            }
            this.swap(v, i, j);
        } while (i < j);
        this.swap(v, j, i);
        this.swap(v, i, right - 1);
        return i;
    }

    private final int compare(Vector v, int index1, int index2, Object constraints) throws Exception {
        return ((Comparable)v.elementAt(index1)).compareTo((Comparable)v.elementAt(index2), constraints);
    }

    private final int compare(Vector v, int index1, Comparable element, Object constraints) throws Exception {
        return ((Comparable)v.elementAt(index1)).compareTo(element, constraints);
    }

    private final int compare(Comparable element1, Comparable element2, Object constraints) throws Exception {
        return element1.compareTo(element2, constraints);
    }

    private void quickSort(Vector v, int left, int right, Object constraints, boolean bAscending) throws Exception {
        int[] nStack = new int[Math.max(Math.abs(right - left) * 2 + 20, 50)];
        int p = 2;
        do {
            if (right > left) {
                if (right - left > 20) {
                    int i = this.partition(v, left, right, constraints, bAscending);
                    if (i - left > right - i) {
                        nStack[p++] = left;
                        nStack[p++] = i - 1;
                        left = i + 1;
                        continue;
                    }
                    nStack[p++] = i + 1;
                    nStack[p++] = right;
                    right = i - 1;
                    continue;
                }
                this.insSort(v, left, right, constraints, bAscending);
                right = nStack[--p];
                left = nStack[--p];
                continue;
            }
            right = nStack[--p];
            left = nStack[--p];
        } while (p > 0 && !this.stopRequested);
    }

    private final void insSort(Vector vSort, int left, int right, Object constraints, boolean bAscending) throws Exception {
        int i = left + 1;
        while (i <= right) {
            int k;
            int j;
            Comparable save = (Comparable)vSort.elementAt(i);
            if (bAscending) {
                j = i;
                k = j - 1;
                while (j > 0 && this.compare(vSort, k, save, constraints) > 0) {
                    vSort.setElementAt(vSort.elementAt(k), j);
                    --j;
                    --k;
                }
            } else {
                j = i;
                k = j - 1;
                while (j > 0 && this.compare(vSort, k, save, constraints) < 0) {
                    vSort.setElementAt(vSort.elementAt(k), j);
                    --j;
                    --k;
                }
            }
            vSort.setElementAt(save, j);
            ++i;
        }
    }

    private final void swap(Vector vSort, int i, int j) {
        Object T = vSort.elementAt(i);
        vSort.setElementAt(vSort.elementAt(j), i);
        vSort.setElementAt(T, j);
    }

    public void sort(Vector vSort) throws Exception {
        this.sort(vSort, null);
    }

    public void sort(Vector vSort, Object constraints) throws Exception {
        this.sort(vSort, constraints, true);
    }

    public void sort(Vector vSort, Object constraints, boolean bAscending) throws Exception {
        if (vSort.size() < 2) {
            return;
        }
        this.quickSort(vSort, 0, vSort.size() - 1, constraints, bAscending);
    }

    public void insert(Vector vSort, Comparable element) throws Exception {
        this.insert(vSort, element, null);
    }

    public void insert(Vector vSort, Comparable element, Object constraints) throws Exception {
        this.insert(vSort, element, constraints, true);
    }

    public void insert(Vector vSort, Comparable element, Object constraints, boolean bAscending) throws Exception {
        if (vSort.size() == 0) {
            vSort.addElement(element);
        } else {
            this.ins(vSort, element, 0, vSort.size() - 1, constraints, bAscending);
        }
    }

    private void ins(Vector vSort, Comparable element, int left, int right, Object constraints, boolean bAscending) {
        if (left > right) {
            vSort.insertElementAt(element, left);
        } else {
            int mid = (left + right) / 2;
            int nResult = element.compareTo((Comparable)vSort.elementAt(mid), constraints);
            if (nResult > 0) {
                if (bAscending) {
                    this.ins(vSort, element, mid + 1, right, constraints, bAscending);
                } else {
                    this.ins(vSort, element, left, mid - 1, constraints, bAscending);
                }
            } else if (nResult < 0) {
                if (bAscending) {
                    this.ins(vSort, element, left, mid - 1, constraints, bAscending);
                } else {
                    this.ins(vSort, element, mid + 1, right, constraints, bAscending);
                }
            } else {
                vSort.insertElementAt(element, mid);
            }
        }
    }
}

