/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.app;

import COM.ibm.netdiver.app.NdActionListener;
import COM.ibm.netdiver.app.NdActions;
import COM.ibm.netdiver.app.NdApp;
import COM.ibm.netdiver.app.NdController;
import COM.ibm.netdiver.app.lib.LRUWebContentCache;
import COM.ibm.netdiver.app.lib.NavigationLog;
import COM.ibm.netdiver.browser.HTMLDocumentWindow;
import COM.ibm.netdiver.gui.BarLevelMeter;
import COM.ibm.netdiver.gui.Button3D;
import COM.ibm.netdiver.gui.CacheManager;
import COM.ibm.netdiver.gui.GridBagPanel;
import COM.ibm.netdiver.gui.WWWClient;
import COM.ibm.netdiver.gui.WebBrowserWindow;
import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.net.UserClient;
import COM.ibm.netdiver.util.MessageResourceBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;

public final class Diver
extends WebBrowserWindow
implements NdApp,
NdActions {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private NavigationLog navigator = new NavigationLog();
    private boolean navigating = false;
    private Panel controlPanel;
    private BarLevelMeter statusLevel;
    private Thread meterThread;
    private NdController controller;
    private MessageResourceBundle rb = MessageResourceBundle.getResource("COM.ibm.netdiver.app.res.DiverMessage");
    private static String[] navigationButtonIDs = new String[]{"Back", "Forward", "Reload", "Refresh", "Stop"};
    private String[] navigationButtonNames = new String[navigationButtonIDs.length];
    private TextField urlField;
    private TextField statusField;
    private static final int HORZ = 2;

    public Diver() {
        this.setBackground(Color.lightGray);
        this.setClient(new HTMLDocumentWindow(this));
        this.statusLevel = new BarLevelMeter();
        if (this.meterThread == null) {
            this.meterThread = new Thread(this.statusLevel);
            this.meterThread.setPriority(10);
            this.meterThread.start();
        }
        this.navigationButtonNames[0] = this.rb.getFixedString("B_BACK", "Back");
        this.navigationButtonNames[1] = this.rb.getFixedString("B_FORWARD", "Forward");
        this.navigationButtonNames[2] = this.rb.getFixedString("B_RELOAD", "Reload");
        this.navigationButtonNames[3] = this.rb.getFixedString("B_REFRESH", "Refresh");
        this.navigationButtonNames[4] = this.rb.getFixedString("B_STOP", "Stop");
    }

    public void notifiedLoadStart() {
        super.notifiedLoadStart();
        if (this.statusLevel != null && this.meterThread != null) {
            this.statusLevel.start();
        }
    }

    public void notifiedLoadComplete() {
        super.notifiedLoadComplete();
        if (this.statusLevel != null && this.meterThread != null) {
            this.statusLevel.stop();
        }
    }

    public void putLog(URI uRI, String string) {
        String string2 = uRI.toExternalForm();
        if (this.urlField != null) {
            ((TextComponent)this.urlField).setText(string2);
        }
        if (!this.navigating) {
            this.navigator.put(string2, string);
            return;
        }
        this.navigating = false;
    }

    public void loadDocument(String string) {
        this.navigating = false;
        this.load(string);
    }

    public void forwardDocument() {
        this.navigateDocument(true);
    }

    public void backDocument() {
        this.navigateDocument(false);
    }

    /*
     * Unable to fully structure code
     */
    public void navigateDocument(boolean var1_1) {
        block2: {
            var2_2 = this.navigator.getCurrentTarget();
            v0 = var3_3 = var1_1 != false ? this.navigator.forward() : this.navigator.back();
            if (var3_3 == null) break block2;
            this.navigating = true;
            var4_4 = this.navigator.getCurrentTarget();
            if (var4_4 == null) {
                this.load(var3_3);
                return;
            }
            var5_5 = this.getChildWindow(var4_4);
            if (var5_5 == null) ** GOTO lbl17
            var5_5.load(var3_3);
            return;
lbl-1000:
            // 1 sources

            {
                var4_4 = this.navigator.getCurrentTarget();
                if (var4_4 != var2_2 || (var5_5 = this.getChildWindow(var4_4)) == null) continue;
                var5_5.load(var3_3);
                return;
lbl17:
                // 2 sources

                ** while ((var3_3 = var1_1 != false ? this.navigator.forward() : this.navigator.back()) != null && var4_4 != null)
            }
lbl18:
            // 1 sources

            this.load(var3_3);
        }
    }

    public void reloadDocument() {
        this.navigating = true;
        this.reload();
    }

    public void stopDocument() {
        super.stop();
    }

    public void addMenus(MenuBar menuBar) {
        MenuItem menuItem = new MenuItem(this.rb.getFixedString("MI_APPLETSECURITY", "Applet Security"));
        NdActionListener ndActionListener = new NdActionListener("AppletSecurity", this);
        menuItem.addActionListener(ndActionListener);
        MenuItem menuItem2 = new MenuItem(this.rb.getFixedString("MI_CODEPAGE", "Document Codepage"));
        menuItem2.addActionListener(new NdActionListener("Codepage", this));
        Menu menu = new Menu(this.rb.getFixedString("ML_OPTIONS", "Options"));
        menu.add(menuItem);
        menu.add(menuItem2);
        menuBar.add(menu);
    }

    public void addTopMenuItems(Menu menu) {
    }

    public synchronized Component controlPanel() {
        if (this.controlPanel == null) {
            GridBagPanel gridBagPanel = new GridBagPanel();
            gridBagPanel.setBackground(Color.lightGray);
            this.urlField = new TextField();
            NdActionListener ndActionListener = new NdActionListener(null, this);
            this.urlField.addActionListener(ndActionListener);
            gridBagPanel.setItemSize(3, 1);
            gridBagPanel.add((Component)this.statusLevel, 2, 1.0);
            gridBagPanel.newLine();
            gridBagPanel.setItemSize(1, 1);
            gridBagPanel.add((Component)new Label("URL:", 1), 2, 0.05);
            gridBagPanel.add((Component)this.urlField, 2, 0.9);
            gridBagPanel.newLine();
            Panel panel = new Panel();
            panel.setBackground(gridBagPanel.getBackground());
            panel.setLayout(new GridLayout(1, navigationButtonIDs.length));
            int n = 0;
            while (n < navigationButtonIDs.length) {
                ndActionListener = new NdActionListener(navigationButtonIDs[n], this);
                Button3D button3D = new Button3D(this.navigationButtonNames[n]);
                panel.add(button3D);
                button3D.addActionListener(ndActionListener);
                ++n;
            }
            gridBagPanel.setItemSize(3, 1);
            gridBagPanel.add((Component)panel, 2, 1.0);
            this.controlPanel = gridBagPanel;
        }
        return this.controlPanel;
    }

    public Component component() {
        return this;
    }

    public void initialize(NdController ndController, UserClient userClient, String[] stringArray) {
        this.controller = ndController;
        if (userClient instanceof WWWClient) {
            this.setWWWClient((WWWClient)((Object)userClient));
        } else {
            this.setWWWClient(new WWWClientImpl(userClient));
        }
        if (stringArray != null && stringArray.length > 0) {
            this.loadDocument(stringArray[0]);
        }
    }

    public void implementActions(String string) {
        if (string == null) {
            this.loadDocument(this.urlField.getText());
            return;
        }
        if (string.equals("Back")) {
            this.backDocument();
            return;
        }
        if (string.equals("Forward")) {
            this.forwardDocument();
            return;
        }
        if (string.equals("Reload")) {
            this.reloadDocument();
            return;
        }
        if (string.equals("Refresh")) {
            this.update();
            return;
        }
        if (string.equals("Stop")) {
            this.stopDocument();
            return;
        }
        if (string.equals("AppletSecurity")) {
            this.userClient().setSecurity();
            return;
        }
        if (string.equals("Codepage")) {
            this.controller.setCodepage(this.userClient());
            return;
        }
    }

    class WWWClientImpl
    implements WWWClient {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private UserClient userClient;
        private LRUWebContentCache cacheManager;

        WWWClientImpl(UserClient userClient) {
            Diver.this = Diver.this;
            this.userClient = userClient;
            this.cacheManager = new LRUWebContentCache();
        }

        public UserClient getUserClient() {
            return this.userClient;
        }

        public CacheManager getCacheManager() {
            return this.cacheManager;
        }

        public void setTitle(String string) {
        }

        public void setStatus(String string) {
        }

        public void setCursor(int n) {
        }
    }
}

