/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.app;

import COM.ibm.netdiver.app.AuthenticateDialog;
import COM.ibm.netdiver.app.CodepageDialog;
import COM.ibm.netdiver.app.NdActionListener;
import COM.ibm.netdiver.app.NdActions;
import COM.ibm.netdiver.app.NdApp;
import COM.ibm.netdiver.app.NdController;
import COM.ibm.netdiver.app.SecurityDialog;
import COM.ibm.netdiver.app.lib.LRUWebContentCache;
import COM.ibm.netdiver.browser.LocalAppletSecurityParameters;
import COM.ibm.netdiver.browser.NdSecurityManager;
import COM.ibm.netdiver.browser.RemoteAppletSecurityParameters;
import COM.ibm.netdiver.gui.CacheManager;
import COM.ibm.netdiver.gui.Canvas3D;
import COM.ibm.netdiver.gui.WWWClient;
import COM.ibm.netdiver.net.Authentication;
import COM.ibm.netdiver.net.UserClient;
import COM.ibm.netdiver.util.MessageResourceBundle;
import COM.ibm.netdiver.util.Package;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Point;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.util.Properties;

public class FlatTop
extends Frame
implements WWWClient,
UserClient,
LayoutManager,
ComponentListener,
WindowListener,
NdActions,
NdController {
    String stupid_way = "Licensed Materials - Property of IBM    IBM NetDiver    (c) Copyright IBM Corp.  1997.  All rights reserved.    US Government Users Restrictetd Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final int DEFAULT_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 700;
    private NdApp app;
    private Canvas3D statusField;
    private NdApp browser;
    private NdApp composer;
    private Component appComponent;
    private Component appControlPanel;
    private boolean fcomposed = false;
    private SecurityDialog securityPanel;
    private MessageResourceBundle rb = MessageResourceBundle.getResource("COM.ibm.netdiver.app.res.FlatTopMessage");
    private static final String[] sAppMenus = new String[]{"Browser"};
    private static final String[] sAppClassNames = new String[]{"COM.ibm.netdiver.app.Diver"};
    private NdApp[] apps = new NdApp[sAppMenus.length];
    private MenuItem[] appMenus = new MenuItem[sAppMenus.length];
    private MenuItem menuClose;
    private static final String signature = "NetDiver";
    Properties properties = new Properties(System.getProperties());
    private String documentCodepage;
    LRUWebContentCache cacheManager = new LRUWebContentCache();
    private static final int hgap = 4;
    private static final int vgap = 4;

    public FlatTop() {
        this.addWindowListener(this);
        this.addComponentListener(this);
        ((Component)this).setBackground(Color.lightGray);
        this.setLayout(this);
        this.statusField = new Canvas3D();
        this.enableEvents(2015L);
        if (System.getSecurityManager() == null) {
            NdSecurityManager ndSecurityManager = new NdSecurityManager();
            ndSecurityManager.setPermittedLibrary("djpeglib");
            ndSecurityManager.setPermittedLibrary("COM.ibm.netdiver.net");
            ndSecurityManager.setSecurityParameters(new RemoteAppletSecurityParameters());
            ndSecurityManager.setSecurityParameters(new LocalAppletSecurityParameters());
            System.setSecurityManager(ndSecurityManager);
        }
    }

    public synchronized void setNdApp(NdApp ndApp, String[] stringArray) {
        this.app = ndApp;
        if (ndApp != null) {
            this.fcomposed = true;
        }
        this.removeAll();
        this.createMenuBar();
        this.add(this.statusField);
        this.requestFocus();
        if (ndApp != null) {
            ndApp.initialize(this, this, stringArray);
            this.appControlPanel = ndApp.controlPanel();
            this.appComponent = ndApp.component();
            this.add(this.appControlPanel);
            this.add(this.appComponent);
        }
        this.validate();
        this.fcomposed = true;
        this.repaint();
    }

    private void createMenuBar() {
        NdActionListener ndActionListener;
        MenuBar menuBar = new MenuBar();
        Menu menu = new Menu(this.rb.getFixedString("ML_FRAME", "Frame"));
        if (this.app != null) {
            this.app.addTopMenuItems(menu);
        }
        if (this.menuClose == null) {
            this.menuClose = new MenuItem(this.rb.getFixedString("MI_CLOSE", "Close"));
            ndActionListener = new NdActionListener("Close", this);
            this.menuClose.addActionListener(ndActionListener);
        }
        menu.add(this.menuClose);
        menuBar.add(menu);
        Menu menu2 = new Menu(this.rb.getFixedString("ML_SWITCHTO", "SwitchTo"));
        int n = 0;
        while (n < sAppMenus.length) {
            if (this.appMenus[n] == null) {
                this.appMenus[n] = new MenuItem(sAppMenus[n]);
                ndActionListener = new NdActionListener(sAppMenus[n], this);
                this.appMenus[n].addActionListener(ndActionListener);
            }
            menu2.add(this.appMenus[n]);
            ++n;
        }
        menuBar.add(menu2);
        if (this.app != null) {
            this.app.addMenus(menuBar);
        }
        Dimension dimension = this.getSize();
        this.setMenuBar(menuBar);
        ((Component)this).setSize(dimension);
    }

    void launch(String string, String[] stringArray) {
        try {
            Object object = null;
            int n = 0;
            while (n < sAppMenus.length) {
                if (string.equals(sAppClassNames[n])) {
                    if (object == null) {
                        object = Package.createInstance(null, string);
                        this.apps[n] = (NdApp)object;
                        break;
                    }
                    object = this.apps[n];
                    break;
                }
                ++n;
            }
            if (object == null) {
                object = Package.createInstance(null, string);
            }
            if (object != null && object instanceof NdApp) {
                this.setNdApp((NdApp)object, stringArray);
                return;
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            return;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return;
        }
        catch (InstantiationException instantiationException) {}
    }

    private void exit() {
        this.dispose();
        System.exit(0);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        if (!this.fcomposed) {
            return;
        }
        Dimension dimension = this.getSize();
        Font font = new Font("SansSerif", 3, 48);
        FontMetrics fontMetrics = this.getFontMetrics(font);
        Insets insets = this.getInsets();
        int n = insets.left;
        int n2 = insets.top;
        int n3 = dimension.width - insets.right;
        int n4 = dimension.height - insets.bottom;
        int n5 = fontMetrics.stringWidth(signature);
        int n6 = fontMetrics.getHeight();
        graphics.setFont(font);
        int n7 = (n3 - n - n5) / 2;
        int n8 = (n4 - n2 - n6) / 2;
        graphics.setColor(Color.gray);
        graphics.drawString(signature, n7 + 1, n8 + 1);
        graphics.setColor(((Component)this).getBackground());
        graphics.drawString(signature, n7, n8);
    }

    public String getMailAddress() {
        return this.properties.getProperty("mailaddress");
    }

    public Authentication getAuthentication(String string, String string2) {
        AuthenticateDialog authenticateDialog = new AuthenticateDialog((Frame)this, string, string2);
        Dimension dimension = authenticateDialog.getSize();
        Dimension dimension2 = this.getSize();
        Point point = this.getLocation();
        ((Component)authenticateDialog).setLocation(point.x + (dimension2.width - dimension.width) / 2, point.y + (dimension2.height - dimension.height) / 2);
        ((Component)authenticateDialog).setVisible(true);
        authenticateDialog.authentication();
        return authenticateDialog.authentication();
    }

    public void setStatus(String string) {
        this.statusField.setText(string);
    }

    public void setSecurity() {
        if (this.securityPanel == null) {
            this.securityPanel = new SecurityDialog(this);
        }
        ((Component)this.securityPanel).setVisible(true);
        this.securityPanel.requestFocus();
    }

    public String getCodepage() {
        if (this.documentCodepage == null) {
            this.documentCodepage = System.getProperty("file.encoding");
        }
        return this.documentCodepage;
    }

    public void setCodepage(String string) {
        this.documentCodepage = string;
    }

    public void setCodepage(UserClient userClient) {
        CodepageDialog codepageDialog = new CodepageDialog((Frame)this, userClient);
        ((Component)codepageDialog).setVisible(true);
        codepageDialog.requestFocus();
    }

    public CacheManager getCacheManager() {
        return this.cacheManager;
    }

    public UserClient getUserClient() {
        return this;
    }

    public void setTitle(String string) {
        super.setTitle(string);
    }

    public void setCursor(Cursor cursor) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public Dimension minimumLayoutSize(Container container) {
        return this.calcSize(this.appControlPanel.getMinimumSize(), this.appComponent.getMinimumSize(), this.statusField.getMinimumSize());
    }

    public Dimension preferredLayoutSize(Container container) {
        return this.calcSize(this.appControlPanel.getPreferredSize(), this.appComponent.getPreferredSize(), this.statusField.getPreferredSize());
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Dimension dimension2;
        Insets insets = container.getInsets();
        Dimension dimension3 = container.getSize();
        int n = insets.top;
        int n2 = dimension3.height - insets.bottom;
        int n3 = insets.left;
        int n4 = dimension3.width - insets.right - n3;
        if (this.appControlPanel != null) {
            dimension2 = this.appControlPanel.getPreferredSize();
            this.appControlPanel.setBounds(n3, n, n4, dimension2.height);
        } else {
            dimension2 = new Dimension(0, 0);
        }
        if (this.statusField != null) {
            dimension = this.statusField.getPreferredSize();
            this.statusField.setBounds(n3, n2 - dimension.height, n4, dimension.height);
        } else {
            dimension = new Dimension(0, 0);
        }
        if (this.appComponent != null) {
            this.appComponent.setBounds(n3, n + dimension2.height + 4, n4, n2 - n - dimension2.height - dimension.height - 8);
        }
    }

    private final Dimension calcSize(Dimension dimension, Dimension dimension2, Dimension dimension3) {
        Insets insets = this.getInsets();
        return new Dimension(insets.left + dimension2.width + insets.right, insets.top + dimension.height + 4 + dimension2.height + 4 + dimension3.height + insets.bottom);
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.validate();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exit();
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void implementActions(String string) {
        if (string.equals("Close")) {
            this.exit();
            return;
        }
        int n = 0;
        while (n < sAppMenus.length) {
            if (string.equals(sAppMenus[n])) {
                if (this.apps[n] == null) {
                    this.launch(sAppClassNames[n], null);
                } else {
                    this.setNdApp(this.apps[n], null);
                }
            }
            ++n;
        }
    }

    public static void main(String[] stringArray) {
        FlatTop flatTop = new FlatTop();
        ((Component)flatTop).setSize(600, 700);
        ((Component)flatTop).setVisible(true);
        flatTop.setNdApp(null, null);
        if (stringArray != null) {
            if (stringArray.length > 1) {
                String[] stringArray2 = new String[stringArray.length - 1];
                System.arraycopy(stringArray, 1, stringArray2, 0, stringArray.length - 1);
                flatTop.launch(stringArray[0], stringArray2);
                return;
            }
            if (stringArray.length > 0) {
                flatTop.launch(stringArray[0], null);
            }
        }
    }
}

