/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser.item;

import COM.ibm.netdiver.browser.BrowserHolder;
import COM.ibm.netdiver.browser.item.AnchorElement;
import COM.ibm.netdiver.browser.item.Clickable;
import COM.ibm.netdiver.browser.tag.lib.AnchorContext;
import COM.ibm.netdiver.gui.ColoredTextStyle;
import COM.ibm.netdiver.gui.DrawingContext;
import COM.ibm.netdiver.gui.Item;
import COM.ibm.netdiver.gui.ItemPane;
import COM.ibm.netdiver.gui.LayoutClient;
import COM.ibm.netdiver.gui.LayoutException;
import COM.ibm.netdiver.gui.TextStyle;
import COM.ibm.netdiver.gui.TrackerClient;
import COM.ibm.netdiver.gui.WebBrowserWindow;
import COM.ibm.netdiver.gui.item.GraphicItem;
import COM.ibm.netdiver.gui.item.ShiftedImageItem;
import COM.ibm.netdiver.gui.item.TextItem;
import COM.ibm.netdiver.gui.item.TrackerItem;
import COM.ibm.netdiver.net.MalformedURIException;
import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.util.Vector;
import java.awt.Color;
import java.awt.Point;
import java.util.Enumeration;
import java.util.Hashtable;

public class AnchorItem
extends TrackerItem
implements LayoutClient {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Vector anchorElements;
    private WebBrowserWindow browser;
    private AnchorContext context;
    private String href;
    private String title;
    private Color previous;
    private String visitkey;
    private String target;
    private static Hashtable visited = new Hashtable();
    private Point mousePoint;
    private Point mousePointOnHit;
    private boolean yet = true;
    private Clickable clickable;

    public AnchorItem(WebBrowserWindow webBrowserWindow, AnchorContext anchorContext, String string, String string2) {
        this.browser = webBrowserWindow;
        this.context = anchorContext;
        this.href = string;
        this.title = string2;
        this.target = null;
        if (string != null) {
            URI uRI = null;
            try {
                uRI = new URI(string);
                if (uRI.getAbsPath() == null && uRI.getPath() == null) {
                    if (uRI.getFragment() != null) {
                        this.visitkey = uRI.getFragment();
                    }
                } else {
                    uRI = URI.getComposed(webBrowserWindow.getDocumentBase(), uRI);
                    this.visitkey = uRI.toExternalForm();
                }
            }
            catch (MalformedURIException malformedURIException) {}
        }
        this.previous = this.getAnchorColor();
    }

    public AnchorItem(WebBrowserWindow webBrowserWindow, AnchorContext anchorContext, String string, String string2, String string3) {
        this(webBrowserWindow, anchorContext, string, string2);
        this.target = string3;
    }

    public AnchorContext context() {
        return this.context;
    }

    public String title() {
        return this.title;
    }

    public void showAction(int n, ItemPane itemPane) {
        Enumeration enumeration = this.anchorElements.elements();
        while (enumeration.hasMoreElements()) {
            AnchorElement anchorElement = (AnchorElement)enumeration.nextElement();
            switch (n) {
                case 2: {
                    anchorElement.draw(itemPane, this.context.activeColor());
                    break;
                }
                case 3: {
                    anchorElement.draw(itemPane, this.previous);
                    break;
                }
            }
        }
        itemPane.drawBuffer();
    }

    public String getTargetHref(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.href);
        switch (n) {
            case 1: {
                if (this.clickable == null) break;
                stringBuffer.append(this.generateQuery(this.clickable.getCoordinates(this.mousePoint)));
                break;
            }
            case 4: {
                if (this.clickable == null) break;
                stringBuffer.append(this.generateQuery(this.clickable.getCoordinates(this.mousePointOnHit)));
                break;
            }
            case 5: {
                if (this.clickable != null) {
                    stringBuffer.append(this.generateQuery(this.clickable.getCoordinates(this.mousePoint)));
                    break;
                }
                return null;
            }
        }
        return stringBuffer.toString();
    }

    private String generateQuery(Point point) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('?');
        stringBuffer.append(Integer.toString(point.x));
        stringBuffer.append(',');
        stringBuffer.append(Integer.toString(point.y));
        return stringBuffer.toString();
    }

    private static Object getVisited(Object object) {
        return visited.get(object);
    }

    private static void putVisited(Object object, Object object2) {
        if (visited.get(object) != null) {
            visited.remove(object);
        }
        visited.put(object, object2);
    }

    private boolean isVisited() {
        if (this.visitkey != null) {
            return AnchorItem.getVisited(this.visitkey) != null;
        }
        return false;
    }

    public Color getAnchorColor() {
        if (this.isVisited()) {
            return this.context.visitedColor();
        }
        return this.context.linkColor();
    }

    public void draw(DrawingContext drawingContext) {
        super.draw(drawingContext);
        this.yet = true;
    }

    public boolean covers(Point point) {
        Enumeration enumeration = this.elements();
        while (enumeration.hasMoreElements()) {
            GraphicItem graphicItem = (GraphicItem)enumeration.nextElement();
            if (!graphicItem.contains(point.x, point.y)) continue;
            this.mousePoint = point;
            if (graphicItem instanceof Clickable) {
                this.clickable = (Clickable)((Object)graphicItem);
                if (this.clickable.isUsemap()) {
                    this.clickable = null;
                    return false;
                }
            }
            return true;
        }
        this.clickable = null;
        return false;
    }

    public synchronized void handle(int n, TrackerClient trackerClient) {
        switch (n) {
            case 1: {
                if (!this.yet) break;
                this.browser.setStatus(this.getTargetHref(1));
                break;
            }
            case 2: {
                if (!this.yet) break;
                this.mousePointOnHit = this.mousePoint;
                break;
            }
            case 4: {
                if (!this.yet) break;
                this.yet = false;
                if (this.context.getHTMLDocument() != null) {
                    this.context.getHTMLDocument().setNextTitle(this.title());
                }
                if (this.visitkey != null) {
                    AnchorItem.putVisited(this.visitkey, this.visitkey);
                }
                if (this.target != null) {
                    BrowserHolder browserHolder = this.browser.holder();
                    WebBrowserWindow webBrowserWindow = browserHolder.getBrowserByName(this.target, this.browser);
                    if (webBrowserWindow == null) {
                        webBrowserWindow = this.browser;
                    }
                    webBrowserWindow.load(this.getTargetHref(4));
                    this.yet = true;
                    this.previous = this.getAnchorColor();
                    n = 3;
                    break;
                }
                this.browser.load(this.getTargetHref(4));
                break;
            }
            case 3: {
                if (!this.yet) break;
                this.browser.setStatus(null);
                this.previous = this.getAnchorColor();
                break;
            }
            case 5: {
                String string;
                if (!this.yet || (string = this.getTargetHref(5)) == null) break;
                this.browser.overrideStatus(string);
                break;
            }
        }
        if (this.browser.client() instanceof ItemPane) {
            this.showAction(n, (ItemPane)((Object)this.browser.client()));
        }
    }

    public void addItem(Item item) throws LayoutException {
        if (this.anchorElements == null) {
            this.anchorElements = new Vector();
        }
        super.addItem(item);
        if (item instanceof TextItem) {
            this.anchorElements.addElement(new AnchorTextItem((TextItem)item, this));
            return;
        }
        if (item instanceof ShiftedImageItem) {
            this.anchorElements.addElement(new AnchorImageItem((ShiftedImageItem)item, this));
        }
    }

    final class AnchorTextItem
    implements AnchorElement {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        TextItem textItem;
        AnchorItem anchorItem;

        AnchorTextItem(TextItem textItem, AnchorItem anchorItem2) {
            AnchorItem.this = AnchorItem.this;
            this.textItem = textItem;
            this.anchorItem = anchorItem2;
            TextStyle textStyle = new TextStyle(textItem.style());
            textStyle.setUnderline(true);
            textItem.setStyle(new ColoredTextStyle(textStyle, anchorItem2.getAnchorColor()));
        }

        public void draw(DrawingContext drawingContext, Color color) {
            ColoredTextStyle coloredTextStyle = (ColoredTextStyle)this.textItem.style();
            coloredTextStyle.setColor(color);
            this.textItem.draw(drawingContext);
            coloredTextStyle.setColor(this.anchorItem.getAnchorColor());
        }
    }

    final class AnchorImageItem
    implements AnchorElement {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private ShiftedImageItem imageItem;
        private AnchorItem anchorItem;

        AnchorImageItem(ShiftedImageItem shiftedImageItem, AnchorItem anchorItem2) {
            AnchorItem.this = AnchorItem.this;
            this.imageItem = shiftedImageItem;
            this.anchorItem = anchorItem2;
            TextStyle textStyle = new TextStyle(shiftedImageItem.style());
            shiftedImageItem.setStyle(new ColoredTextStyle(textStyle, anchorItem2.getAnchorColor()));
        }

        public void draw(DrawingContext drawingContext, Color color) {
            ColoredTextStyle coloredTextStyle = (ColoredTextStyle)this.imageItem.style();
            coloredTextStyle.setColor(color);
            this.imageItem.draw(drawingContext);
            coloredTextStyle.setColor(this.anchorItem.getAnchorColor());
        }
    }
}

