/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser.item;

import COM.ibm.netdiver.browser.tag.lib.TableCellRect;
import COM.ibm.netdiver.gui.DrawingContext;
import COM.ibm.netdiver.gui.GraphicUtil;
import COM.ibm.netdiver.gui.item.GraphicItem;
import java.awt.Color;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;

public class TableItem
extends GraphicItem {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Vector cellrects;
    private int border;
    private Color bgcolor;
    private int cellspacing;

    public TableItem() {
    }

    public TableItem(Vector vector, int n, int n2, int n3, Color color, int n4) {
        super(-1, -1, n, n2);
        this.cellrects = vector;
        this.border = n3;
        this.bgcolor = color;
        this.cellspacing = n4;
    }

    public void setCells(Vector vector, int n, Color color, int n2, int n3) {
        this.cellrects = vector;
        this.border = n;
        this.bgcolor = color;
        this.cellspacing = n2;
    }

    public void draw(DrawingContext drawingContext) {
        try {
            boolean bl = false;
            Graphics graphics = drawingContext.graphics();
            int n = drawingContext.physicalX(this.x);
            int n2 = drawingContext.physicalY(this.y);
            Color color = drawingContext.getBackground();
            if (this.bgcolor == null) {
                this.bgcolor = color;
            }
            if (this.bgcolor != color) {
                graphics.setColor(this.bgcolor);
                graphics.fillRect(n, n2, this.width, this.height);
                bl = true;
            }
            GraphicUtil.fillFrame(graphics, this.bgcolor, n, n2, this.width, this.height, this.border, true);
            Enumeration enumeration = this.cellrects.elements();
            while (enumeration.hasMoreElements()) {
                TableCellRect tableCellRect = (TableCellRect)enumeration.nextElement();
                Vector vector = tableCellRect.tableColors();
                Color[] colorArray = new Color[4];
                int n3 = 0;
                while (n3 < 4) {
                    colorArray[n3] = (Color)vector.elementAt(n3);
                    ++n3;
                }
                int n4 = n + tableCellRect.location().x;
                int n5 = n2 + tableCellRect.location().y;
                int n6 = tableCellRect.size().width;
                int n7 = tableCellRect.size().height;
                if (colorArray[0] != null && colorArray[0] != this.bgcolor) {
                    graphics.setColor(colorArray[0]);
                    graphics.fillRect(n4, n5, n6, n7);
                    this.redrawItems(drawingContext, tableCellRect.graphicItems());
                } else if (bl) {
                    this.redrawItems(drawingContext, tableCellRect.graphicItems());
                }
                if (this.border <= 0) continue;
                int n8 = (this.cellspacing + 1) / 2;
                if (colorArray[1] == null) {
                    colorArray[1] = this.bgcolor;
                    n8 = 0;
                }
                GraphicUtil.draw3DInnerBorder(graphics, colorArray[1], colorArray[2], colorArray[3], n4, n5, n6, n7, n8);
            }
            if (color != null) {
                graphics.setColor(color);
                return;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    private void redrawItems(DrawingContext drawingContext, Vector vector) {
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (!(e instanceof GraphicItem)) continue;
                GraphicItem graphicItem = (GraphicItem)e;
                graphicItem.draw(drawingContext);
            }
        }
    }
}

