/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.browser.tag.lib;

import COM.ibm.netdiver.browser.HTMLParser;
import COM.ibm.netdiver.browser.tag.lib.FontStyleTag;
import COM.ibm.netdiver.browser.tag.lib.TableContext;
import COM.ibm.netdiver.gui.Arrangement;
import COM.ibm.netdiver.gui.GraphicUtil;
import COM.ibm.netdiver.gui.Layout;
import COM.ibm.netdiver.gui.LayoutException;
import COM.ibm.netdiver.gui.item.HAlignedItemList;
import java.awt.Color;

public abstract class TableCellTag
extends FontStyleTag {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private int rowspan;
    private int colspan;
    private boolean nowrap;
    private int align;
    private int valign;
    private int width;
    private int percentage;
    private Color bgcolor;
    private Color borderclr;
    private Color borderclrLight;
    private Color borderclrDark;
    private Arrangement prev;

    public void openContextFor(HTMLParser hTMLParser) {
        this.rowspan = this.getIntegerAttribute((byte)48, 1);
        this.colspan = this.getIntegerAttribute((byte)20, 1);
        this.nowrap = this.getAttribute((byte)42) != null;
        this.align = this.getAlignAttribute((byte)2, 0);
        this.valign = this.getAlignAttribute((byte)62, 0);
        String string = this.getAttribute((byte)7);
        if (string != null) {
            this.bgcolor = GraphicUtil.makeColor(string);
        }
        if ((string = this.getAttribute((byte)9)) != null) {
            this.borderclr = GraphicUtil.makeColor(string);
        }
        if ((string = this.getAttribute((byte)11)) != null) {
            this.borderclrLight = GraphicUtil.makeColor(string);
        }
        if ((string = this.getAttribute((byte)10)) != null) {
            this.borderclrDark = GraphicUtil.makeColor(string);
        }
        String string2 = this.getAttribute((byte)67);
        this.percentage = -1;
        this.width = -1;
        if (string2 != null) {
            try {
                if (string2.endsWith("%")) {
                    string2 = string2.substring(0, string2.lastIndexOf(37));
                    this.percentage = Integer.parseInt(string2, 10);
                    return;
                }
                this.width = Integer.parseInt(string2, 10);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                return;
            }
        }
    }

    public void layout(Layout layout) throws LayoutException {
        if (layout.getContext(TableContext.ID) != null) {
            return;
        }
        super.layout(layout);
    }

    public void layoutOn(Layout layout) throws LayoutException {
        super.layoutOn(layout);
        layout.newLine();
        this.prev = layout.getArrangement("Horizontal");
        if (this.align != 0) {
            layout.setArrangement("Horizontal", new HAlignedItemList(this.align(), layout));
        }
    }

    public void layoutClose(Layout layout) throws LayoutException {
        layout.newLine();
        layout.setArrangement("Horizontal", this.prev);
        super.layoutClose(layout);
    }

    public int rowspan() {
        return this.rowspan;
    }

    public int colspan() {
        return this.colspan;
    }

    public boolean nowrap() {
        return this.nowrap;
    }

    public int align() {
        return this.align;
    }

    public int valign() {
        return this.valign;
    }

    public int width() {
        return this.width;
    }

    public int width(int n) {
        if (this.percentage > 0) {
            this.width = n * this.percentage / 100;
        }
        return this.width;
    }

    public Color bgcolor() {
        return this.bgcolor;
    }

    public Color borderclr() {
        return this.borderclr;
    }

    public Color borderclrLight() {
        return this.borderclrLight;
    }

    public Color borderclrDark() {
        return this.borderclrDark;
    }

    public void setAlign(int n) {
        this.align = n;
    }

    public void setVAlign(int n) {
        this.valign = n;
    }
}

