/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gml;

import COM.ibm.netdiver.gml.GMLDef;
import COM.ibm.netdiver.gml.NotSupportedTagException;
import COM.ibm.netdiver.gml.SGMLElementFactory;
import COM.ibm.netdiver.gml.SGMLEntities;
import COM.ibm.netdiver.gml.SGMLTag;
import COM.ibm.netdiver.util.AssocList;
import COM.ibm.netdiver.util.Char;
import COM.ibm.netdiver.util.CharBuffer;
import COM.ibm.netdiver.util.Debug;
import COM.ibm.netdiver.util.IntStack;
import java.util.Stack;

public class SGMLParser {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private static final boolean conf_strict = false;
    private static final int NUM_TABSPACE = 4;
    static final int ST_NOTDEF = 0;
    static final int ST_TEXT = 1;
    static final int ST_CR = 2;
    static final int ST_LF = 3;
    static final int ST_TAG = 4;
    static final int ST_COMMENT = 5;
    static final int ST_TERMINATED = 6;
    static final int ST_LOADTEXT = 11;
    static final int ST_AMP_START = 7;
    static final int ST_AMP_NUMERIC = 8;
    static final int ST_AMP_NAME = 10;
    static final int ST_AMP_END = 12;
    private static final String emptyAttributeValue = "";
    protected CharBuffer buf = new CharBuffer();
    protected boolean isPlainText = false;
    protected boolean preformatted = false;
    protected int numLFinPRE;
    private boolean sawBlank = true;
    private Stack context = new Stack();
    private IntStack state = new IntStack(10, 0);
    private StringBuffer amp_buf = new StringBuffer();
    private int linenumber = 1;
    private int amp_value;
    private SGMLEntities entities;
    private SGMLElementFactory elementFactory;
    private GMLDef tagContext;
    private boolean html_comment = false;

    public SGMLParser() {
    }

    public SGMLParser(GMLDef gMLDef, SGMLElementFactory sGMLElementFactory, SGMLTag sGMLTag) {
        this.tagContext = gMLDef;
        this.elementFactory = sGMLElementFactory;
        this.pushContext(sGMLTag);
    }

    public SGMLParser(SGMLElementFactory sGMLElementFactory, SGMLTag sGMLTag) {
        this(null, sGMLElementFactory, sGMLTag);
    }

    public final void setElementFactory(SGMLElementFactory sGMLElementFactory) {
        this.elementFactory = sGMLElementFactory;
    }

    public final int getState() {
        return this.state.peek();
    }

    public final void setPreformatted(boolean bl) {
        this.preformatted = bl;
        if (bl) {
            this.sawBlank = false;
            this.numLFinPRE = 0;
        }
    }

    public final void setPlainText(boolean bl) {
        this.setPreformatted(bl);
        this.isPlainText = bl;
    }

    public final void pushContext(SGMLTag sGMLTag) {
        sGMLTag.setPreformatted(this.preformatted);
        this.context.push(sGMLTag);
    }

    public final SGMLTag popContext() {
        SGMLTag sGMLTag = (SGMLTag)this.context.pop();
        this.preformatted = sGMLTag.getPreformatted();
        return sGMLTag;
    }

    public final SGMLTag getContext() {
        return (SGMLTag)this.context.peek();
    }

    public final int parse(char[] cArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.parse(cArray[n + n3]);
            ++n3;
        }
        return this.state.peek();
    }

    public final int parse(String string) {
        int n = 0;
        while (n < string.length()) {
            this.parse(string.charAt(n));
            ++n;
        }
        return this.state.peek();
    }

    public final int parse(int n, char c) {
        this.state.push(n);
        return this.parse(c);
    }

    public final int parse(char c) {
        block0 : switch (this.state.peek()) {
            case 1: {
                switch (c) {
                    case '<': {
                        if (this.isPlainText) break block0;
                        this.loadText();
                        return this.state.push(4);
                    }
                    case '&': {
                        if (this.isPlainText) break block0;
                        return this.state.push(7);
                    }
                    case '\r': {
                        if (this.sawBlank) {
                            return this.state.peek();
                        }
                        return this.state.push(2);
                    }
                    case '\n': {
                        if (this.sawBlank) {
                            return this.state.peek();
                        }
                        return this.parse(3, c);
                    }
                    case '\t': 
                    case ' ': {
                        if (this.sawBlank) {
                            return this.state.peek();
                        }
                        if (!this.preformatted) {
                            this.sawBlank = true;
                        }
                        c = (char)32;
                        break;
                    }
                    case '\u0000': {
                        return this.state.peek();
                    }
                    case '\uffff': {
                        this.loadText();
                        return this.state.push(6);
                    }
                    default: {
                        this.sawBlank = false;
                        break;
                    }
                }
                break;
            }
            case 2: {
                this.state.pop();
                if (c != '\n') break;
                return this.parse(3, c);
            }
            case 3: {
                this.state.pop();
                if (this.preformatted) {
                    if (this.numLFinPRE > 0 || this.buf.count() > 0) {
                        this.buf.append('\n');
                    }
                    ++this.numLFinPRE;
                    this.loadText();
                    return this.state.peek();
                }
                if (this.sawBlank) {
                    return this.state.peek();
                }
                this.sawBlank = true;
                c = (char)32;
                break;
            }
            case 4: {
                if (c != '>') break;
                this.loadTag();
                if (this.html_comment) break;
                this.buf.release();
                return this.state.pop();
            }
            case 0: {
                return this.parse(1, c);
            }
            case 6: {
                return 6;
            }
            case 7: {
                this.amp_value = 0;
                if (c == '#') {
                    return this.state.push(8);
                }
                if (Char.isalpha(c)) {
                    this.amp_buf.setLength(0);
                    return this.parse(10, c);
                }
                this.buf.append('&');
                this.state.purge(7);
                return this.parse(c);
            }
            case 8: {
                if (Char.isdigit(c)) {
                    this.amp_value = this.amp_value * 10 + (c - 48);
                    return this.state.peek();
                }
                if (this.amp_value > 0) {
                    this.buf.append((char)this.amp_value);
                }
                return this.parse(12, c);
            }
            case 10: {
                if (Char.isalnum(c)) {
                    this.amp_buf.append(c);
                    char c2 = this.amp_find(this.amp_buf.toString());
                    this.amp_value = c2;
                    if (c2 > '\u0000') {
                        this.buf.append((char)this.amp_value);
                        this.state.push(12);
                    }
                    return this.state.peek();
                }
                char c3 = this.amp_find(this.amp_buf.toString());
                this.amp_value = c3;
                if (c3 > '\u0000') {
                    this.buf.append((char)this.amp_value);
                }
                return this.parse(12, c);
            }
            case 12: {
                this.state.purge(7);
                if (c != ';') {
                    return this.parse(c);
                }
                return this.state.peek();
            }
            default: {
                return 6;
            }
        }
        this.buf.append(c);
        return this.state.peek();
    }

    private final void loadText() {
        if (this.buf.count() > 0) {
            ((SGMLTag)this.context.peek()).addElement(this.elementFactory.createText(this.buf));
            this.buf.release();
        }
    }

    private final void loadTag() throws ArrayIndexOutOfBoundsException {
        Object object;
        int n = 0;
        char[] cArray = this.buf.getBuffer();
        boolean bl = false;
        SGMLTag sGMLTag = null;
        switch (cArray[n]) {
            case '/': {
                n = Char.skip_space(cArray, n + 1);
                bl = true;
                break;
            }
            case '!': {
                int n2 = cArray.length;
                if (n2 >= 3 && cArray[n + 1] == '-' && cArray[n + 2] == '-') {
                    if (n2 >= 5 && cArray[n2 - 1] == '-' && cArray[n2 - 2] == '-' || n2 >= 6 && cArray[n2 - 1] == '!' && cArray[n2 - 2] == '-' && cArray[n2 - 3] == '-') {
                        this.html_comment = false;
                        return;
                    }
                    this.html_comment = true;
                }
                return;
            }
        }
        int n3 = n;
        n = Char.skip_alnum(cArray, n);
        String string = new String(cArray, n3, n - n3);
        if (bl) {
            SGMLTag sGMLTag2;
            if (this.context.empty()) {
                return;
            }
            try {
                sGMLTag2 = this.elementFactory.createTag(string);
            }
            catch (NotSupportedTagException notSupportedTagException) {
                Debug.println(this, 2, (Object)notSupportedTagException);
                return;
            }
            if (this.context.search(sGMLTag2) < 0) {
                Debug.println(this, 1, (Object)("SGMLParser: purge not found ! " + string.toString()));
                return;
            }
            do {
                sGMLTag = this.popContext();
                sGMLTag.setClosureCompleted();
                sGMLTag.closeContextFor(this);
            } while (!sGMLTag.equals(sGMLTag2));
            return;
        }
        n = Char.skip_punct(cArray, n);
        try {
            sGMLTag = this.elementFactory.createTag(string);
            n = Char.skip_space(cArray, n);
            if (n < cArray.length && (object = this.getAttributes(cArray, n)) != null) {
                sGMLTag.setAttributes((AssocList)object);
            }
        }
        catch (NotSupportedTagException notSupportedTagException) {
            Debug.println(this, 2, (Object)("Tag \"" + notSupportedTagException.getMessage() + "\" is not supported ...ignored"));
            return;
        }
        object = (SGMLTag)this.context.peek();
        if (((SGMLTag)object).isClosure() && ((SGMLTag)object).isOptional()) {
            while (this.context.size() > 1) {
                if (this.tagContext.contents((SGMLTag)object, sGMLTag)) break;
                ((SGMLTag)object).setClosureCompleted();
                ((SGMLTag)object).closeContextFor(this);
                this.popContext();
                object = (SGMLTag)this.context.peek();
            }
        }
        sGMLTag.openContextFor(this);
        ((SGMLTag)this.context.peek()).addElement(sGMLTag);
        if (sGMLTag.isClosure()) {
            this.pushContext(sGMLTag);
        }
    }

    private final void closeClosures(SGMLTag sGMLTag) {
        SGMLTag sGMLTag2;
        do {
            sGMLTag2 = (SGMLTag)this.context.pop();
            sGMLTag2.setClosureCompleted();
            sGMLTag2.closeContextFor(this);
        } while (!sGMLTag2.equals(sGMLTag));
    }

    /*
     * Unable to fully structure code
     */
    private final AssocList getAttributes(char[] var1_1, int var2_2) {
        var3_3 = null;
        while (var2_2 < var1_1.length && var1_1[var2_2] != '\u0000') {
            block6: {
                block7: {
                    var4_4 = var2_2;
                    if ((var2_2 = Char.skip_alnum(var1_1, var4_4)) == var4_4) break;
                    var5_5 = new String(var1_1, var4_4, var2_2 - var4_4).toLowerCase();
                    var6_6 = "";
                    if ((var2_2 = Char.skip_space(var1_1, var2_2)) >= var1_1.length || var1_1[var2_2] != '=') break block6;
                    var2_2 = Char.skip_space(var1_1, var2_2 + 1);
                    var7_7 = '\u0000';
                    if (var1_1[var2_2] == '\'' || var1_1[var2_2] == '\"') {
                        var7_7 = var1_1[var2_2++];
                    }
                    var4_4 = var2_2;
                    if (var7_7 == '\u0000') ** GOTO lbl19
                    while (var2_2 < var1_1.length && var1_1[var2_2] != var7_7) {
                        ++var2_2;
                    }
                    break block7;
lbl-1000:
                    // 1 sources

                    {
                        ++var2_2;
lbl19:
                        // 2 sources

                        ** while (var2_2 < var1_1.length && !Char.isspace((int)var1_1[var2_2]))
                    }
                }
                var6_6 = new String(var1_1, var4_4, var2_2 - var4_4);
                if (var7_7 != '\u0000') {
                    ++var2_2;
                }
            }
            if (var3_3 == null) {
                var3_3 = this.elementFactory.createTagAttributes();
            }
            var3_3.put(var5_5, var6_6);
            var2_2 = Char.skip_space(var1_1, var2_2);
        }
        return var3_3;
    }

    private final int skip_noalnum(char[] cArray, int n) {
        while (!Char.isalnum(cArray[n])) {
            ++n;
        }
        return n;
    }

    private final char amp_find(String string) {
        if (this.entities == null) {
            this.entities = new SGMLEntities();
        }
        return this.entities.get(string);
    }
}

