/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import COM.ibm.netdiver.gui.GraphicUtil;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;

public class Canvas3D
extends Canvas {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private String text;
    private FontMetrics fm;
    private Color bright;
    private Color dark;
    private Color background;
    private int indent;
    private int thick;
    private boolean overturn;

    public Canvas3D() {
        this.setDefault();
    }

    public void paint(Graphics graphics) {
        if (this.isValid()) {
            graphics.setColor(this.background);
            graphics.fillRect(this.thick, this.thick, this.getSize().width - this.thick * 2, this.getSize().height - this.thick * 2);
            if (this.overturn) {
                GraphicUtil.fillFrame(graphics, this.background, 0, 0, this.getSize().width, this.getSize().height, this.thick, true);
            } else {
                GraphicUtil.fillDentFrame(graphics, this.background, 0, 0, this.getSize().width, this.getSize().height, this.thick, true);
            }
            if (this.text != null) {
                graphics.setFont(this.fm.getFont());
                graphics.setColor(this.overturn ? this.bright : this.dark);
                graphics.drawString(this.text, this.indent + 1, this.fm.getHeight() + 1);
                graphics.setColor(this.overturn ? this.dark : this.bright);
                graphics.drawString(this.text, this.indent, this.fm.getHeight());
            }
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getSize().width, this.fm.getHeight() + this.fm.getMaxDescent() * 2);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.getSize().width, this.fm.getHeight() + this.fm.getMaxDescent() * 2);
    }

    public void setDefault() {
        this.fm = this.getFontMetrics(new Font("Serif", 0, 15));
        this.text = null;
        this.bright = Color.white;
        this.dark = Color.black;
        this.background = new Color(147, 147, 147);
        this.indent = 10;
        this.thick = 3;
        this.overturn = false;
    }

    public void setBackgroundColor(Color color) {
        this.background = color;
        this.paint(this.getGraphics());
    }

    public void setTextColor(Color color, Color color2) {
        this.bright = color;
        this.dark = color2;
        this.paint(this.getGraphics());
    }

    public void setTextFont(Font font) {
        this.fm = this.getFontMetrics(font);
        this.paint(this.getGraphics());
    }

    public void setText(String string) {
        this.text = string;
        this.paint(this.getGraphics());
    }

    public void setIndent(int n) {
        this.indent = n;
        this.paint(this.getGraphics());
    }

    public void setThick(int n) {
        this.thick = n;
        this.paint(this.getGraphics());
    }

    public void setOverturn(boolean bl) {
        this.overturn = bl;
        this.paint(this.getGraphics());
    }

    public String text() {
        return this.text;
    }

    public FontMetrics fm() {
        return this.fm;
    }

    public int indent() {
        return this.indent;
    }

    public int thick() {
        return this.thick;
    }

    public boolean overturn() {
        return this.overturn;
    }

    public Color bright() {
        return this.bright;
    }

    public Color dark() {
        return this.dark;
    }

    public Color background() {
        return this.background;
    }
}

