/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import COM.ibm.netdiver.gml.SGMLElement;
import COM.ibm.netdiver.gml.SGMLLayout;
import COM.ibm.netdiver.gml.SGMLLayoutException;
import COM.ibm.netdiver.gml.SGMLTag;
import COM.ibm.netdiver.gui.Arrangement;
import COM.ibm.netdiver.gui.DefaultVerticalArrangement;
import COM.ibm.netdiver.gui.Item;
import COM.ibm.netdiver.gui.LayoutChecker;
import COM.ibm.netdiver.gui.LayoutClient;
import COM.ibm.netdiver.gui.LayoutContext;
import COM.ibm.netdiver.gui.LayoutException;
import java.awt.Rectangle;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;

public class Layout
implements SGMLLayout {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private int x;
    private int y;
    private int x0;
    private int y0;
    private int xLimit;
    private int yLimit;
    private int width;
    private boolean nowrap = false;
    private LayoutClient client;
    private Hashtable arrangements = new Hashtable();
    private Stack contextStack = new Stack();

    public Layout() {
    }

    public Layout(LayoutClient layoutClient) {
        this.setClient(layoutClient);
        this.setArrangement("Vertical", new DefaultVerticalArrangement());
        if (layoutClient instanceof LayoutChecker) {
            ((LayoutChecker)layoutClient).setLayouter(this);
        }
    }

    public final int width() {
        return this.width;
    }

    public final int y() {
        return this.y;
    }

    public final int x0() {
        return this.x0;
    }

    public final int xAvailable() {
        return this.xLimit - this.x;
    }

    public final int firstWidth() {
        return this.xLimit - this.x0;
    }

    public final boolean atTopOfLine() {
        return this.x == this.x0;
    }

    public final boolean nowrap() {
        return this.nowrap;
    }

    public final int xLimit() {
        return this.xLimit;
    }

    public final int yLimit() {
        return this.yLimit;
    }

    public final LayoutClient client() {
        return this.client;
    }

    public final Arrangement getArrangement(String string) {
        return (Arrangement)this.arrangements.get(string);
    }

    public final void setNowrap(boolean bl) {
        this.nowrap = bl;
    }

    public final void setXLimit(int n) {
        this.xLimit = n;
    }

    public final void setClient(LayoutClient layoutClient) {
        this.client = layoutClient;
    }

    public final void setArrangement(String string, Arrangement arrangement) {
        if (this.arrangements.get(string) != null) {
            this.arrangements.remove(string);
        }
        if (arrangement != null) {
            this.arrangements.put(string, arrangement);
        }
    }

    public final void addItem(Object object) throws LayoutException {
        this.addItem((Item)object);
    }

    public void addItem(Item item) throws LayoutException {
        int n = item.width();
        if (n > this.xAvailable() && item.x() < 0) {
            if (!this.nowrap) {
                this.newLine();
            }
            if (this.x + n > this.xAvailable()) {
                this.width = Math.max(this.x + n, this.width);
            }
        } else if (n < 0 && this.xAvailable() == 0 && !this.nowrap) {
            this.newLine();
        }
        item.locate(this.x, this.y);
        this.client.addItem(item);
        Enumeration enumeration = this.arrangements.elements();
        while (enumeration.hasMoreElements()) {
            ((Arrangement)enumeration.nextElement()).introduce(item);
        }
        if (n >= 0) {
            this.x = item.x() + n;
        }
        this.width = Math.max(this.x, this.width);
    }

    public synchronized void layout(Object object, Rectangle rectangle) throws LayoutException {
        this.x = this.x0 = rectangle.x;
        this.y = this.y0 = rectangle.y;
        this.xLimit = this.x + rectangle.width;
        this.yLimit = this.y + rectangle.height;
        try {
            if (object instanceof SGMLTag) {
                ((SGMLTag)object).layout(this);
            } else if (object instanceof Enumeration) {
                Enumeration enumeration = (Enumeration)object;
                while (enumeration.hasMoreElements()) {
                    ((SGMLElement)enumeration.nextElement()).layout(this);
                }
            }
            this.newLine();
            return;
        }
        catch (LayoutException layoutException) {
            throw layoutException;
        }
        catch (SGMLLayoutException sGMLLayoutException) {
            throw new LayoutException();
        }
    }

    public LayoutContext getContext(LayoutContext layoutContext) {
        int n = this.contextStack.size();
        int n2 = 0;
        while (n2 < n) {
            LayoutContext layoutContext2 = (LayoutContext)this.contextStack.elementAt(n - 1 - n2);
            if (layoutContext2.covers(layoutContext)) {
                return layoutContext2;
            }
            ++n2;
        }
        return null;
    }

    public void pushContext(LayoutContext layoutContext) {
        this.contextStack.push(layoutContext);
    }

    public void popContext(LayoutContext layoutContext) {
        LayoutContext cfr_ignored_0 = (LayoutContext)this.contextStack.pop();
    }

    public Enumeration getAllContexts() {
        return this.contextStack.elements();
    }

    public void carriageReturn() {
        this.x = this.x0;
    }

    public final void carriageReturn(int n) {
        this.x = this.x0 = n;
    }

    public void newLine() throws LayoutException {
        if (this.x > this.x0) {
            this.crlf();
        }
    }

    public void lineFeed() throws LayoutException {
        int n = this.getArrangement("Vertical").apply(0);
        Hashtable hashtable = (Hashtable)this.arrangements.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            Arrangement arrangement = (Arrangement)enumeration.nextElement();
            arrangement.apply(n);
            arrangement.rewind();
        }
        this.y += n;
    }

    public void crlf() throws LayoutException {
        this.carriageReturn();
        this.lineFeed();
    }
}

