/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import COM.ibm.netdiver.gui.ScrollClient;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;

public class ScrollingPanel
extends Panel
implements LayoutManager,
ComponentListener,
AdjustmentListener {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private ScrollClient client;
    protected Scrollbar vsb = new Scrollbar(1);
    protected Scrollbar hsb = new Scrollbar(0);
    private ScrollbarClerk scrollclerk;
    private int scrolling = 0;
    private boolean resized = false;

    public ScrollingPanel() {
        this.setLayout(this);
        this.add(this.vsb);
        this.add(this.hsb);
        this.addComponentListener(this);
        this.vsb.addAdjustmentListener(this);
        this.hsb.addAdjustmentListener(this);
        this.scrollclerk = new ScrollbarClerk(this);
        Thread thread = new Thread((Runnable)this.scrollclerk, this.scrollclerk.getClass().getName());
        thread.setPriority(4);
        thread.start();
    }

    public void setScrolling(int n) {
        if (this.scrolling == n) {
            return;
        }
        if (n == 2) {
            this.remove(this.vsb);
            this.remove(this.hsb);
        } else if (this.scrolling == 2) {
            this.add(this.vsb);
            this.add(this.hsb);
        }
        this.scrolling = n;
    }

    public synchronized void setClient(ScrollClient scrollClient) {
        if (this.client != scrollClient) {
            if (this.client != null) {
                this.remove((Component)((Object)this.client));
            }
            this.client = scrollClient;
            this.add((Component)((Object)scrollClient));
        }
    }

    public void updateScrollbar() {
        if (this.scrolling == 2) {
            return;
        }
        this.scrollclerk.StartUpdate();
    }

    public ScrollClient client() {
        return this.client;
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public void removeLayoutComponent(Component component) {
    }

    public void layoutContainer(Container container) {
        Thread thread = Thread.currentThread();
        int n = thread.getPriority();
        thread.setPriority(5);
        Insets insets = container.getInsets();
        Dimension dimension = container.getSize();
        if (dimension.width == 0 && dimension.height == 0) {
            thread.setPriority(n);
            return;
        }
        this.scrollclerk.Lock();
        int n2 = insets.top;
        int n3 = dimension.height - insets.bottom;
        int n4 = insets.left;
        int n5 = dimension.width - insets.right;
        boolean bl = false;
        boolean bl2 = false;
        Dimension dimension2 = this.vsb.getPreferredSize();
        Dimension dimension3 = this.hsb.getPreferredSize();
        if (this.scrolling == 2) {
            dimension2 = dimension3 = new Dimension(0, 0);
        }
        Rectangle rectangle = new Rectangle(n4, n2, n5 - n4 - dimension2.width, n3 - n2);
        Dimension dimension4 = this.client.layoutContents(rectangle);
        if (this.scrolling != 2) {
            this.client.setLogicalWidth(this.client.logicalWidth() + dimension2.width);
        }
        if (dimension4.height > rectangle.height + dimension3.height) {
            if (this.scrolling != 2) {
                bl = true;
            }
        } else {
            this.client.resetVerticalPosition();
            if (this.scrolling == 1) {
                bl = true;
            }
        }
        if (dimension4.width > rectangle.width + dimension2.width) {
            if (this.scrolling != 2) {
                bl2 = true;
            } else {
                this.client.resetHorizontalPosition();
                if (this.scrolling == 1) {
                    bl2 = true;
                }
            }
        }
        if (bl2 && !bl && dimension4.height > rectangle.height) {
            bl = true;
        }
        if (!bl2 && bl && dimension4.width > rectangle.width) {
            bl2 = true;
        }
        this.scrollclerk.setValues(1, this.client.logicalY(0), this.client.height(), 0, this.client.logicalHeight());
        this.scrollclerk.setValues(0, this.client.logicalX(0), this.client.width(), 0, this.client.logicalWidth());
        if (bl) {
            if (bl2) {
                this.scrollclerk.setRect(1, n5 - dimension2.width, n2, dimension2.width, rectangle.height - dimension3.height);
                this.scrollclerk.setRect(0, n4, n3 - dimension3.height, rectangle.width, dimension3.height);
                this.scrollclerk.Unlock();
                ((Component)((Object)this.client)).setBounds(n4, n2, rectangle.width, rectangle.height - dimension3.height);
            } else {
                this.scrollclerk.setRect(1, n5 - dimension2.width, n2, dimension2.width, rectangle.height);
                this.scrollclerk.setRect(0, 0, 0, 0, 0);
                this.scrollclerk.Unlock();
                ((Component)((Object)this.client)).setBounds(n4, n2, rectangle.width, rectangle.height);
            }
        } else if (bl2) {
            this.scrollclerk.setRect(1, 0, 0, 0, 0);
            this.scrollclerk.setRect(0, n4, n3 - dimension3.height, rectangle.width + dimension2.width, dimension3.height);
            this.scrollclerk.Unlock();
            ((Component)((Object)this.client)).setBounds(n4, n2, rectangle.width + dimension2.width, rectangle.height - dimension3.height);
        } else {
            this.scrollclerk.setRect(1, 0, 0, 0, 0);
            this.scrollclerk.setRect(0, 0, 0, 0, 0);
            this.scrollclerk.Unlock();
            ((Component)((Object)this.client)).setBounds(n4, n2, rectangle.width + dimension2.width, rectangle.height);
        }
        thread.setPriority(n);
    }

    public Dimension minimumLayoutSize(Container container) {
        if (this.scrolling == 2) {
            return new Dimension(1, 1);
        }
        return this.calcSize(this.vsb.getMinimumSize(), this.hsb.getMinimumSize());
    }

    public Dimension preferredLayoutSize(Container container) {
        if (this.scrolling == 2) {
            return new Dimension(1, 1);
        }
        return this.calcSize(this.vsb.getPreferredSize(), this.hsb.getPreferredSize());
    }

    private Dimension calcSize(Dimension dimension, Dimension dimension2) {
        return new Dimension(dimension.width + dimension2.width, dimension.height + dimension2.height);
    }

    public void validateTree() {
        if (this.resized) {
            this.resized = false;
            super.validateTree();
        }
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.scrollclerk.setRect(1, 0, 0, 0, 0);
        this.scrollclerk.setRect(0, 0, 0, 0, 0);
        this.resized = true;
        this.validate();
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (this.client != null) {
            this.client.handleScrollEvent(adjustmentEvent);
        }
    }

    class ScrollbarClerk
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private ScrollingPanel parent;
        private int valueH;
        private int valueV;
        private int visibleH;
        private int visibleV;
        private int minimumH;
        private int minimumV;
        private int maximumH;
        private int maximumV;
        private int xH;
        private int xV;
        private int yH;
        private int yV;
        private int widthH;
        private int widthV;
        private int heightH;
        private int heightV;
        private int lockcount;
        private boolean terminated;
        private boolean requested;
        private boolean Hresized;
        private boolean Vresized;

        public ScrollbarClerk(ScrollingPanel scrollingPanel2) {
            ScrollingPanel.this = ScrollingPanel.this;
            this.parent = scrollingPanel2;
            this.lockcount = 0;
        }

        public synchronized void setValues(int n, int n2, int n3, int n4, int n5) {
            if (n == 0) {
                this.valueH = n2;
                this.visibleH = n3;
                this.minimumH = n4;
                this.maximumH = n5;
                return;
            }
            this.valueV = n2;
            this.visibleV = n3;
            this.minimumV = n4;
            this.maximumV = n5;
        }

        public synchronized void setRect(int n, int n2, int n3, int n4, int n5) {
            if (n == 0) {
                this.xH = n2;
                this.yH = n3;
                this.widthH = n4;
                this.heightH = n5;
                this.Hresized = true;
                return;
            }
            this.xV = n2;
            this.yV = n3;
            this.widthV = n4;
            this.heightV = n5;
            this.Vresized = true;
        }

        public synchronized void Lock() {
            ++this.lockcount;
            this.requested = true;
        }

        public synchronized void Unlock() {
            if (this.lockcount > 0) {
                --this.lockcount;
            }
            if (this.lockcount > 0) {
                return;
            }
            this.notify();
        }

        public synchronized void StartUpdate() {
            try {
                if (this.lockcount > 0 || ScrollingPanel.this.client == null) {
                    return;
                }
                this.valueH = ScrollingPanel.this.client.logicalX(0);
                this.valueV = ScrollingPanel.this.client.logicalY(0);
                if (this.maximumV == 0) {
                    this.visibleH = ScrollingPanel.this.client.width();
                    this.visibleV = ScrollingPanel.this.client.height();
                    this.maximumH = ScrollingPanel.this.client.logicalWidth();
                    this.maximumV = ScrollingPanel.this.client.logicalHeight();
                    this.minimumV = 0;
                    this.minimumH = 0;
                }
                this.notify();
                return;
            }
            catch (IllegalAccessError illegalAccessError) {
                return;
            }
        }

        public synchronized void run() {
            while (!this.terminated) {
                try {
                    if (!this.requested) {
                        this.wait();
                    }
                    this.requested = false;
                    ScrollingPanel.this.hsb.setValues(this.valueH, this.visibleH, this.minimumH, this.maximumH);
                    ScrollingPanel.this.vsb.setValues(this.valueV, this.visibleV, this.minimumV, this.maximumV);
                    if (this.lockcount == 0) {
                        try {
                            this.valueH = ScrollingPanel.this.client.logicalX(0);
                            this.valueV = ScrollingPanel.this.client.logicalY(0);
                            this.visibleH = ScrollingPanel.this.client.width();
                            this.visibleV = ScrollingPanel.this.client.height();
                            this.maximumH = ScrollingPanel.this.client.logicalWidth();
                            this.maximumV = ScrollingPanel.this.client.logicalHeight();
                            this.minimumV = 0;
                            this.minimumH = 0;
                        }
                        catch (IllegalAccessError illegalAccessError) {}
                    }
                    if (this.Hresized) {
                        this.Hresized = false;
                        if (this.widthH == 0) {
                            ScrollingPanel.this.hsb.setSize(0, 0);
                        } else {
                            ScrollingPanel.this.hsb.setBounds(this.xH, this.yH, this.widthH, this.heightH);
                        }
                    }
                    if (!this.Vresized) continue;
                    this.Vresized = false;
                    if (this.widthV == 0) {
                        ScrollingPanel.this.vsb.setSize(0, 0);
                        continue;
                    }
                    ScrollingPanel.this.vsb.setBounds(this.xV, this.yV, this.widthV, this.heightV);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

