/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui;

import COM.ibm.netdiver.browser.BrowserHolder;
import COM.ibm.netdiver.browser.HTMLDocument;
import COM.ibm.netdiver.browser.HTMLDocumentWindow;
import COM.ibm.netdiver.gui.CacheManager;
import COM.ibm.netdiver.gui.ImagePane;
import COM.ibm.netdiver.gui.ScrollClient;
import COM.ibm.netdiver.gui.ScrollingPanel;
import COM.ibm.netdiver.gui.WWWClient;
import COM.ibm.netdiver.gui.WebContent;
import COM.ibm.netdiver.gui.item.OnLoadApplet;
import COM.ibm.netdiver.mm.archive.ZipHandler;
import COM.ibm.netdiver.mm.image.ImageData;
import COM.ibm.netdiver.net.AppletLoader;
import COM.ibm.netdiver.net.ContentLoader;
import COM.ibm.netdiver.net.MalformedURIException;
import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.net.UserClient;
import COM.ibm.netdiver.util.MessageResourceBundle;
import COM.ibm.netdiver.util.ThreadQueue;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.ComponentEvent;
import java.util.Enumeration;
import java.util.Stack;
import java.util.Vector;

public class WebBrowserWindow
extends ScrollingPanel {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private WWWClient wwwClient;
    private RefreshClark updator;
    protected URI uri;
    protected URI base;
    private Stack statusString;
    private TemporaryPanel tempPanel;
    private ThreadQueue loaderThreadQueue;
    private int numLaunchedLoader;
    private boolean fReload = false;
    private BrowserHolder holder;
    private ZipHandler zhandler;
    private WebBrowserWindow parent;
    private String myname;
    private MessageResourceBundle rb = MessageResourceBundle.getResource("COM.ibm.netdiver.gui.res.WebBrowserWindowMessage");
    private CacheManager cacheManager;
    Object app;

    public WebBrowserWindow(WWWClient wWWClient) {
        this();
        this.wwwClient = wWWClient;
    }

    public WebBrowserWindow(WebBrowserWindow webBrowserWindow) {
        this();
        this.base = webBrowserWindow.getDocumentBase();
        this.wwwClient = webBrowserWindow.wwwClient();
        this.parent = webBrowserWindow;
    }

    public WebBrowserWindow() {
        this.loaderThreadQueue = new ThreadQueue();
        this.statusString = new Stack();
        this.tempPanel = new TemporaryPanel();
        this.tempPanel.setVisible(false);
        this.add(this.tempPanel);
        this.updator = new RefreshClark(this);
        Thread thread = new Thread((Runnable)this.updator, this.updator.getClass().getName());
        thread.setPriority(3);
        thread.start();
    }

    public BrowserHolder holder() {
        if (this.parent != null) {
            return this.parent.holder();
        }
        if (this.holder == null) {
            this.holder = new BrowserHolder(this);
        }
        return this.holder;
    }

    public void setBrowserName(String string) {
        if (string != null) {
            this.myname = string;
            return;
        }
        this.myname = "noname";
    }

    public WebBrowserWindow getChildWindow(String string) {
        return this.holder().getBrowserByName(string, this);
    }

    public void putLog(URI uRI, String string) {
        if (this.parent != null) {
            this.parent.putLog(uRI, string);
        }
    }

    protected synchronized void setContent(Object object, URI uRI) {
        WebContent webContent;
        this.uri = uRI;
        this.statusString.removeAllElements();
        WebContent webContent2 = (WebContent)((Object)this.client());
        if (object instanceof HTMLDocument) {
            webContent = webContent2 instanceof HTMLDocumentWindow ? webContent2 : new HTMLDocumentWindow(this);
            HTMLDocument hTMLDocument = (HTMLDocument)object;
            ((HTMLDocumentWindow)webContent).setLinkFragment(uRI.getFragment());
            this.base = hTMLDocument.getDocumentBase();
            if (this.base == null) {
                this.base = uRI;
            }
            this.holder().setHTMLClient(this, (HTMLDocumentWindow)webContent, hTMLDocument.isFrameContainer());
            if (hTMLDocument.isFrameContainer()) {
                this.setScrolling(2);
            } else if (this == this.holder().browser()) {
                this.setScrolling(0);
            }
        } else if (object instanceof ImageData) {
            webContent = webContent2 instanceof ImagePane ? webContent2 : new ImagePane();
            this.wwwClient.setTitle(this.uri.toExternalForm());
        } else {
            webContent = null;
        }
        if (webContent != null) {
            if (webContent2 != null) {
                webContent2.settle();
            }
            this.setClient((ScrollClient)((Object)webContent));
            webContent.setContent(object);
            this.update();
        }
        if (this.uri != null) {
            this.putLog(this.uri, this.myname);
        }
    }

    public void notifiedUpdateStart() {
    }

    public void notifiedUpdateComplete() {
        if (this.numLaunchedLoader == 0) {
            this.notifiedLoadComplete();
        }
    }

    public void notifiedLoadStart() {
        this.setStatus(this.rb.getFixedString("S_LOADING", "Loading....."));
    }

    public void notifiedLoadComplete() {
        if (this.uri != null) {
            this.setStatus(String.valueOf(this.rb.getFixedString("S_COMPLETE", "Complete: ")) + this.uri.toExternalForm());
        }
    }

    public URI getDocumentBase() {
        return this.base;
    }

    public WWWClient wwwClient() {
        return this.wwwClient;
    }

    public UserClient userClient() {
        return this.wwwClient.getUserClient();
    }

    public CacheManager cacheManager() {
        return this.cacheManager;
    }

    public ZipHandler getZipHandler() {
        return this.zhandler;
    }

    public void setZipHandler(ZipHandler zipHandler) {
        this.zhandler = zipHandler;
    }

    public void setWWWClient(WWWClient wWWClient) {
        this.wwwClient = wWWClient;
        this.cacheManager = wWWClient.getCacheManager();
    }

    public Dimension calcPreferredSize(Component component) {
        component.setVisible(false);
        this.tempPanel.add(component);
        Dimension dimension = component.getPreferredSize();
        this.tempPanel.remove(component);
        return dimension;
    }

    public void setRelatedApp(Object object) {
        this.app = object;
    }

    public Object getRelatedApp() {
        return this.app;
    }

    public void componentResized(ComponentEvent componentEvent) {
        this.numLaunchedLoader = this.numLaunchedLoader > 0 ? this.numLaunchedLoader : 1;
        this.updator.putRequest((WebContent)((Object)this.client()));
    }

    public void validate() {
        if (this.client() instanceof HTMLDocumentWindow) {
            ((HTMLDocumentWindow)this.client()).removeAll();
            ((HTMLDocumentWindow)this.client()).setLinkFragment(null);
        }
        super.validate();
        ((WebContent)((Object)this.client())).refresh();
    }

    public void stop() {
        this.loaderThreadQueue.stop();
        this.numLaunchedLoader = 0;
        this.notifiedLoadComplete();
    }

    public void reload(String string) {
        this.cacheManager = new ReloadCacheManager(this.wwwClient.getCacheManager());
        this.fReload = true;
        this._load(string);
    }

    public void reload() {
        this.cacheManager = new ReloadCacheManager(this.wwwClient.getCacheManager());
        this.fReload = true;
        if (this.uri != null) {
            this._load(this.uri.toExternalForm());
        }
    }

    public void load(String string) {
        this.cacheManager = this.wwwClient.getCacheManager();
        this.fReload = false;
        this._load(string);
    }

    public boolean isReload() {
        return this.fReload;
    }

    private synchronized void _load(String string) {
        this.stop();
        if (string == null) {
            return;
        }
        URI uRI = null;
        try {
            uRI = new URI(string);
        }
        catch (MalformedURIException malformedURIException) {
            this.setStatus("-" + malformedURIException + ": " + string);
            return;
        }
        if (uRI.getAbsPath() == null && uRI.getPath() == null) {
            if (uRI.getFragment() != null && this.client() instanceof HTMLDocumentWindow) {
                ((HTMLDocumentWindow)this.client()).gotoFragment(uRI.getFragment());
                return;
            }
        } else {
            try {
                uRI = URI.getComposed(this.base, uRI);
            }
            catch (MalformedURIException malformedURIException) {
                this.setStatus("-" + malformedURIException + ": " + string);
                return;
            }
            Object object = this.cacheManager().getCache(0, uRI.toExternalForm());
            if (object != null) {
                this.setContent(object, uRI);
                return;
            }
            this.setStatus(this.rb.getFixedString("S_LOADING", "Loading....."));
            this.notifiedLoadStart();
            this.loaderThreadQueue.push(new WebResourceLoader(uRI, this), null, -2);
        }
    }

    public void launchForLoad(String string, WebContent webContent) {
        try {
            this.launchForLoad(new URI(string), webContent);
            return;
        }
        catch (MalformedURIException malformedURIException) {
            this.setStatus("-" + malformedURIException + ": " + string);
            return;
        }
    }

    public void launchForLoad(URI uRI, WebContent webContent) {
        try {
            this.loaderThreadQueue.push(new ResourceLoader(URI.getComposed(this.base, uRI), this, webContent), null, -4);
            ++this.numLaunchedLoader;
            return;
        }
        catch (MalformedURIException malformedURIException) {
            this.setStatus("-" + malformedURIException + ": " + uRI.toExternalForm());
            return;
        }
    }

    public void update() {
        if (this.numLaunchedLoader > 0) {
            --this.numLaunchedLoader;
        }
        this.updator.putRequest((WebContent)((Object)this.client()));
    }

    public void setStatus(String string) {
        String string2 = string;
        if (string != null) {
            this.statusString.push(string2);
        } else if (!this.statusString.empty()) {
            this.statusString.pop();
            if (!this.statusString.empty()) {
                string2 = (String)this.statusString.peek();
            }
        }
        if (string2 != null) {
            this.wwwClient.setStatus(string2);
        }
    }

    public void overrideStatus(String string) {
        if (string != null) {
            this.wwwClient.setStatus(string);
        }
    }

    final class WebResourceLoader
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private URI target;
        private WebBrowserWindow browser;

        WebResourceLoader(URI uRI, WebBrowserWindow webBrowserWindow2) {
            WebBrowserWindow.this = WebBrowserWindow.this;
            this.target = uRI;
            this.browser = webBrowserWindow2;
        }

        public void run() {
            Object object = null;
            ContentLoader contentLoader = new ContentLoader(this.browser.userClient(), this.target);
            URI uRI = contentLoader.getCanonicalURI();
            if (uRI != null && (object = this.browser.cacheManager().getCache(0, uRI.toExternalForm())) == null && (object = contentLoader.getContent()) != null) {
                this.browser.cacheManager().putCache(0, uRI.toExternalForm(), object);
            }
            if (object != null) {
                this.browser.setContent(object, uRI);
                return;
            }
            this.browser.setStatus("-" + WebBrowserWindow.this.rb.getFixedString("S_FAILTOLOAD", "Fail to load: ") + this.target.toExternalForm());
        }
    }

    final class ResourceLoader
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        WebContent client;
        WebBrowserWindow browser;
        URI uri;

        public ResourceLoader(URI uRI, WebBrowserWindow webBrowserWindow2, WebContent webContent) {
            WebBrowserWindow.this = WebBrowserWindow.this;
            this.uri = uRI;
            this.client = webContent;
            this.browser = webBrowserWindow2;
        }

        public void run() {
            ContentLoader contentLoader;
            ZipHandler zipHandler = this.browser.getZipHandler();
            if (this.client instanceof OnLoadApplet) {
                contentLoader = new AppletLoader(this.browser.userClient(), ((OnLoadApplet)this.client).getCodeBase(), this.uri, zipHandler);
                ((AppletLoader)contentLoader).setClassname(((OnLoadApplet)this.client).getClassname());
            } else {
                contentLoader = new ContentLoader(this.browser.userClient(), this.uri);
            }
            this.client.setContent(contentLoader.getContent());
            this.browser.update();
        }
    }

    final class RefreshClark
    implements Runnable {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private Vector clients = new Vector();
        private WebBrowserWindow browser;

        public RefreshClark(WebBrowserWindow webBrowserWindow2) {
            WebBrowserWindow.this = WebBrowserWindow.this;
            this.browser = webBrowserWindow2;
        }

        public synchronized void putRequest(WebContent webContent) {
            this.clients.addElement(webContent);
            this.notify();
        }

        public synchronized void run() {
            while (this.clients != null) {
                try {
                    if (this.clients.size() == 0) {
                        this.wait();
                    }
                    this.browser.notifiedUpdateStart();
                    WebContent webContent = (WebContent)this.clients.elementAt(0);
                    this.clients.removeElementAt(0);
                    if (!this.clients.contains(webContent)) {
                        this.browser.doLayout();
                        webContent.refresh();
                    }
                    this.browser.notifiedUpdateComplete();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    final class TemporaryPanel
    extends Panel {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";

        public void paint(Graphics graphics) {
        }

        public void paintAll(Graphics graphics) {
        }

        public void print(Graphics graphics) {
        }

        public void printAll(Graphics graphics) {
        }

        public void update(Graphics graphics) {
        }

        public void paintComponents(Graphics graphics) {
        }

        public void printComponents(Graphics graphics) {
        }

        public void validate() {
        }

        public void validateTree() {
        }

        public void doLayout() {
        }

        TemporaryPanel() {
            WebBrowserWindow.this = WebBrowserWindow.this;
        }
    }

    final class ReloadCacheManager
    implements CacheManager {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private CacheManager parent;

        public ReloadCacheManager(CacheManager cacheManager) {
            WebBrowserWindow.this = WebBrowserWindow.this;
            this.parent = cacheManager;
        }

        public Object getCache(int n, String string) {
            return null;
        }

        public void putCache(int n, String string, Object object) {
            this.parent.putCache(n, string, object);
        }

        public void setCapacity(int n, int n2) {
            this.parent.setCapacity(n, n2);
        }

        public Enumeration elements(int n) {
            return this.parent.elements(n);
        }

        public void clear(int n) {
            this.parent.clear(n);
        }
    }
}

