/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.gui.item;

import COM.ibm.netdiver.gui.ColoredTextStyle;
import COM.ibm.netdiver.gui.DrawingContext;
import COM.ibm.netdiver.gui.TextStyle;
import COM.ibm.netdiver.gui.item.ImageItem;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.image.ImageObserver;

public class ShiftedImageItem
extends ImageItem {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private TextStyle style;
    private int hspace;
    private int vspace;
    private int border;
    private int imageWidth;
    private int imageHeight;

    public ShiftedImageItem(Image image, ImageObserver imageObserver, TextStyle textStyle, int n, int n2, int n3) {
        super(image, imageObserver);
        this.width += (n3 + n) * 2;
        this.height += (n3 + n2) * 2;
        this.style = textStyle;
        this.hspace = n;
        this.vspace = n2;
        this.border = n3;
        if (image != null) {
            this.imageWidth = image.getWidth(imageObserver);
            this.imageHeight = image.getHeight(imageObserver);
        }
    }

    public void draw(DrawingContext drawingContext) {
        try {
            if (this.getImage() != null) {
                Graphics graphics = drawingContext.graphics();
                int n = drawingContext.physicalX(this.x) + this.hspace;
                int n2 = drawingContext.physicalY(this.y) + this.vspace;
                if (this.border > 0) {
                    if (this.style.colored()) {
                        graphics.setColor(((ColoredTextStyle)this.style).color());
                    } else {
                        graphics.setColor(drawingContext.getForeground());
                    }
                    graphics.fillRect(n, n2, this.imageWidth + this.border * 2, this.border);
                    graphics.fillRect(n, n2 + this.border + this.imageHeight, this.imageWidth + this.border * 2, this.border);
                    graphics.fillRect(n, n2, this.border, this.imageHeight + this.border * 2);
                    graphics.fillRect(n + this.border + this.imageWidth, n2, this.border, this.imageHeight + this.border * 2);
                }
                graphics.drawImage(this.getImage(), n + this.border, n2 + this.border, this.getImageObserver());
                return;
            }
        }
        catch (NullPointerException nullPointerException) {}
    }

    public boolean contains(int n, int n2) {
        Rectangle rectangle = new Rectangle(this.x + this.hspace, this.y + this.vspace, this.width - this.hspace * 2, this.height - this.vspace * 2);
        return rectangle.contains(n, n2);
    }

    public int hspace() {
        return this.hspace;
    }

    public int vspace() {
        return this.vspace;
    }

    public int border() {
        return this.border;
    }

    public TextStyle style() {
        return this.style;
    }

    public void setStyle(TextStyle textStyle) {
        this.style = textStyle;
    }
}

