/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.mm.archive;

import COM.ibm.netdiver.mm.ContentHandler;
import COM.ibm.netdiver.mm.ContentHandlerFactory;
import COM.ibm.netdiver.mm.ContentType;
import COM.ibm.netdiver.mm.content.nullImpl;
import COM.ibm.netdiver.net.URI;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;

public class ZipHandler {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private Hashtable ztable = new Hashtable();
    private Vector zpath = new Vector();
    private ContentHandlerFactory factory;
    private boolean copy = false;
    private String dummypath = "c:/temp/dummy";
    private String dummyscheme = "file:///";
    private int dummynum;

    public void setFactory(ContentHandlerFactory contentHandlerFactory) {
        this.factory = contentHandlerFactory;
    }

    public void registerArchive(URI uRI) {
        if (uRI.getScheme().equals("file")) {
            this.registerLocalArchive(uRI);
        } else if (this.copy) {
            this.registerLocalArchive(this.copyArchive(uRI));
        } else {
            this.registerNetArchive(uRI);
        }
        String string = uRI.toExternalForm();
        int n = string.lastIndexOf(47);
        if (n > 0) {
            string = string.substring(0, n);
            this.zpath.addElement(string);
        }
    }

    public void registerLocalArchive(URI uRI) {
        try {
            ZipFile zipFile = new ZipFile(uRI.getPath());
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                if (!(zipEntry instanceof ZipEntry)) continue;
                ZipEntry zipEntry2 = zipEntry;
                FileEntry fileEntry = new FileEntry(uRI, zipEntry2, zipFile);
                this.ztable.put(zipEntry2.getName(), fileEntry);
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void registerNetArchive(URI uRI) {
        try {
            URL uRL = new URL(uRI.toExternalForm());
            ZipInputStream zipInputStream = new ZipInputStream(uRL.openStream());
            int n = 0;
            StreamPosition streamPosition = null;
            ZipEntry zipEntry = zipInputStream.getNextEntry();
            while (zipEntry != null) {
                streamPosition = new StreamPosition(uRI, n, uRL);
                this.ztable.put(zipEntry.getName(), streamPosition);
                ++n;
                zipEntry = zipInputStream.getNextEntry();
            }
            return;
        }
        catch (IOException iOException) {
            return;
        }
    }

    public URI copyArchive(URI uRI) {
        URI uRI2 = null;
        try {
            File file = new File(String.valueOf(this.dummypath) + "." + this.dummynum);
            FileOutputStream fileOutputStream = new FileOutputStream(file);
            URL uRL = new URL(uRI.toExternalForm());
            InputStream inputStream = uRL.openStream();
            int n = inputStream.read();
            while (n != -1) {
                fileOutputStream.write(n);
                n = inputStream.read();
            }
            inputStream.close();
            fileOutputStream.close();
            uRI2 = new URI(String.valueOf(this.dummyscheme) + this.dummypath + "." + this.dummynum);
            ++this.dummynum;
        }
        catch (IOException iOException) {}
        return uRI2;
    }

    public boolean contains(String string) {
        return this.ztable.containsKey(string);
    }

    public URI getArchive(String string) {
        Object v = this.ztable.get(string);
        if (v instanceof StreamPosition) {
            return ((StreamPosition)v).getArchive();
        }
        if (v instanceof FileEntry) {
            return ((FileEntry)v).getArchive();
        }
        return null;
    }

    public boolean isLocal(String string) {
        Object v = this.ztable.get(string);
        return !(v instanceof StreamPosition);
    }

    public synchronized Object getContent(String string) {
        if (string == null) {
            return null;
        }
        Object var2_2 = null;
        try {
            var2_2 = this.ztable.get(string);
            if (var2_2 == null) {
                string = this.cutOffPath(string);
                var2_2 = this.ztable.get(string);
            }
        }
        catch (NullPointerException nullPointerException) {
            System.out.println("NotFound in zip: " + string);
            return null;
        }
        if (var2_2 instanceof StreamPosition || var2_2 instanceof FileEntry) {
            Object object = null;
            ContentType contentType = ContentType.find(string);
            ContentHandler contentHandler = null;
            try {
                InputStream inputStream = this.getInputStream(var2_2);
                if (this.factory != null) {
                    contentHandler = this.factory.createContentHandler(inputStream, contentType);
                }
                if (contentHandler == null || contentHandler instanceof nullImpl) {
                    contentHandler = new ContentHandler(inputStream);
                }
                if (contentHandler != null) {
                    object = contentHandler.getContent();
                }
            }
            catch (IOException iOException) {}
            return object;
        }
        return var2_2;
    }

    private String cutOffPath(String string) {
        String string2 = string;
        int n = 0;
        while (n < this.zpath.size()) {
            String string3;
            Object e = this.zpath.elementAt(n);
            if (e instanceof String && string.startsWith(string3 = (String)e)) {
                string2 = string.substring(string3.length() + 1);
                break;
            }
            ++n;
        }
        return string2;
    }

    private InputStream getInputStream(Object object) {
        if (object instanceof StreamPosition) {
            return ((StreamPosition)object).getInputStream();
        }
        if (object instanceof FileEntry) {
            return ((FileEntry)object).getInputStream();
        }
        return null;
    }

    class FileEntry {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private URI archive;
        private ZipFile zf;
        private ZipEntry ze;

        public FileEntry(URI uRI, ZipEntry zipEntry, ZipFile zipFile) {
            ZipHandler.this = ZipHandler.this;
            this.archive = uRI;
            this.ze = zipEntry;
            this.zf = zipFile;
        }

        public URI getArchive() {
            return this.archive;
        }

        public ZipEntry getZipEntry() {
            return this.ze;
        }

        public ZipFile getZipFile() {
            return this.zf;
        }

        public InputStream getInputStream() {
            try {
                return this.zf.getInputStream(this.ze);
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }

    class StreamPosition {
        String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
        private URI archive;
        private URL url;
        private int order;

        public StreamPosition(URI uRI, int n, URL uRL) {
            ZipHandler.this = ZipHandler.this;
            this.archive = uRI;
            this.order = n;
            this.url = uRL;
        }

        public URI getArchive() {
            return this.archive;
        }

        public int getOrder() {
            return this.order;
        }

        public URL getURL() {
            return this.url;
        }

        public synchronized InputStream getInputStream() {
            try {
                ZipInputStream zipInputStream = new ZipInputStream(this.url.openStream());
                int n = 0;
                while (n <= this.order) {
                    try {
                        zipInputStream.getNextEntry();
                    }
                    catch (ZipException zipException) {
                        System.out.println(zipException);
                        break;
                    }
                    ++n;
                }
                return zipInputStream;
            }
            catch (IOException iOException) {
                return null;
            }
        }
    }
}

