/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.mm.image;

import COM.ibm.netdiver.mm.image.ImageData;
import COM.ibm.netdiver.mm.image.InvalidImageFormatException;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class GifDecoder {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    private BufferedInputStream bis;
    private ImageData data;
    private byte[] gct_red;
    private byte[] gct_green;
    private byte[] gct_blue;
    private int gct_size;
    private int transparentColorIndex;
    static final int TRAILER = 59;
    static final int EXTENSION_INTRODUCER = 33;
    static final int APPLICATION_EXTENSION = 255;
    static final int PLAIN_TEXT_EXTENSION = 1;
    static final int COMMENT_EXTENSION = 254;
    static final int GRAPHIC_CONTROL_EXTENSION = 249;
    static final int IMAGE_DESCRIPTOR = 44;

    public GifDecoder(InputStream inputStream, ImageData imageData) {
        this.bis = inputStream instanceof BufferedInputStream ? (BufferedInputStream)inputStream : new BufferedInputStream(inputStream);
        this.data = imageData;
        this.data.setStatus(0);
    }

    public void decode() throws IOException {
        try {
            int n;
            this.readHeader();
            this.readLogicalScreen();
            this.transparentColorIndex = -1;
            while ((n = this.bis.read()) != -1 && n != 59) {
                if (n == 33) {
                    this.readExtension();
                }
                if (n != 44) continue;
                this.decodeImage();
                this.transparentColorIndex = -1;
            }
            if (this.data.status() == 2) {
                this.data.setStatus(3);
                return;
            }
            this.data.setStatus(-1);
            return;
        }
        catch (InvalidImageFormatException invalidImageFormatException) {
            this.data.setStatus(-1);
            return;
        }
    }

    private void readHeader() throws IOException, InvalidImageFormatException {
        if (this.bis.read() != 71 || this.bis.read() != 73 || this.bis.read() != 70) {
            throw new InvalidImageFormatException();
        }
        this.bis.read();
        this.bis.read();
        this.bis.read();
    }

    private void readLogicalScreen() throws IOException, InvalidImageFormatException {
        this.bis.read();
        this.bis.read();
        this.bis.read();
        this.bis.read();
        int n = this.bis.read();
        if (n == -1) {
            throw new InvalidImageFormatException();
        }
        this.bis.read();
        this.bis.read();
        if ((n & 0x80) != 0) {
            this.gct_size = 1 << (n & 7) + 1;
            this.gct_red = new byte[this.gct_size];
            this.gct_green = new byte[this.gct_size];
            this.gct_blue = new byte[this.gct_size];
            int n2 = 0;
            while (n2 < this.gct_size) {
                this.gct_red[n2] = (byte)this.bis.read();
                this.gct_green[n2] = (byte)this.bis.read();
                this.gct_blue[n2] = (byte)this.bis.read();
                ++n2;
            }
            return;
        }
        this.gct_size = -1;
    }

    /*
     * Unable to fully structure code
     */
    private void readExtension() throws IOException, InvalidImageFormatException {
        var1_1 = this.bis.read();
        if (var1_1 == -1) {
            throw new InvalidImageFormatException();
        }
        switch (var1_1) {
            case 249: {
                var2_2 = this.readSubBlock();
                if (var2_2 == null) break;
                if ((var2_2[0] & 1) != 0) {
                    this.transparentColorIndex = var2_2[3] & 255;
                }
                while (this.readSubBlock() != null) {
                }
                return;
            }
lbl13:
            // 2 sources

            default: {
                if (this.readSubBlock() != null) ** GOTO lbl13
            }
        }
    }

    private byte[] readSubBlock() throws IOException {
        int n = this.bis.read();
        if (n <= 0) {
            return null;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n2 < n) {
            n3 = this.bis.read(byArray, n2, n - n2);
            if (n3 == -1) {
                return null;
            }
            n2 += n3;
        }
        return byArray;
    }

    private void decodeImage() throws IOException, InvalidImageFormatException {
        Object object;
        Object object2;
        int n;
        byte[] byArray;
        byte[] byArray2;
        byte[] byArray3;
        int n2;
        boolean bl = false;
        this.bis.read();
        this.bis.read();
        this.bis.read();
        this.bis.read();
        int n3 = this.bis.read();
        Object object3 = this.bis.read();
        if (n3 == -1 || object3 == -1) {
            throw new InvalidImageFormatException();
        }
        int n4 = n3 | object3 << 8;
        n3 = this.bis.read();
        object3 = this.bis.read();
        if (n3 == -1 || object3 == -1) {
            throw new InvalidImageFormatException();
        }
        int n5 = n3 | object3 << 8;
        this.data.setSize(n4, n5);
        n3 = this.bis.read();
        if (n3 == -1) {
            throw new InvalidImageFormatException();
        }
        if ((n3 & 0x40) != 0) {
            bl = true;
        }
        if ((n3 & 0x80) != 0) {
            n2 = 1 << (n3 & 7) + 1;
            byArray3 = new byte[n2];
            byArray2 = new byte[n2];
            byArray = new byte[n2];
            n = 0;
            while (n < n2) {
                byArray3[n] = (byte)this.bis.read();
                byArray2[n] = (byte)this.bis.read();
                byArray[n] = (byte)this.bis.read();
                ++n;
            }
        } else {
            if (this.gct_size == -1) {
                throw new InvalidImageFormatException();
            }
            n2 = this.gct_size;
            byArray3 = this.gct_red;
            byArray2 = this.gct_green;
            byArray = this.gct_blue;
        }
        n3 = this.bis.read();
        if (n3 == -1) {
            throw new InvalidImageFormatException();
        }
        n = n3;
        int n6 = 1 << n;
        int n7 = n6 + 1;
        int n8 = n6 + 2;
        int n9 = n + 1;
        int n10 = (1 << n9) - 1;
        int n11 = -1;
        int n12 = -1;
        int n13 = -1;
        int n14 = -1;
        int n15 = 4096;
        short[] sArray = new short[n15];
        byte[] byArray4 = new byte[n15];
        byte[] byArray5 = new byte[n15];
        n11 = 0;
        while (n11 < n6) {
            sArray[n11] = 0;
            byArray4[n11] = (byte)n11;
            ++n11;
        }
        int n16 = n4 * n5;
        int[] nArray = new int[n16];
        byte[] byArray6 = null;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        int n20 = 0;
        int n21 = 0;
        while (n21 < n16) {
            if (n18 == 0) {
                if (n19 < n9) {
                    if (n17 == 0) {
                        byArray6 = this.readSubBlock();
                        if (byArray6 == null) break;
                        n17 = byArray6.length;
                    }
                    n20 += (byArray6[byArray6.length - n17] & 0xFF) << n19;
                    n19 += 8;
                    --n17;
                    continue;
                }
                n11 = n20 & n10;
                n20 >>= n9;
                n19 -= n9;
                if (n11 > n8 || n11 == n7) break;
                if (n11 == n6) {
                    n8 = n6 + 2;
                    n9 = n + 1;
                    n10 = (1 << n9) - 1;
                    n12 = -1;
                    continue;
                }
                if (n12 == -1) {
                    byArray5[n18++] = byArray4[n11];
                    n12 = n11;
                    n14 = n11;
                    continue;
                }
                n13 = n11;
                if (n11 == n8) {
                    byArray5[n18++] = (byte)n14;
                    n11 = n12;
                }
                while (n11 > n6) {
                    byArray5[n18++] = byArray4[n11];
                    n11 = sArray[n11] & 0xFFFF;
                }
                n14 = byArray4[n11] & 0xFF;
                if (n8 >= n15) break;
                byArray5[n18++] = (byte)n14;
                sArray[n8] = (short)n12;
                byArray4[n8] = (byte)n14;
                if ((++n8 & n10) == 0 && n8 < n15) {
                    ++n9;
                    n10 += n8;
                }
                n12 = n13;
            }
            nArray[n21] = byArray5[--n18] & 0xFF;
            ++n21;
        }
        while (n21 < n16) {
            nArray[n21] = 0;
            ++n21;
        }
        if (bl) {
            object2 = new int[]{8, 8, 4, 2};
            object = new int[]{0, 4, 2, 1};
            int[] nArray2 = new int[n16];
            object3 = 0;
            n3 = 0;
            int n22 = 0;
            while (n22 < 4) {
                reference var35_36 = object[n22];
                while (var35_36 < n5) {
                    object3 = var35_36 * n4;
                    int n23 = 0;
                    while (n23 < n4) {
                        nArray2[object3 + n23] = nArray[n3];
                        ++n23;
                        ++n3;
                    }
                    var35_36 += object2[n22];
                }
                ++n22;
            }
            nArray = nArray2;
        }
        object2 = new IndexColorModel(8, n2, byArray3, byArray2, byArray, this.transparentColorIndex);
        object = new MemoryImageSource(n4, n5, (ColorModel)object2, nArray, 0, n4);
        this.data.addImage((MemoryImageSource)object);
        this.data.setStatus(2);
    }
}

