/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.net;

import COM.ibm.netdiver.browser.NdSecurityManager;
import COM.ibm.netdiver.mm.ContentHandler;
import COM.ibm.netdiver.mm.ContentHandlerFactory;
import COM.ibm.netdiver.mm.ContentType;
import COM.ibm.netdiver.net.SchemeImpl;
import COM.ibm.netdiver.net.SchemeNotAvailableException;
import COM.ibm.netdiver.net.URI;
import COM.ibm.netdiver.net.UserClient;
import COM.ibm.netdiver.net.scheme.appletImpl;
import COM.ibm.netdiver.util.Package;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;

public final class SchemeHandler {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    SchemeImpl impl;
    String scheme;
    URI uri;
    URI local;
    UserClient userClient;
    boolean othersecurity;
    static ContentHandlerFactory contentHandlerFactory;
    static boolean configProxyInProperty;

    public SchemeHandler(URI uRI) throws IOException {
        this.uri = uRI;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null || securityManager instanceof NdSecurityManager) {
            this.othersecurity = false;
            this.scheme = uRI.getScheme();
            try {
                this.impl = (SchemeImpl)Package.createInstance(this, "scheme", String.valueOf(this.scheme) + "Impl");
                this.impl.initialize(this);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SchemeNotAvailableException(this.scheme);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SchemeNotAvailableException(this.scheme);
            }
            catch (InstantiationException instantiationException) {
                throw new SchemeNotAvailableException(this.scheme);
            }
            if (configProxyInProperty) {
                this.setProxyInProperty("proxy");
                return;
            }
        } else {
            this.othersecurity = true;
            this.scheme = "applet";
            this.impl = new appletImpl(uRI);
            this.impl.initialize(this);
        }
    }

    public SchemeHandler(URI uRI, URI uRI2) throws IOException {
        this(uRI);
        this.impl.setProxy(uRI2);
    }

    public SchemeHandler(URI uRI, Hashtable hashtable) throws IOException {
        this(uRI);
        this.impl.setProxy((URI)hashtable.get(this.scheme));
    }

    public SchemeHandler(URI uRI, String string) throws IOException {
        this(uRI);
        this.setProxyInProperty(string);
    }

    public SchemeHandler(UserClient userClient, URI uRI) throws IOException {
        this(uRI);
        this.userClient = userClient;
    }

    private void setProxyInProperty(String string) throws IOException {
        String string2 = "proxy";
        if (!this.othersecurity) {
            string2 = System.getProperty(String.valueOf(string) + "." + this.scheme);
        }
        if (string2 != null) {
            this.impl.setProxy(new URI(string2));
        }
    }

    public InputStream getInputStream() throws IOException {
        return this.impl.getInputStream();
    }

    public String getScheme() {
        return this.scheme;
    }

    public URI getCanonicalURI() throws IOException {
        return this.impl.getCanonicalURI();
    }

    public ContentHandler getContentHandler() throws IOException {
        if (contentHandlerFactory == null) {
            contentHandlerFactory = new ContentHandlerFactory();
        }
        if (this.userClient != null) {
            return contentHandlerFactory.createContentHandler(this.getInputStream(), this.getContentType(), this.userClient);
        }
        return contentHandlerFactory.createContentHandler(this.getInputStream(), this.getContentType());
    }

    public ContentType getContentType() throws IOException {
        ContentType contentType = this.impl.getContentType();
        return contentType;
    }

    public long getContentLength() throws IOException {
        return this.impl.getContentLength();
    }

    public URI getLocalHost() {
        return this.local;
    }

    public void setStatus(int n) {
    }

    public URI getURI() {
        return this.uri;
    }

    public boolean isHTTP() {
        return this.impl.isHTTP();
    }

    public SchemeImpl getImpl() {
        return this.impl;
    }

    public void redirect(SchemeHandler schemeHandler) {
        this.impl = schemeHandler.getImpl();
    }

    public void close() throws IOException {
        this.impl.close();
    }

    public UserClient userClient() {
        return this.userClient;
    }

    public ContentHandlerFactory getFactory() {
        if (contentHandlerFactory == null) {
            contentHandlerFactory = new ContentHandlerFactory();
        }
        return contentHandlerFactory;
    }

    static {
        configProxyInProperty = true;
    }
}

