/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.net;

import COM.ibm.netdiver.net.MalformedURIException;
import COM.ibm.netdiver.util.Char;
import COM.ibm.netdiver.util.Constant;
import COM.ibm.netdiver.util.Package;
import COM.ibm.netdiver.util.Vector;
import java.io.File;
import java.io.IOException;

public final class URI
implements Constant {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    int pathType;
    String scheme;
    String path;
    String net_loc;
    String abs_path;
    String fragment;
    String query;
    Vector params;
    private String string;
    private int length;
    private String host;
    private int port;
    private static final char sep = File.separatorChar;
    private static final String filescheme = "file";
    private static final byte[] ctype = new byte[128];
    private static final int C_uchar = 1;
    private static final int C_pchar = 3;
    private static final int C_reserved = 4;
    private static final int C_net_loc = 8;
    private static final int C_param = 16;
    private static final int C_scheme = 32;
    public static final int T_net = 1;
    public static final int T_abs = 2;
    public static final int T_rel = 3;

    static boolean is_pchar(char c) {
        return URI.is_unreserved(c) || c == ':' || c == '@' || c == '&' || c == '=' || c == '+';
    }

    static boolean is_unreserved(char c) {
        return Char.isalnum(c) || URI.is_safe(c) || URI.is_extra(c) || URI.is_national(c);
    }

    static boolean is_reserved(char c) {
        return c == ';' || c == '/' || c == '?' || c == ':' || c == '@' || c == '&' || c == '=' || c == '+';
    }

    static boolean is_extra(char c) {
        return c == '!' || c == '*' || c == '\'' || c == '(' || c == ')' || c == ',';
    }

    static boolean is_safe(char c) {
        return c == '$' || c == '-' || c == '_' || c == '.';
    }

    static boolean is_unsafe(char c) {
        return Char.iscntrl(c) || c == ' ' || c == '\"' || c == '#' || c == '%' || c == '<' || c == '>';
    }

    static boolean is_national(char c) {
        return !Char.isalnum(c) && !URI.is_reserved(c) && !URI.is_extra(c) && !URI.is_safe(c) && !URI.is_unsafe(c);
    }

    static String unEscape(String string) throws MalformedURIException {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        int n2 = 0;
        while (n2 < n) {
            if (string.charAt(n2) == '%') {
                if (n2 + 3 <= n && Char.isxdigit(string.charAt(n2 + 1)) && Char.isxdigit(string.charAt(n2 + 2))) {
                    stringBuffer.append((char)Integer.parseInt(string.substring(n2 + 1, n2 + 3), 16));
                    n2 += 3;
                    continue;
                }
                throw new MalformedURIException(string.substring(n2));
            }
            stringBuffer.append(string.charAt(n2));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public URI() {
    }

    public URI(String string) throws MalformedURIException {
        this.string = string;
        this.length = this.string.length();
        try {
            this.parse(0);
            return;
        }
        catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
            throw new MalformedURIException(this.string);
        }
    }

    public URI(URI uRI, URI uRI2) throws MalformedURIException {
        if (!uRI.isAbsolute() || uRI2.pathType == 1) {
            throw new MalformedURIException();
        }
        if (uRI2.isAbsolute()) {
            this.pathType = uRI.pathType;
            this.scheme = uRI.scheme;
            this.net_loc = uRI.net_loc;
        }
        this.fragment = uRI2.fragment;
        this.path = uRI2.path;
        this.params = uRI2.params;
        this.query = uRI2.query;
    }

    protected int parse(int n) throws MalformedURIException {
        int n2;
        int n3 = this.advance(32, n);
        if (n3 > n && n3 < this.length && this.string.charAt(n3) == ':') {
            this.scheme = URI.unEscape(this.string.substring(n, n3));
            int n4 = this.advance(5, n3 + 1);
            if (n4 > n3 + 1) {
                this.abs_path = URI.unEscape(this.string.substring(n3 + 1, n4));
                this.parse(n3 + 1);
                n3 = n4;
            }
        } else if (this.string.charAt(n) == '/') {
            if (this.length > n + 1 && this.string.charAt(n + 1) == '/') {
                this.pathType = 1;
                n3 = this.advance(8, n + 2);
                if (n3 > n + 2) {
                    this.net_loc = this.string.substring(n + 2, n3);
                }
                if (n3 < this.length && this.string.charAt(n3) == '/') {
                    if (n3 + 1 < this.length) {
                        int n5;
                        n3 = n5 = this.parse_rel_path(n3 + 1);
                    }
                    if (this.path != null && this.scheme != null && this.scheme.equals(filescheme) && sep == '/' && !this.path.startsWith("/")) {
                        String string = "/";
                        this.path = string.concat(this.path);
                    }
                }
            } else {
                this.pathType = 2;
                if (this.scheme != null && this.scheme.equals(filescheme)) {
                    if (this.length > n) {
                        n3 = this.parse_rel_path(n);
                    }
                } else if (this.length > n + 1) {
                    n3 = this.parse_rel_path(n + 1);
                }
            }
        } else {
            this.pathType = 3;
            n3 = this.parse_rel_path(n);
        }
        if (n3 + 1 < this.length && this.string.charAt(n3) == '#' && (n2 = this.advance(5, n3 + 1)) > n3 + 1) {
            this.fragment = URI.unEscape(this.string.substring(n3 + 1, n2));
            n3 = n2;
        }
        return n3;
    }

    protected int parse_rel_path(int n) throws MalformedURIException {
        int n2;
        int n3 = n;
        n3 = this.advance(3, n);
        if (n3 > 0) {
            while (n3 < this.length && this.string.charAt(n3) == '/') {
                n3 = this.advance(3, n3 + 1);
            }
            this.path = URI.unEscape(this.string.substring(n, n3));
        }
        if (this.path == null) {
            this.path = "/";
        }
        while (n3 + 1 < this.length && this.string.charAt(n3) == ';') {
            if ((n2 = this.advance(16, ++n3)) > n3) {
                if (this.params == null) {
                    this.params = new Vector();
                }
                this.params.addElement(URI.unEscape(this.string.substring(n3, n2)));
            }
            n3 = n2;
        }
        if (n3 + 1 < this.length && this.string.charAt(n3) == '?' && (n2 = this.advance(5, n3 + 1)) > n3 + 1) {
            this.query = URI.unEscape(this.string.substring(n3 + 1, n2));
            n3 = n2;
        }
        return n3;
    }

    private int ctype(int n) {
        if ((n & 0xFFFFFF80) == 0) {
            return ctype[n];
        }
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int advance(int n, int n2) throws MalformedURIException {
        int n3 = n2;
        while (n3 < this.length) {
            char c = this.string.charAt(n3);
            if ((n & 1) != 0 && c == '%') {
                if (!Char.isxdigit(this.string.charAt(n3 + 1)) || !Char.isxdigit(this.string.charAt(n3 + 2))) throw new MalformedURIException(this.string.substring(n3));
                n3 += 2;
            } else if (c >= '\u0000' && c < '\u0080' && (n & ctype[c]) == 0) return n3;
            ++n3;
        }
        return n3;
    }

    public boolean isAbsolute() {
        return this.scheme != null;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getPath() {
        return this.path;
    }

    public String getAbsPath() {
        return this.abs_path;
    }

    public String getNetLoc() {
        return this.net_loc;
    }

    public String getFragment() {
        return this.fragment;
    }

    public String getQuery() {
        return this.query;
    }

    public Vector getParams() {
        return this.params;
    }

    public int getPathType() {
        return this.pathType;
    }

    public String getHost() {
        if (this.host == null && this.net_loc != null) {
            int n = 0;
            while (n < this.net_loc.length()) {
                if (this.net_loc.charAt(n) == ':') break;
                ++n;
            }
            this.host = this.net_loc.substring(0, n);
            if (n < this.net_loc.length()) {
                this.port = Integer.parseInt(this.net_loc.substring(n + 1));
            }
        }
        return this.host;
    }

    public int getPort() {
        if (this.host == null && this.net_loc != null) {
            this.getHost();
        }
        if (this.port <= 0) {
            this.port = 80;
        }
        return this.port;
    }

    public String toExternalForm() {
        return this.toExternalForm(true);
    }

    public String toExternalForm(boolean bl) {
        return this.toExternalFormInternal(bl, true);
    }

    public String toExternalFormWithoutFragment() {
        return this.toExternalFormWithoutFragment(true);
    }

    public String toExternalFormWithoutFragment(boolean bl) {
        return this.toExternalFormInternal(bl, false);
    }

    private String toExternalFormInternal(boolean bl, boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl) {
            if (this.scheme != null) {
                stringBuffer.append(this.scheme);
                stringBuffer.append(':');
            }
            if (this.pathType == 1) {
                stringBuffer.append("//");
                if (this.net_loc != null) {
                    stringBuffer.append(this.net_loc);
                }
            }
        }
        if (this.pathType != 2) {
            stringBuffer.append('/');
        }
        if (this.path != null) {
            stringBuffer.append(this.path);
        }
        if (this.params != null) {
            stringBuffer.append(URI.toString(this.params));
        }
        if (this.query != null) {
            stringBuffer.append('?');
            stringBuffer.append(this.query);
        }
        if (bl2 && this.fragment != null) {
            stringBuffer.append('#');
            stringBuffer.append(this.fragment);
        }
        return stringBuffer.toString();
    }

    public void print() throws IOException {
        String string;
        System.out.println("is_absolute=" + URI.toString(this.isAbsolute()));
        System.out.println("scheme=" + this.scheme);
        System.out.println("path=" + this.path);
        System.out.println("abs_path=" + this.abs_path);
        System.out.println("net_loc=" + this.net_loc);
        System.out.println("fragment=" + this.fragment);
        System.out.println("params=" + URI.toString(this.params));
        System.out.println("query=" + this.query);
        switch (this.pathType) {
            case 1: {
                string = "net";
                break;
            }
            case 2: {
                string = "abs";
                break;
            }
            case 3: {
                string = "rel";
                break;
            }
            default: {
                string = "?";
            }
        }
        System.out.println("path_type=" + string);
        if (this.pathType == 1) {
            System.out.println("host=" + this.getHost());
            System.out.println("port=" + Integer.toString(this.getPort()));
        }
    }

    static String toString(Vector vector) {
        if (vector == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < vector.size()) {
            stringBuffer.append(";" + (String)vector.elementAt(n));
            ++n;
        }
        return stringBuffer.toString();
    }

    static String toString(boolean bl) {
        if (bl) {
            return "true";
        }
        return "false";
    }

    public int hashCode() {
        if (this.string != null) {
            return this.string.hashCode();
        }
        return super.hashCode();
    }

    public static URI getComposed(URI uRI, URI uRI2) throws MalformedURIException {
        if (uRI == null || uRI2.isAbsolute()) {
            return uRI2;
        }
        if (!uRI.isAbsolute()) {
            throw new MalformedURIException();
        }
        URI uRI3 = new URI();
        uRI3.pathType = uRI.pathType;
        uRI3.scheme = uRI.scheme;
        uRI3.net_loc = uRI.net_loc;
        uRI3.path = uRI2.path;
        uRI3.fragment = uRI2.fragment;
        uRI3.params = uRI2.params;
        uRI3.query = uRI2.query;
        switch (uRI2.pathType) {
            case 1: {
                uRI3.net_loc = uRI2.net_loc;
                break;
            }
            case 3: {
                String string = uRI.path;
                if (string == null) {
                    string = "/";
                }
                uRI3.path = Package.composeFSPath(string, uRI2.path);
            }
        }
        return uRI3;
    }

    static {
        int n = 0;
        while (n < 128) {
            char c = (char)n;
            int n2 = 0;
            if (URI.is_pchar(c)) {
                n2 |= 3;
            }
            if (URI.is_unreserved(c)) {
                n2 |= 1;
            }
            if (URI.is_reserved(c)) {
                n2 |= 4;
            }
            if (Char.isalnum(c) || c == '+' || c == '-' || c == '.') {
                n2 |= 0x20;
            }
            if (URI.is_pchar(c) || c == ';' || c == '?') {
                n2 |= 8;
            }
            if (URI.is_pchar(c) || c == '/') {
                n2 |= 0x10;
            }
            if (c == '%') {
                n2 |= 1;
            }
            URI.ctype[n] = (byte)n2;
            ++n;
        }
    }
}

