/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.net.http;

import java.util.Hashtable;

public final class HeaderField {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    public static final byte _UNKNOWN = -1;
    public static final byte ID_Accept = 0;
    public static final byte ID_Accept_Charset = 1;
    public static final byte ID_Accept_Encoding = 2;
    public static final byte ID_Accept_Language = 3;
    public static final byte ID_Authorization = 4;
    public static final byte ID_From = 5;
    public static final byte ID_Host = 6;
    public static final byte ID_If_Modified_Since = 7;
    public static final byte ID_If_Match = 8;
    public static final byte ID_If_None_Match = 9;
    public static final byte ID_If_Range = 10;
    public static final byte ID_If_Unmodified_Since = 11;
    public static final byte ID_Max_Forwards = 12;
    public static final byte ID_Proxy_Authorization = 13;
    public static final byte ID_Range = 14;
    public static final byte ID_Referer = 15;
    public static final byte ID_User_Agent = 16;
    public static final int _NUM_REQUEST = 17;
    public static final byte ID_Age = 17;
    public static final byte ID_Location = 18;
    public static final byte ID_Proxy_Authenticate = 19;
    public static final byte ID_Public = 20;
    public static final byte ID_Retry_After = 21;
    public static final byte ID_Server = 22;
    public static final byte ID_Vary = 23;
    public static final byte ID_WWW_Authenticate = 24;
    public static final int _NUM_RESPONSE = 8;
    public static final byte ID_Cache_Control = 25;
    public static final byte ID_Connection = 26;
    public static final byte ID_Date = 27;
    public static final byte ID_Pragma = 28;
    public static final byte ID_Transfer_Encoding = 29;
    public static final byte ID_Upgrade = 30;
    public static final byte ID_Via = 31;
    public static final byte ID_URI = 32;
    public static final byte ID_Keep_Alive = 33;
    public static final int _NUM_GENERAL = 9;
    public static final byte ID_Allow = 34;
    public static final byte ID_Content_Base = 35;
    public static final byte ID_Content_Encoding = 36;
    public static final byte ID_Content_Language = 37;
    public static final byte ID_Content_Length = 38;
    public static final byte ID_Content_Location = 39;
    public static final byte ID_Content_MD5 = 40;
    public static final byte ID_Content_Range = 41;
    public static final byte ID_Content_Type = 42;
    public static final byte ID_ETag = 43;
    public static final byte ID_Expires = 44;
    public static final byte ID_Last_Modified = 45;
    public static final byte ID_Content_Version = 46;
    public static final byte ID_Derived_From = 47;
    public static final byte ID_Link = 48;
    public static final int _NUM_ENTITY = 15;
    public static final int NUMBER_OF_DEFINED_FIELDS = 49;
    public static final short C_REQUEST = 1;
    public static final short C_RESPONSE = 2;
    public static final short C_GENERAL = 4;
    public static final short C_ENTITY = 8;
    public static final short A_MULTIPLE = 256;
    public static final short A_HOP_BY_HOP = 512;
    public static final short A_NON_MODIFIABLE = 1024;
    public static final short A_ADDITIONAL = 2048;
    public static final short v09 = 9;
    public static final short v10 = 100;
    public static final short v11 = 101;
    private static final Hashtable assocTable = new Hashtable();
    private static final HeaderField[] idTable = new HeaderField[49];
    private String name;
    private short version;
    private short attribute;
    private byte id;

    public HeaderField() {
    }

    public HeaderField(String string, short s, short s2, byte by) {
        this.name = string;
        this.version = s;
        this.attribute = s2;
        this.id = by;
    }

    public boolean isMultiple() {
        return (this.attribute & 0x100) != 0;
    }

    public String getName() {
        return this.name;
    }

    public int getAttribute() {
        return this.attribute;
    }

    public byte getId() {
        return this.id;
    }

    private static final void intern(String string, short s, int n, byte by) {
        HeaderField headerField = new HeaderField(string, s, (short)n, by);
        assocTable.put(string.toUpperCase(), headerField);
        HeaderField.idTable[headerField.getId()] = headerField;
    }

    public static int getId(String string) {
        return HeaderField.find((String)string).id;
    }

    static HeaderField find(String string) {
        return (HeaderField)assocTable.get(string.toUpperCase());
    }

    static HeaderField find(int n) {
        return idTable[n];
    }

    public static String getName(byte by) {
        if (by > -1 && by < 49) {
            return HeaderField.idTable[by].name;
        }
        return null;
    }

    private static StringBuffer appendAttributeSignature(StringBuffer stringBuffer, String string) {
        if (stringBuffer.length() == 0) {
            stringBuffer.append("(");
        } else {
            stringBuffer.append(" | ");
        }
        return stringBuffer.append(string);
    }

    public static void main(String[] stringArray) {
        int n = 0;
        while (n < 49) {
            HeaderField headerField = idTable[n];
            System.out.println(headerField.toString());
            n = (byte)(n + 1);
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if ((this.attribute & 1) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "C_REQUEST");
        }
        if ((this.attribute & 2) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "C_RESPONSE");
        }
        if ((this.attribute & 4) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "C_GENERAL");
        }
        if ((this.attribute & 8) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "C_ENTITY");
        }
        if ((this.attribute & 0x100) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "A_MULTIPLE");
        }
        if ((this.attribute & 0x200) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "A_HOP_BY_HOP");
        }
        if ((this.attribute & 0x400) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "A_NON_MODIFIABLE");
        }
        if ((this.attribute & 0x800) != 0) {
            HeaderField.appendAttributeSignature(stringBuffer, "A_ADDITIONAL");
        }
        stringBuffer.insert(0, "\"" + this.name + "\", " + (this.version == 101 ? "v11" : "v10") + ", ");
        stringBuffer.append("), ID_" + HeaderField.mkSymbol(this.name));
        return stringBuffer.toString();
    }

    static String mkSymbol(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < string.length()) {
            if (string.charAt(n) == '-') {
                stringBuffer.append('_');
            } else {
                stringBuffer.append(string.charAt(n));
            }
            ++n;
        }
        return stringBuffer.toString();
    }

    static {
        HeaderField.intern("Accept", (short)101, 257, (byte)0);
        HeaderField.intern("Accept-Charset", (short)101, 257, (byte)1);
        HeaderField.intern("Accept-Encoding", (short)101, 257, (byte)2);
        HeaderField.intern("Accept-Language", (short)101, 257, (byte)3);
        HeaderField.intern("Authorization", (short)100, 1, (byte)4);
        HeaderField.intern("From", (short)100, 1, (byte)5);
        HeaderField.intern("Host", (short)101, 1, (byte)6);
        HeaderField.intern("If-Modified-Since", (short)100, 1, (byte)7);
        HeaderField.intern("If-Match", (short)101, 1, (byte)8);
        HeaderField.intern("If-None-Match", (short)101, 1, (byte)9);
        HeaderField.intern("If-Range", (short)101, 1, (byte)10);
        HeaderField.intern("If-Unmodified-Since", (short)101, 1, (byte)11);
        HeaderField.intern("Max-Forwards", (short)101, 1, (byte)12);
        HeaderField.intern("Proxy-Authorization", (short)101, 513, (byte)13);
        HeaderField.intern("Range", (short)101, 1, (byte)14);
        HeaderField.intern("Referer", (short)100, 1, (byte)15);
        HeaderField.intern("User-Agent", (short)100, 1, (byte)16);
        HeaderField.intern("Age", (short)101, 2, (byte)17);
        HeaderField.intern("Location", (short)100, 2, (byte)18);
        HeaderField.intern("Proxy-Authenticate", (short)101, 2, (byte)19);
        HeaderField.intern("Public", (short)101, 770, (byte)20);
        HeaderField.intern("Retry-After", (short)101, 2, (byte)21);
        HeaderField.intern("Server", (short)100, 2, (byte)22);
        HeaderField.intern("Vary", (short)101, 258, (byte)23);
        HeaderField.intern("WWW-Authenticate", (short)100, 258, (byte)24);
        HeaderField.intern("Cache-Control", (short)101, 260, (byte)25);
        HeaderField.intern("Connection", (short)101, 772, (byte)26);
        HeaderField.intern("Date", (short)100, 4, (byte)27);
        HeaderField.intern("Pragma", (short)100, 260, (byte)28);
        HeaderField.intern("Transfer-Encoding", (short)101, 772, (byte)29);
        HeaderField.intern("Upgrade", (short)101, 772, (byte)30);
        HeaderField.intern("Via", (short)101, 260, (byte)31);
        HeaderField.intern("URI", (short)101, 2308, (byte)32);
        HeaderField.intern("Keep-Alive", (short)101, 2820, (byte)33);
        HeaderField.intern("Allow", (short)100, 264, (byte)34);
        HeaderField.intern("Content-Base", (short)101, 8, (byte)35);
        HeaderField.intern("Content-Encoding", (short)100, 1288, (byte)36);
        HeaderField.intern("Content-Language", (short)101, 264, (byte)37);
        HeaderField.intern("Content-Length", (short)100, 1032, (byte)38);
        HeaderField.intern("Content-Location", (short)101, 1032, (byte)39);
        HeaderField.intern("Content-MD5", (short)101, 8, (byte)40);
        HeaderField.intern("Content-Range", (short)101, 1032, (byte)41);
        HeaderField.intern("Content-Type", (short)100, 1032, (byte)42);
        HeaderField.intern("ETag", (short)101, 8, (byte)43);
        HeaderField.intern("Expires", (short)100, 1032, (byte)44);
        HeaderField.intern("Last-Modified", (short)100, 1032, (byte)45);
        HeaderField.intern("Content-Version", (short)101, 2056, (byte)46);
        HeaderField.intern("Derived-From", (short)101, 2056, (byte)47);
        HeaderField.intern("Link", (short)101, 2312, (byte)48);
    }
}

