/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.util;

import COM.ibm.netdiver.util.Comparable;

public abstract class PackedArray
implements Comparable {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    int[] buf;
    int length;

    abstract int units();

    abstract int mask();

    public PackedArray() {
    }

    public PackedArray(int n) {
        this.buf = new int[(n + this.units() - 1) / this.units()];
        this.length = n;
        if (this.buf.length > 0) {
            this.buf[this.buf.length - 1] = 0;
        }
    }

    public final int length() {
        return this.length;
    }

    public final byte get(int n) {
        int n2 = this.units();
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(new Integer(n).toString());
        }
        int n3 = this.buf[n / n2];
        return (byte)(n3 >>> 32 / n2 * (n2 - n % n2 - 1));
    }

    public final void set(int n, byte by) {
        if (n < 0 || n >= this.length) {
            throw new ArrayIndexOutOfBoundsException(new Integer(n).toString());
        }
        int n2 = this.units();
        int n3 = (n2 - n % n2 - 1) * (32 / n2);
        int n4 = by << n3;
        int n5 = this.mask() << n3;
        this.buf[n /= n2] = this.buf[n] & ~n5 | n4;
    }

    public final boolean equals(Comparable comparable) {
        PackedArray packedArray = (PackedArray)comparable;
        if (packedArray != null && this.length == packedArray.length) {
            int n = 0;
            while (n < this.buf.length) {
                if (this.buf[n] != packedArray.buf[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public final int compareTo(Comparable comparable) {
        PackedArray packedArray = (PackedArray)comparable;
        int n = Math.min(packedArray.buf.length, this.buf.length);
        int n2 = 0;
        int n3 = 0;
        while (n3 < n) {
            n2 = this.buf[n3] - packedArray.buf[n3];
            if (n2 != 0) {
                return n2;
            }
            ++n3;
        }
        if (n3 < this.buf.length) {
            return this.buf[n3];
        }
        if (n3 < packedArray.buf.length) {
            return -packedArray.buf[n3];
        }
        return 0;
    }
}

