/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.netdiver.util;

import COM.ibm.netdiver.util.ArrayEnumerator;
import COM.ibm.netdiver.util.Comparable;
import COM.ibm.netdiver.util.Vector;
import java.util.Enumeration;

public abstract class Table {
    String stupid_way = "(c) Copyright IBM Corp.  1997.  All rights reserved.";
    int count;
    boolean sorted;
    protected Comparable[] table;

    protected Table() {
    }

    public Table(int n) {
        this.table = new Comparable[n];
    }

    public Table(Object[] objectArray) {
        this(objectArray.length);
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = this.createEntry(objectArray[n]);
            ++n;
        }
    }

    public Table(Vector vector) {
        this(vector.size());
        int n = 0;
        while (n < this.table.length) {
            this.table[n] = this.createEntry(vector.elementAt(n));
            ++n;
        }
    }

    public final int size() {
        return this.table.length;
    }

    protected abstract Comparable createEntry(Object var1);

    public void qsort(int n, int n2) {
        Comparable comparable = this.table[(n + n2) / 2];
        int n3 = n;
        int n4 = n2;
        while (true) {
            if (this.table[n3].compareTo(comparable) < 0) {
                ++n3;
                continue;
            }
            while (comparable.compareTo(this.table[n4]) < 0) {
                --n4;
            }
            if (n3 <= n4) {
                Comparable comparable2 = this.table[n3];
                this.table[n3] = this.table[n4];
                this.table[n4] = comparable2;
                ++n3;
                --n4;
            }
            if (n3 > n4) break;
        }
        if (n < n4) {
            this.qsort(n, n4);
        }
        if (n3 < n2) {
            this.qsort(n3, n2);
        }
    }

    public final int find(Comparable comparable) {
        this.checksort();
        int n = 0;
        this.count = 0;
        int n2 = this.table.length / 2;
        while (n2 >= 0 && n < this.table.length) {
            int n3;
            ++this.count;
            if (n + n2 >= this.table.length) {
                n2 = this.table.length - 1 - n;
            }
            if ((n3 = comparable.compareTo(this.table[n + n2])) >= 0) {
                n += n2;
                if (n3 == 0) break;
            }
            n2 -= n2 / 2 > 1 ? n2 / 2 : 1;
        }
        if (this.table[n].equals(comparable)) {
            return n;
        }
        return -1;
    }

    public final Enumeration elements() {
        this.checksort();
        return new ArrayEnumerator(this.table);
    }

    public final Comparable elementAt(int n) {
        return this.table[n];
    }

    private synchronized void checksort() {
        if (!this.sorted) {
            this.sorted = true;
        }
    }
}

