/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.dadmgui;

import COM.ibm.raleigh.dadmgui.AddressData;
import COM.ibm.raleigh.dadmgui.ClientData;
import COM.ibm.raleigh.dadmgui.DadminFrame;
import COM.ibm.raleigh.dadmgui.DadminNLS;
import COM.ibm.raleigh.dadmgui.Integere;
import COM.ibm.raleigh.dadmgui.StatsData;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class dadminRequest {
    private static final String copyright1 = "(c) Copyright IBM Corp 1992, 1997.  All rights reserved.";
    static final int bsize = 652;
    static final int VERSION_TAG_SIZE = 12;
    static final int minsize = 140;
    static final int poll = 100;
    static final int readtimeout = 120000;
    static final String version = "ver 3.30";
    static final int versionno = 330;
    static final int RT_STATS = 10;
    static final int RT_STATS_R = 11;
    static final int RT_CLIENT = 20;
    static final int RT_CLIENT_R = 21;
    static final int RT_IP = 30;
    static final int RT_IP_R = 31;
    static final int RT_POOL = 32;
    static final int RT_POOL_R = 33;
    static final int RT_TRACEON = 40;
    static final int RT_TRACEON_R = 42;
    static final int RT_TRACEOFF = 41;
    static final int RT_TRACEOFF_R = 43;
    static final int RT_DELETEINFO = 48;
    static final int RT_DELETEINFO_R = 49;
    static final int RT_DELETE = 50;
    static final int RT_DELETE_R = 51;
    static final int RT_INITIALIZE = 52;
    static final int RT_INITIALIZE_R = 53;
    static final int RT_STATUS = 54;
    static final int RT_STATUS_R = 55;
    static final int RT_UNKNOWN = 99;
    static final int DADMIN_RC_OK = 0;
    static final int DADMIN_RC_NOK = 1;
    static final int DADMIN_RC_CANTINIT = 2;
    static final int DADMIN_RC_BADSOCK = 3;
    static final int DADMIN_RC_NOADDRESS = 4;
    static final int DADMIN_RC_PERMISSION_DENIED = 5;
    static final int DADMIN_RC_CANT_LOCATE_ADDR = 6;
    static final int DADMIN_RC_NOCLIENTID_MATCH = 7;
    static final int DADMIN_RC_DONE = 8;
    static final String messagedelim = "=================================================================\n";
    private byte[] bbytes;
    private int count;
    private Object replydata;
    private String host;
    private int ipaddr;
    private DadminFrame da;

    public dadminRequest(String string, DadminFrame dadminFrame) {
        this.host = string;
        this.da = dadminFrame;
        this.bbytes = new byte[652];
        int n = 0;
        while (n < 652) {
            this.bbytes[n] = 0;
            ++n;
        }
        this.version_tag(version);
        this.version_no(330);
    }

    public String host() {
        return this.host;
    }

    public void send(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.write(this.bbytes, 0, 140 + this.data_length());
    }

    /*
     * Unable to fully structure code
     */
    public int ReadReply(DataInputStream var1_1) throws IOException {
        var2_2 = 0;
        this.count = 0;
        var3_3 = false;
        ** GOTO lbl38
        {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException v0) {}
            if ((var2_2 += 100) >= 120000) {
                return 1;
            }
            do {
                if (var1_1.available() == 0) continue block7;
                this.count += var1_1.read(this.bbytes, this.count, 652 - this.count);
                if (this.count < 652) continue;
                var4_4 = this.trans_type();
                switch (var4_4) {
                    case 11: {
                        var6_6 = new StatsData(this.da);
                        var5_5 = var6_6.read(var1_1);
                        if (!var5_5) {
                            var6_6 = null;
                            break;
                        }
                        this.replydata = var6_6;
                        break;
                    }
                    case 31: 
                    case 33: 
                    case 49: 
                    case 55: {
                        var6_6 = new AddressData(this.da);
                        var5_5 = var6_6.read(var1_1);
                        if (!var5_5) break;
                        this.replydata = var6_6;
                        break;
                    }
                    case 21: {
                        var6_6 = new ClientData(this.da);
                        var5_5 = var6_6.read(var1_1);
                        if (!var5_5) break;
                        this.replydata = var6_6;
                        break;
                    }
                }
                var3_3 = true;
lbl38:
                // 3 sources

            } while (!var3_3);
        }
        return 0;
    }

    public String version_tag() {
        return new String(this.bbytes, 0, 12);
    }

    public void version_tag(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        if (n > 12) {
            n = 12;
        }
        System.arraycopy(byArray, 0, this.bbytes, 0, n);
    }

    public int version_no() {
        return Integere.bytes2int(this.bbytes, 12);
    }

    public void version_no(int n) {
        Integere.int2bytes(n, this.bbytes, 12);
    }

    public int trans_type() {
        return Integere.bytes2int(this.bbytes, 16);
    }

    public void trans_type(int n) {
        Integere.int2bytes(n, this.bbytes, 16);
    }

    public int client_ipaddr() {
        return Integere.bytes2int(this.bbytes, 20);
    }

    public void client_ipaddr(int n) {
        Integere.int2bytes(n, this.bbytes, 20);
    }

    public int sequence_no() {
        return Integere.bytes2int(this.bbytes, 24);
    }

    public void sequence_no(int n) {
        Integere.int2bytes(n, this.bbytes, 24);
    }

    public int timestamp() {
        return Integere.bytes2int(this.bbytes, 28);
    }

    public void timestamp(int n) {
        Integere.int2bytes(n, this.bbytes, 28);
    }

    public int rc() {
        return Integere.bytes2int(this.bbytes, 32);
    }

    public void rc(int n) {
        Integere.int2bytes(n, this.bbytes, 32);
    }

    public int data_length() {
        return Integere.bytes2int(this.bbytes, 136);
    }

    public void data_length(int n) {
        Integere.int2bytes(n, this.bbytes, 136);
    }

    public void getdata(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            byArray[n + n3] = this.bbytes[140 + n3];
            ++n3;
        }
    }

    public void setdata(byte[] byArray, int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.bbytes[140 + n3] = byArray[n + n3];
            ++n3;
        }
    }

    private String replystr(int n) {
        switch (n) {
            case 11: {
                return DadminNLS.nls("Statistics");
            }
            case 21: {
                return DadminNLS.nls("Client");
            }
            case 31: {
                return DadminNLS.nls("Address");
            }
            case 33: {
                return DadminNLS.nls("Pool");
            }
            case 42: {
                return DadminNLS.nls("s11");
            }
            case 43: {
                return DadminNLS.nls("s12");
            }
            case 49: {
                return DadminNLS.nls("s21");
            }
            case 51: {
                return DadminNLS.nls("Delete");
            }
            case 53: {
                return DadminNLS.nls("Re-initialize");
            }
            case 55: {
                return DadminNLS.nls("Status");
            }
        }
        return DadminNLS.nls("Unknown");
    }

    String rc_s(int n) {
        switch (n) {
            case 0: {
                return DadminNLS.nls("s22");
            }
            case 1: {
                return DadminNLS.nls("s23");
            }
            case 2: {
                return DadminNLS.nls("s24");
            }
            case 3: {
                return DadminNLS.nls("s25");
            }
            case 4: {
                return DadminNLS.nls("s26");
            }
            case 5: {
                return DadminNLS.nls("s27");
            }
            case 6: {
                return DadminNLS.nls("s28");
            }
            case 7: {
                return DadminNLS.nls("s29");
            }
            case 8: {
                return DadminNLS.nls("s30");
            }
        }
        return DadminNLS.nls("s23");
    }

    public void displayString() {
        int n = this.trans_type();
        this.da.displayText(messagedelim);
        this.da.displayText(DadminNLS.nls("s31", this.replystr(this.trans_type()), this.host));
        if (this.rc() != 0) {
            this.da.displayText(String.valueOf(DadminNLS.nls("s32")) + this.rc_s(this.rc()) + "\n");
            this.da.displayText(messagedelim);
            return;
        }
        switch (n) {
            case 11: {
                if (this.replydata != null) {
                    ((StatsData)this.replydata).toDisplay();
                    break;
                }
                this.da.displayText(DadminNLS.nls("s33"));
                break;
            }
            case 21: {
                if (this.replydata != null) {
                    ((ClientData)this.replydata).toDisplay();
                    break;
                }
                this.da.displayText(DadminNLS.nls("s33"));
                break;
            }
            case 31: 
            case 33: 
            case 49: 
            case 55: {
                if (this.replydata != null) {
                    ((AddressData)this.replydata).toDisplay();
                    break;
                }
                this.da.displayText(DadminNLS.nls("s33"));
                break;
            }
            case 51: {
                this.da.displayText(DadminNLS.nls("s34", this.host));
                if (this.replydata == null) break;
                ((AddressData)this.replydata).toDisplay();
            }
            case 53: {
                this.da.displayText(DadminNLS.nls("s35", this.host));
                break;
            }
            case 42: {
                this.da.displayText(DadminNLS.nls("s36", this.host));
                break;
            }
            case 43: {
                this.da.displayText(DadminNLS.nls("s37", this.host));
                break;
            }
            default: {
                this.da.displayText(DadminNLS.nls("s38", this.host));
            }
        }
        this.da.displayText(messagedelim);
    }

    public void makestatistics(int n) {
        this.data_length(4);
        Integere.int2bytes(n, this.bbytes, 140);
        this.trans_type(10);
    }

    public void makeclient(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        if (n > 64) {
            n = 64;
        }
        System.arraycopy(byArray, 0, this.bbytes, 140, n);
        this.data_length(n);
        this.trans_type(20);
    }

    public void makeIPAddr(int n, boolean bl) {
        Integere.int2bytes(n, this.bbytes, 140);
        this.data_length(4);
        if (bl) {
            this.trans_type(32);
            return;
        }
        this.trans_type(30);
    }

    public void maketrace(boolean bl) {
        if (bl) {
            this.trans_type(40);
            return;
        }
        this.trans_type(41);
    }

    public void makeinit() {
        this.trans_type(52);
    }

    public void makestatus() {
        this.trans_type(54);
    }

    public void makeDeleteinfo(int n) {
        Integere.int2bytes(n, this.bbytes, 140);
        this.ipaddr = n;
        this.data_length(4);
        this.trans_type(48);
    }

    public void makeDelete() {
        int n = 0;
        while (n < 652) {
            this.bbytes[n] = 0;
            ++n;
        }
        this.version_tag(version);
        this.version_no(330);
        this.replydata = null;
        Integere.int2bytes(this.ipaddr, this.bbytes, 140);
        this.data_length(4);
        this.trans_type(50);
    }

    public String deletequery() {
        this.ipaddr = ((AddressData)this.replydata).getLastIPAddress();
        return String.valueOf(DadminNLS.nls("s39")) + ((AddressData)this.replydata).getLastAddress() + "\n" + DadminNLS.nls("s40");
    }
}

