/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.PrimaryDomainFrame;
import COM.ibm.raleigh.ddnssgui.common.BorderPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.TcpipValidation;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

class DomainOptionsPanel
extends Panel
implements KeyListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    public static final int FIRST_FIELD = 0;
    public static final int AUTO_REVERSE_FIELD = 0;
    public static final int REFRESH_RATE_FIELD = 1;
    public static final int RETRY_INTERVAL_FIELD = 2;
    public static final int EXPIRE_TIME_FIELD = 3;
    public static final int DEFAULT_TTL_FIELD = 4;
    private static final int NUM_BUTTONS = 3;
    private static final int NUM_TEXT_COLUMNS = 10;
    private static final int NUM_TEXT_TIME_RANGES = 3;
    private PrimaryDomainFrame parent;
    private ResourceBundle resources;
    private Checkbox autoReverseMap;
    private Label serialNumLabel;
    private String serialNum;
    private BorderPanel serverRefreshPanel;
    private Label refreshRateLabel;
    private TextField refreshRate;
    private Label retryIntervalLabel;
    private TextField retryInterval;
    private Label expireTimeLabelBefore;
    private Label expireTimeLabelAfter;
    private TextField expireTime;
    private Label defaultTTLLabel;
    private TextField defaultTTL;
    private Label[] timeRange;

    public DomainOptionsPanel(PrimaryDomainFrame primaryDomainFrame, ResourceBundle resourceBundle) {
        this.parent = primaryDomainFrame;
        this.resources = resourceBundle;
        this.setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public void requestFocus(int n) {
        switch (n) {
            case 0: {
                this.autoReverseMap.requestFocus();
                return;
            }
            case 1: {
                this.refreshRate.requestFocus();
                return;
            }
            case 2: {
                this.retryInterval.requestFocus();
                return;
            }
            case 3: {
                this.expireTime.requestFocus();
                return;
            }
            case 4: {
                this.defaultTTL.requestFocus();
                return;
            }
        }
    }

    public void selectAll(int n) {
        switch (n) {
            case 1: {
                this.refreshRate.selectAll();
                return;
            }
            case 2: {
                this.retryInterval.selectAll();
                return;
            }
            case 3: {
                this.expireTime.selectAll();
                return;
            }
            case 4: {
                this.defaultTTL.selectAll();
                return;
            }
        }
    }

    public boolean getAutoReverseMapState() {
        return this.autoReverseMap.getState();
    }

    public void setAutoReverseMapState(boolean bl) {
        String string = new String(this.parent.getFullyQualifiedDomainName());
        if (!(string = string.toLowerCase()).endsWith("in-addr.arpa")) {
            this.autoReverseMap.setEnabled(true);
            this.autoReverseMap.setState(bl);
            return;
        }
        this.autoReverseMap.setEnabled(false);
        this.autoReverseMap.setState(false);
    }

    public void setSerialNumber(long l) {
        if (l >= 0L) {
            this.serialNum = Long.toString(l);
        }
        Object[] objectArray = new Object[]{this.serialNum};
        this.serialNumLabel.setText(MessageFormat.format(this.resources.getString("SERIAL_NUM_LABEL"), objectArray));
    }

    public int getRefreshRate() {
        return this.getNumber(this.refreshRate.getText().trim());
    }

    public void setRefreshRate(int n) {
        ((TextComponent)this.refreshRate).setText(Integer.toString(n).trim());
    }

    public int getRetryInterval() {
        return this.getNumber(this.retryInterval.getText().trim());
    }

    public void setRetryInterval(int n) {
        ((TextComponent)this.retryInterval).setText(Integer.toString(n).trim());
    }

    public int getExpireTime() {
        return this.getNumber(this.expireTime.getText().trim());
    }

    public void setExpireTime(int n) {
        ((TextComponent)this.expireTime).setText(Integer.toString(n).trim());
    }

    public int getDefaultTTL() {
        return this.getNumber(this.defaultTTL.getText().trim());
    }

    public void setDefaultTTL(int n) {
        ((TextComponent)this.defaultTTL).setText(Integer.toString(n).trim());
    }

    public boolean validateRefreshRate() {
        return TcpipValidation.validateInteger(this.getRefreshRate());
    }

    public boolean validateRetryInterval() {
        return TcpipValidation.validateInteger(this.getRetryInterval());
    }

    public boolean validateExpireTime() {
        return TcpipValidation.validateInteger(this.getExpireTime());
    }

    public boolean validateDefaultTTL() {
        return TcpipValidation.validateInteger(this.getDefaultTTL());
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.autoReverseMap = new Checkbox(this.resources.getString("AUTO_REVERSE_MAP_LABEL"));
        this.autoReverseMap.addKeyListener(this);
        this.serialNum = new String("");
        Object[] objectArray = new Object[]{this.serialNum};
        this.serialNumLabel = new Label(MessageFormat.format(this.resources.getString("SERIAL_NUM_LABEL"), objectArray), 0);
        this.serverRefreshPanel = new BorderPanel(this.resources.getString("SERVER_REFRESH_LABEL"));
        this.refreshRateLabel = new Label(this.resources.getString("REFRESH_RATE_LABEL"), 0);
        this.refreshRate = new TextField("", 10);
        this.retryIntervalLabel = new Label(this.resources.getString("RETRY_INTERVAL_LABEL"), 0);
        this.retryInterval = new TextField("", 10);
        this.expireTimeLabelBefore = new Label(this.resources.getString("EXPIRE_TIME_LABEL_BEFORE"), 0);
        this.expireTime = new TextField("", 10);
        this.expireTimeLabelAfter = new Label(this.resources.getString("EXPIRE_TIME_LABEL_AFTER"), 0);
        this.defaultTTLLabel = new Label(this.resources.getString("DEFAULT_TTL_LABEL"), 0);
        this.defaultTTL = new TextField("", 10);
        this.timeRange = new Label[3];
        int n = 0;
        while (n < 3) {
            this.timeRange[n] = new Label(this.resources.getString("SECONDS_LABEL"), 1);
            ++n;
        }
    }

    private void addComponentsToGrid() {
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add(this.autoReverseMap, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.add(this.serialNumLabel, gridBagLayout, gridBagConstraints, 0, 1, 0, 1);
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.serverRefreshPanel.setLayout(gridBagLayout2);
        this.constrain(this.refreshRateLabel, gridBagLayout2, gridBagConstraints2, 0, 0, 0, 1);
        this.serverRefreshPanel.add(this.refreshRateLabel);
        gridBagConstraints2.anchor = 13;
        this.constrain(this.refreshRate, gridBagLayout2, gridBagConstraints2, 0, 1, 1, 1);
        this.serverRefreshPanel.add(this.refreshRate);
        gridBagConstraints2.anchor = 17;
        this.constrain(this.timeRange[n], gridBagLayout2, gridBagConstraints2, 1, 1, 0, 1);
        this.serverRefreshPanel.add(this.timeRange[n]);
        ++n;
        this.constrain(this.retryIntervalLabel, gridBagLayout2, gridBagConstraints2, 0, 2, 0, 1);
        this.serverRefreshPanel.add(this.retryIntervalLabel);
        gridBagConstraints2.anchor = 13;
        this.constrain(this.retryInterval, gridBagLayout2, gridBagConstraints2, 0, 3, 1, 1);
        this.serverRefreshPanel.add(this.retryInterval);
        gridBagConstraints2.anchor = 17;
        this.constrain(this.timeRange[n], gridBagLayout2, gridBagConstraints2, 1, 3, 0, 1);
        this.serverRefreshPanel.add(this.timeRange[n]);
        ++n;
        this.constrain(this.expireTimeLabelBefore, gridBagLayout2, gridBagConstraints2, 0, 4, 0, 1);
        this.serverRefreshPanel.add(this.expireTimeLabelBefore);
        gridBagConstraints2.anchor = 13;
        this.constrain(this.expireTime, gridBagLayout2, gridBagConstraints2, 0, 5, 1, 1);
        this.serverRefreshPanel.add(this.expireTime);
        gridBagConstraints2.anchor = 17;
        this.constrain(this.expireTimeLabelAfter, gridBagLayout2, gridBagConstraints2, 1, 5, 0, 1);
        this.serverRefreshPanel.add(this.expireTimeLabelAfter);
        gridBagConstraints.fill = 1;
        this.add(this.serverRefreshPanel, gridBagLayout, gridBagConstraints, 0, 2, 0, 6);
        gridBagConstraints.fill = 0;
        this.add(this.defaultTTLLabel, gridBagLayout, gridBagConstraints, 0, 8, 0, 1);
        gridBagConstraints.anchor = 13;
        this.add(this.defaultTTL, gridBagLayout, gridBagConstraints, 0, 9, 1, 1);
        gridBagConstraints.anchor = 17;
        this.add(this.timeRange[n], gridBagLayout, gridBagConstraints, 1, 9, 0, 1);
    }

    private int getNumber(String string) {
        if (TcpipValidation.IsLessThanMaxIntegerValue(string)) {
            try {
                Integer n = new Integer(string);
                return n;
            }
            catch (NumberFormatException numberFormatException) {
                return Integer.MIN_VALUE;
            }
        }
        return Integer.MIN_VALUE;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Checkbox) {
            Checkbox checkbox;
            checkbox.setState(!(checkbox = (Checkbox)object).getState());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

