/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.tabView.TabView;
import COM.ibm.eNetwork.jdi.gui.tabView.TabViewNode;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.client.RecordsPanel;
import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.ButtonPanel;
import COM.ibm.raleigh.ddnssgui.common.DDNSUtility;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.ItemSelectable;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import java.util.ResourceBundle;

class FileErrorsFrame
extends Frame
implements WindowListener,
ActionListener,
ItemListener,
KeyListener {
    public static final String cStmt1 = "Licensed Materials - Property of IBM \n IBM TCP/IP for OS/2 \n (c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final String cStmt2 = "US Government Users Restricted Rights - Use, Duplication or\n disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    public static final String appVersion = "Dynamic IP Version 1.0";
    public static final String modVersion = "This Class Version 1.0";
    private static final int TABVIEW_BOOT_FILE_INDEX = 0;
    private static final int TABVIEW_FIRST_INDEX = 0;
    private static final int TABVIEW_CACHE_FILE_INDEX = 1;
    private static final int TABVIEW_DOMAIN_INDEX = 2;
    private static final int NUM_TABS = 3;
    private static final int NUM_BUTTONS = 2;
    private final int OK_BUTTON = 0;
    private final int HELP_BUTTON = 1;
    private MainFrame parent;
    private ResourceBundle resources;
    private RecordsPanel bootFilePanel;
    private RecordsPanel cacheFilePanel;
    private Panel domainPanel;
    private Label domainLabel;
    private Choice domainName;
    private RecordsPanel domainRecordsPanel;
    private Button[] buttons;
    private String[] buttonLabels;
    private ButtonPanel buttonPanel;
    private TabView tabView;
    private TabViewNode[] tabNodes;
    private FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    private ColorsForCanvas cfcColor = new ColorsForCanvas(DDNSUtility.BACKGROUND_COLOR, DDNSUtility.TEXT_COLOR, DDNSUtility.HIGHLIGHT_COLOR);

    public FileErrorsFrame(MainFrame mainFrame) {
        this.setResizable(false);
        this.parent = mainFrame;
        this.resources = this.parent.clientResources;
        this.setTitle(this.resources.getString("FILE_ERRORS_FRAME_NAME"));
        ((Component)this).setBackground(DDNSUtility.BACKGROUND_COLOR);
        this.initComponents();
        this.addComponentsToGrid();
    }

    public Dimension getMinSize() {
        this.pack();
        LayoutManager layoutManager = this.getLayout();
        return layoutManager.minimumLayoutSize(this);
    }

    public void selectFirstTab() {
        if (this.tabView != null) {
            this.tabView.selectTab(this.tabNodes[0]);
        }
    }

    public void setFullyQualifiedDomainName(String string) {
        if (string != null && string.length() > 0) {
            this.domainName.select(string.trim());
        }
    }

    public void setFullyQualifiedDomainNameList(String[] stringArray) {
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                this.domainName.addItem(stringArray[n].trim());
                ++n;
            }
            if (stringArray.length > 1) {
                this.domainName.setEnabled(true);
            }
        }
    }

    public void setBootFileErrors(String[] stringArray) {
        if (stringArray != null) {
            this.bootFilePanel.setRecords(stringArray);
        }
    }

    public void setCacheFileErrors(String[] stringArray) {
        if (stringArray != null) {
            this.cacheFilePanel.setRecords(stringArray);
        }
    }

    public void setDomainErrors(String[] stringArray) {
        if (stringArray != null) {
            this.domainRecordsPanel.setRecords(stringArray);
        }
    }

    private void add(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
        this.add(component);
    }

    private void constrain(Component component, GridBagLayout gridBagLayout, GridBagConstraints gridBagConstraints, int n, int n2, int n3, int n4) {
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagLayout.setConstraints(component, gridBagConstraints);
    }

    private void initComponents() {
        this.bootFilePanel = new RecordsPanel(this.resources.getString("BOOT_FILE_ERRORS_LABEL"));
        this.bootFilePanel.setEnabled(false);
        this.cacheFilePanel = new RecordsPanel(this.resources.getString("CACHE_FILE_ERRORS_LABEL"));
        this.cacheFilePanel.setEnabled(false);
        this.domainPanel = new Panel();
        this.domainLabel = new Label(this.resources.getString("DOMAIN_NAME_LABEL"), 0);
        this.domainName = new Choice();
        this.domainName.addItemListener(this);
        this.domainRecordsPanel = new RecordsPanel(this.resources.getString("DOMAIN_ERRORS_LABEL"));
        this.domainRecordsPanel.setEnabled(false);
        this.initButtonPanel();
        this.tabView = new TabView(new Point(0, 0), new Dimension(Integer.parseInt(this.resources.getString("FEF_TABVIEW_WIDTH")), Integer.parseInt(this.resources.getString("FEF_TABVIEW_HEIGHT"))), this.ffcFont, this.cfcColor, null, 1);
        this.createTabs();
        this.setBootFileErrors(this.getAList(9));
        this.setCacheFileErrors(this.getAList(10));
        String[] stringArray = this.getAList(1);
        if (stringArray != null) {
            this.setFullyQualifiedDomainNameList(stringArray);
            this.domainName.getItemCount();
            if (stringArray != null && stringArray.length > 0) {
                this.setFullyQualifiedDomainName(stringArray[0]);
            }
            this.setDomainErrors(this.getAList(11, this.domainName.getSelectedItem()));
        } else {
            this.domainName.setEnabled(false);
        }
        this.addWindowListener(this);
    }

    private String[] getAList(int n) {
        RequestList requestList = new RequestList(n);
        return requestList.getReturnedList(this.resources, this.parent.dataOut);
    }

    private String[] getAList(int n, String string) {
        RequestList requestList = new RequestList(n, string);
        return requestList.getReturnedList(this.resources, this.parent.dataOut);
    }

    private void addComponentsToGrid() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        GridBagConstraints gridBagConstraints2 = (GridBagConstraints)gridBagConstraints.clone();
        this.domainPanel.setLayout(gridBagLayout2);
        gridBagConstraints2.fill = 0;
        gridBagConstraints2.anchor = 17;
        this.constrain(this.domainLabel, gridBagLayout2, gridBagConstraints2, 0, 0, 1, 1);
        this.domainPanel.add(this.domainLabel);
        gridBagConstraints2.fill = 2;
        this.constrain(this.domainName, gridBagLayout2, gridBagConstraints2, 1, 0, 0, 1);
        this.domainPanel.add(this.domainName);
        this.constrain(this.domainRecordsPanel, gridBagLayout2, gridBagConstraints2, 0, 1, 0, 0);
        this.domainPanel.add(this.domainRecordsPanel);
        this.add((Component)this.tabView, gridBagLayout, gridBagConstraints, 0, 0, 0, 1);
        this.addTabs();
        this.tabView.committ();
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        this.add(this.buttonPanel, gridBagLayout, gridBagConstraints, 0, 1, 0, 0);
    }

    private void initButtonPanel() {
        this.buttonLabels = new String[2];
        this.buttonLabels[0] = this.resources.getString("BUTTON_PANEL_OK");
        this.buttonLabels[1] = this.resources.getString("BUTTON_PANEL_HELP");
        int n = this.buttonLabels.length;
        this.buttons = new Button[n];
        int n2 = 0;
        while (n2 < this.buttonLabels.length) {
            this.buttons[n2] = new Button(this.buttonLabels[n2]);
            this.buttons[n2].addActionListener(this);
            this.buttons[n2].addKeyListener(this);
            ++n2;
        }
        this.buttonPanel = new ButtonPanel(this, this.buttons);
    }

    private void handleButton(Button button) {
        if (button == this.buttons[0]) {
            this.exitFrame();
        }
        if (button == this.buttons[1]) {
            int n = this.tabView.getSelectedTab().getId();
            if (n == 0) {
                this.parent.handleHelp("ddscnbvb.htm#HDRNBVTB");
                return;
            }
            if (n == 1) {
                this.parent.handleHelp("ddscnbvz.htm#HDRNBVTZ");
                return;
            }
            if (n == 2) {
                this.parent.handleHelp("ddscnbvd.htm#HDRNBVTD");
                return;
            }
            this.parent.handleHelp("ddscnbv.htm#HDRNBV");
        }
    }

    private void exitFrame() {
        this.parent.requestFocus();
        this.dispose();
    }

    private void createTabs() {
        this.tabNodes = new TabViewNode[3];
        int n = 0;
        while (n < 3) {
            this.tabNodes[n] = new TabViewNode();
            this.tabNodes[n].setColors(this.cfcColor);
            this.tabNodes[n].setFonts(this.ffcFont);
            this.tabNodes[n].setImage(null);
            this.tabNodes[n].setId(n);
            ++n;
        }
    }

    private void addTabs() {
        this.tabNodes[0].setText(this.resources.getString("TABVIEW_BOOT_FILE_LABEL"));
        this.tabNodes[0].setPanel((Panel)this.bootFilePanel);
        this.tabNodes[1].setText(this.resources.getString("TABVIEW_CACHE_FILE_LABEL"));
        this.tabNodes[1].setPanel((Panel)this.cacheFilePanel);
        this.tabNodes[2].setText(this.resources.getString("TABVIEW_DOMAIN_LABEL"));
        this.tabNodes[2].setPanel(this.domainPanel);
        int n = 0;
        while (n < 3) {
            this.tabView.addTab(this.tabNodes[n]);
            ++n;
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        ItemSelectable itemSelectable = itemEvent.getItemSelectable();
        if (itemSelectable == this.domainName) {
            String string = this.domainName.getSelectedItem();
            Object[] objectArray = new Object[]{string};
            BusyWaitFrame busyWaitFrame = new BusyWaitFrame(this.resources, MessageFormat.format(this.resources.getString("FILE_ERRORS_BUSY_WAIT"), objectArray));
            ((Component)busyWaitFrame).setSize(300, 75);
            busyWaitFrame.doLayout();
            busyWaitFrame.show();
            busyWaitFrame.repaint();
            this.setDomainErrors(this.getAList(11, string));
            busyWaitFrame.dispose();
        }
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        this.exitFrame();
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
        Object object = keyEvent.getSource();
        if (keyEvent.getKeyCode() == 10 && object instanceof Button) {
            this.handleButton((Button)object);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
    }
}

