/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.raleigh.ddnssgui.client.AliasHostFrame;
import COM.ibm.raleigh.ddnssgui.client.CreateDomainDialog;
import COM.ibm.raleigh.ddnssgui.client.DDNSManager;
import COM.ibm.raleigh.ddnssgui.client.HostFrame;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.client.ReverseHostFrame;
import COM.ibm.raleigh.ddnssgui.common.AliasHostObject;
import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.HostObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedObject;
import COM.ibm.raleigh.ddnssgui.common.ParsedVector;
import COM.ibm.raleigh.ddnssgui.common.PrimaryDomain;
import COM.ibm.raleigh.ddnssgui.common.Question;
import COM.ibm.raleigh.ddnssgui.common.RequestList;
import COM.ibm.raleigh.ddnssgui.common.ReservedName;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.awt.Component;
import java.awt.Dimension;
import java.io.Serializable;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.Vector;

public class HostObjectMgr
extends DDNSManager {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    private static final int HOST = 1;
    private static final int ALIAS = 2;
    private static final int REVERSE = 3;
    private ResourceBundle resources;
    private HostObject HostObj;
    private AliasHostObject AliasHost;
    private ReverseHost revHost;
    private boolean NewObject;
    private String OwningDomainName;
    private HostFrame myHostPanel;
    private AliasHostFrame myAliasPanel;
    private ReverseHostFrame myReversePanel;
    private PrimaryDomain pDom;
    private boolean convertingObject;
    private ReservedName saveReservedName;
    private boolean haveSecDomain = false;

    public HostObjectMgr(MainFrame mainFrame) {
        super(mainFrame);
        this.resources = mainFrame.clientResources;
        this.OwningDomainName = null;
    }

    public void exit() {
        if (this.myHostPanel != null) {
            this.myHostPanel.dispose();
        }
        if (this.myAliasPanel != null) {
            this.myAliasPanel.dispose();
        }
        if (this.myReversePanel != null) {
            this.myReversePanel.dispose();
        }
    }

    public boolean isShowing() {
        return this.myHostPanel != null || this.myAliasPanel != null || this.myReversePanel != null;
    }

    public void requestFocus() {
        if (this.myHostPanel != null) {
            this.myHostPanel.requestFocus();
            this.myHostPanel.selectAll(0);
            this.myHostPanel.requestFocus(0);
            return;
        }
        if (this.myAliasPanel != null) {
            this.myAliasPanel.requestFocus();
            this.myAliasPanel.selectAll(0);
            this.myAliasPanel.requestFocus(0);
            return;
        }
        if (this.myReversePanel != null) {
            this.myReversePanel.requestFocus();
            this.myReversePanel.selectAll(0);
            this.myReversePanel.requestFocus(0);
        }
    }

    public void CreateNewHost() {
        this.CreateNewHost(new String(""));
    }

    public void convertToReverse(String string, String string2) {
        this.NewObject = false;
        this.convertingObject = true;
        this.HostObj = null;
        this.AliasHost = null;
        this.pDom = null;
        this.revHost = new ReverseHost();
        this.MyParent.dataOut.sendToServer("RN=GET,name=" + string + "," + "dname=" + string2 + "," + "ERN" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.saveReservedName = new ReservedName(dDNSNetworkStringParser.getParsed());
        String[] stringArray = this.saveReservedName.getComments();
        if (stringArray != null) {
            this.revHost.setComments(stringArray);
        }
        if ((stringArray = this.saveReservedName.getSIGRecs()) != null) {
            this.revHost.setSIGRecs(stringArray);
        }
        if ((stringArray = this.saveReservedName.getKEYRecs()) != null) {
            this.revHost.setKEYRecs(stringArray);
        }
        this.revHost.setHostName(this.saveReservedName.getHostName());
        this.revHost.setDataDynamic(true);
        this.OwningDomainName = new String(string2);
        this.myReversePanel = new ReverseHostFrame(this, string2);
        this.InitReverseFrame();
    }

    public void convertToHost(String string, String string2) {
        this.NewObject = false;
        this.convertingObject = true;
        this.HostObj = new HostObject();
        this.AliasHost = null;
        this.pDom = null;
        this.MyParent.dataOut.sendToServer("RN=GET,name=" + string + "," + "dname=" + string2 + "," + "ERN" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.saveReservedName = new ReservedName(dDNSNetworkStringParser.getParsed());
        String[] stringArray = this.saveReservedName.getComments();
        if (stringArray != null) {
            this.HostObj.setComments(stringArray);
        }
        if ((stringArray = this.saveReservedName.getSIGRecs()) != null) {
            this.HostObj.setSIGRecs(stringArray);
        }
        if ((stringArray = this.saveReservedName.getKEYRecs()) != null) {
            this.HostObj.setKEYRecs(stringArray);
        }
        this.revHost = null;
        this.HostObj.setHostName(this.saveReservedName.getHostName());
        this.HostObj.setDataDynamic(true);
        this.OwningDomainName = new String(string2);
        this.myHostPanel = new HostFrame(this);
        this.InitHostFrame();
    }

    public void convertToAlias(String string, String string2) {
        this.NewObject = false;
        this.convertingObject = true;
        this.HostObj = null;
        this.AliasHost = new AliasHostObject();
        this.pDom = null;
        this.MyParent.dataOut.sendToServer("RN=GET,name=" + string + "," + "dname=" + string2 + "," + "ERN" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.saveReservedName = new ReservedName(dDNSNetworkStringParser.getParsed());
        String[] stringArray = this.saveReservedName.getComments();
        if (stringArray != null) {
            this.AliasHost.setComments(stringArray);
        }
        if ((stringArray = this.saveReservedName.getSIGRecs()) != null) {
            this.AliasHost.setSIGRecs(stringArray);
        }
        if ((stringArray = this.saveReservedName.getKEYRecs()) != null) {
            this.AliasHost.setKEYRecs(stringArray);
        }
        this.revHost = null;
        this.AliasHost.setDataDynamic(true);
        this.AliasHost.setHostName(this.saveReservedName.getHostName());
        this.OwningDomainName = new String(string2);
        this.myAliasPanel = new AliasHostFrame(this);
        this.InitAliasFrame();
    }

    public void CreateNewReverse(String string) {
        this.NewObject = true;
        this.convertingObject = false;
        this.HostObj = null;
        this.AliasHost = null;
        this.pDom = null;
        this.revHost = new ReverseHost();
        this.OwningDomainName = new String(string);
        this.myReversePanel = new ReverseHostFrame(this, string);
        this.InitReverseFrame();
    }

    public void CreateNewAlias() {
        this.CreateNewAlias(new String(""));
    }

    public void CreateNewHost(String string) {
        this.NewObject = true;
        this.convertingObject = false;
        this.HostObj = new HostObject();
        this.AliasHost = null;
        this.revHost = null;
        this.OwningDomainName = string;
        if (string != null && !string.equals("")) {
            Question question = new Question(1, string);
            if (question.getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                this.MyParent.dataOut.sendToServer("PDOM=GET,name=" + string + "," + "EPDOM" + ",");
                DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                this.pDom = new PrimaryDomain(dDNSNetworkStringParser.getParsed());
                this.haveSecDomain = false;
            } else {
                this.pDom = null;
                this.haveSecDomain = true;
            }
        } else {
            this.pDom = null;
        }
        this.myHostPanel = new HostFrame(this);
        this.InitHostFrame();
    }

    public void CreateNewAlias(String string) {
        this.NewObject = true;
        this.convertingObject = false;
        this.HostObj = null;
        this.pDom = null;
        this.revHost = null;
        this.AliasHost = new AliasHostObject();
        this.OwningDomainName = string;
        this.myAliasPanel = new AliasHostFrame(this);
        this.InitAliasFrame();
    }

    public void UpdateExistingHost(String string, String string2) {
        this.MyParent.dataOut.sendToServer("HOST=GET,name=" + string + "," + "dname=" + string2 + "," + "EHOST" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.HostObj = new HostObject(dDNSNetworkStringParser.getParsed());
        this.NewObject = false;
        this.convertingObject = false;
        this.pDom = null;
        this.AliasHost = null;
        this.revHost = null;
        this.OwningDomainName = string2;
        this.myHostPanel = new HostFrame(this);
        this.InitHostFrame();
        Question question = new Question(1, string2);
        if (!question.getReturnedTrueOrFalse(this.MyParent.dataOut)) {
            this.myHostPanel.setEnabled(false);
            this.haveSecDomain = true;
            return;
        }
        this.haveSecDomain = false;
    }

    public void UpdateExistingAlias(String string, String string2) {
        this.MyParent.dataOut.sendToServer("ALIAS=GET,name=" + string + "," + "dname=" + string2 + "," + "EALIAS" + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.AliasHost = new AliasHostObject(dDNSNetworkStringParser.getParsed());
        this.HostObj = null;
        this.revHost = null;
        this.convertingObject = false;
        this.pDom = null;
        this.NewObject = false;
        this.OwningDomainName = string2;
        this.myAliasPanel = new AliasHostFrame(this);
        this.InitAliasFrame();
        Question question = new Question(1, string2);
        if (!question.getReturnedTrueOrFalse(this.MyParent.dataOut)) {
            this.myAliasPanel.setEnabled(false);
            this.haveSecDomain = true;
            return;
        }
        this.haveSecDomain = false;
    }

    public void UpdateExistingReverse(String string, String string2) {
        string.lastIndexOf(".");
        this.MyParent.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=GET," + "name=" + ReverseHost.reverseAddr(string, string2) + "," + "dname=" + string2 + "," + ReverseHost.EREVH_tag + ",");
        DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
        this.HostObj = null;
        this.convertingObject = false;
        this.NewObject = false;
        this.pDom = null;
        this.AliasHost = null;
        this.revHost = new ReverseHost(dDNSNetworkStringParser.getParsed());
        this.OwningDomainName = string2;
        this.myReversePanel = new ReverseHostFrame(this, string2);
        this.InitReverseFrame();
        Question question = new Question(1, string2);
        if (!question.getReturnedTrueOrFalse(this.MyParent.dataOut)) {
            this.myReversePanel.noModificationsAllowed();
            this.haveSecDomain = true;
            return;
        }
        this.haveSecDomain = false;
    }

    private void InitHostFrame() {
        if (this.haveSecDomain) {
            String[] stringArray = new String[]{new String(this.OwningDomainName)};
            this.myHostPanel.setFullyQualifiedDomainNameList(stringArray);
        } else {
            RequestList requestList = new RequestList(3);
            this.myHostPanel.setFullyQualifiedDomainNameList(requestList.getReturnedList(this.resources, this.MyParent.dataOut));
        }
        if (this.OwningDomainName != null) {
            this.myHostPanel.setFullyQualifiedDomainName(this.OwningDomainName);
        }
        this.myHostPanel.setHostName(this.HostObj.getHostName());
        this.myHostPanel.setIPAddrList(this.HostObj.getAllIpAddresses());
        this.myHostPanel.setPlatformList(this.HostObj.getCpuOpSys());
        this.myHostPanel.setMailList(this.HostObj.getMailExchange());
        this.myHostPanel.setHostTextList(this.HostObj.getTextEntry());
        this.myHostPanel.setTTLForHostName(this.HostObj.getATTL());
        this.myHostPanel.setTTLForIPAddr(this.HostObj.getPTRTTL());
        this.myHostPanel.setTTLForMail(this.HostObj.getMXTTL());
        this.myHostPanel.setTTLForPlatform(this.HostObj.getHINFOTTL());
        this.myHostPanel.setTTLForText(this.HostObj.getTXTTTL());
        this.myHostPanel.setComments(this.makeCommentsDisplayable(this.HostObj.getComments()));
        this.myHostPanel.setSigAndKeyRecords(this.HostObj.getKeyAndSigRecs());
        this.myHostPanel.setOtherRecords(this.HostObj.getOtherRecs());
        if (!this.NewObject && this.HostObj.isDynamic()) {
            this.myHostPanel.setEnabledComments(false);
            this.myHostPanel.setEnabledOtherRecords(false);
        }
        Dimension dimension = this.myHostPanel.getMinSize();
        this.myHostPanel.setEnabled(true);
        this.myHostPanel.setEnabledButtons(true);
        this.myHostPanel.show();
        this.myHostPanel.requestFocus();
    }

    private void InitAliasFrame() {
        if (this.haveSecDomain) {
            String[] stringArray = new String[]{new String(this.OwningDomainName)};
            this.myHostPanel.setFullyQualifiedDomainNameList(stringArray);
        } else {
            RequestList requestList = new RequestList(3);
            this.myAliasPanel.setFullyQualifiedDomainNameList(requestList.getReturnedList(this.resources, this.MyParent.dataOut));
        }
        if (this.OwningDomainName != null) {
            this.myAliasPanel.setFullyQualifiedDomainName(this.OwningDomainName);
        }
        this.myAliasPanel.setAliasName(this.AliasHost.getHostName());
        this.myAliasPanel.setHostName(this.AliasHost.getRealHostName());
        this.myAliasPanel.setAliasTTL(this.AliasHost.getCNAMEttl());
        this.myAliasPanel.setComments(this.makeCommentsDisplayable(this.AliasHost.getComments()));
        this.myAliasPanel.setSigAndKeyRecords(this.AliasHost.getKeyAndSigRecs());
        if (!this.NewObject && this.AliasHost.isDynamic()) {
            this.myAliasPanel.setEnabledComments(false);
        }
        Dimension dimension = this.myAliasPanel.getMinSize();
        this.myAliasPanel.setEnabled(true);
        this.myAliasPanel.setEnabledButtons(true);
        this.myAliasPanel.show();
        this.myAliasPanel.requestFocus();
    }

    private void InitReverseFrame() {
        this.myReversePanel.setIPaddress(this.revHost.getHostName());
        this.myReversePanel.setHostName(this.revHost.getPTRhostname());
        this.myReversePanel.setPtrTTL(this.revHost.getPTRttl());
        this.myReversePanel.setComments(this.makeCommentsDisplayable(this.revHost.getComments()));
        this.myReversePanel.setSigAndKeyRecords(this.revHost.getKeyAndSigRecs());
        if (!this.NewObject && this.revHost.isDynamic()) {
            this.myReversePanel.setEnabledComments(false);
        }
        Dimension dimension = this.myReversePanel.getMinSize();
        this.myReversePanel.setEnabled(true);
        this.myReversePanel.setEnabledButtons(true);
        this.myReversePanel.show();
        this.myReversePanel.requestFocus();
    }

    private boolean SaveAllData() {
        if (this.AliasHost != null) {
            Question question;
            this.myAliasPanel.setEnabled(false);
            this.myAliasPanel.setEnabledButtons(false);
            if (this.NewObject && !(question = new Question(3, this.myAliasPanel.getAliasName(), this.myAliasPanel.getFullyQualifiedDomainName())).getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                Object[] objectArray = new Object[]{this.myAliasPanel.getAliasName()};
                new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("DUP_ALIAS_MSG"), objectArray), 1, true, this.myAliasPanel);
                this.myAliasPanel.setEnabledAll(true);
                this.myAliasPanel.setEnabledButtons(true);
                return false;
            }
            this.AliasHost.setRealHostName(this.myAliasPanel.getHostName());
            this.AliasHost.setHostName(this.myAliasPanel.getAliasName());
            this.OwningDomainName = this.myAliasPanel.getFullyQualifiedDomainName();
            this.AliasHost.setCNAMEttl(this.myAliasPanel.getAliasTTL());
            this.AliasHost.setComments(this.makeCommentsValid(this.myAliasPanel.getComments()));
            return true;
        }
        if (this.revHost != null) {
            Question question;
            this.myReversePanel.setEnabled(false);
            this.myReversePanel.setEnabledButtons(false);
            if (this.NewObject && !(question = new Question(3, this.myReversePanel.getIPaddress(), this.OwningDomainName)).getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                Object[] objectArray = new Object[]{this.myReversePanel.getFqIPaddress()};
                new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("DUP_REV_MSG"), objectArray), 1, true, this.myReversePanel);
                this.myReversePanel.setEnabledAll(true);
                this.myReversePanel.setEnabledButtons(true);
                return false;
            }
            this.revHost.setHostName(this.myReversePanel.getIPaddress());
            this.revHost.setPTRhostname(this.myReversePanel.getHostName());
            this.revHost.setPTRttl(this.myReversePanel.getPtrTTL());
            this.revHost.setComments(this.makeCommentsValid(this.myReversePanel.getComments()));
            return true;
        }
        if (this.HostObj != null) {
            String[] stringArray;
            Question question;
            this.myHostPanel.setEnabled(false);
            this.myHostPanel.setEnabledButtons(false);
            if (this.NewObject && !(question = new Question(3, this.myHostPanel.getHostName(), this.myHostPanel.getFullyQualifiedDomainName())).getReturnedTrueOrFalse(this.MyParent.dataOut)) {
                Object[] objectArray = new Object[]{this.myHostPanel.getHostName()};
                new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("DUP_HOST_MSG"), objectArray), 1, true, this.myHostPanel);
                this.myHostPanel.setEnabled(true);
                this.myHostPanel.setEnabledButtons(true);
                return false;
            }
            this.HostObj.setHostName(this.myHostPanel.getHostName());
            this.HostObj.addAllIpAddresses(this.myHostPanel.getIPAddrList());
            this.OwningDomainName = this.myHostPanel.getFullyQualifiedDomainName();
            this.HostObj.setCpuOpSys(this.myHostPanel.getPlatformList());
            this.HostObj.setMailExchange(this.myHostPanel.getMailList());
            this.HostObj.setTextEntry(this.myHostPanel.getHostTextList());
            this.HostObj.setATTL(this.myHostPanel.getTTLForHostName());
            this.HostObj.setPTRTTL(this.myHostPanel.getTTLForIPAddr());
            this.HostObj.setMXTTL(this.myHostPanel.getTTLForMail());
            this.HostObj.setHINFOTTL(this.myHostPanel.getTTLForPlatform());
            this.HostObj.setTXTTTL(this.myHostPanel.getTTLForText());
            this.HostObj.setComments(this.makeCommentsValid(this.myHostPanel.getComments()));
            this.HostObj.setOtherRecs(this.myHostPanel.getOtherRecords());
            this.MyParent.dataOut.sendToServer("PDOM=GET,name=" + this.OwningDomainName + "," + "EPDOM" + ",");
            DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
            this.pDom = new PrimaryDomain(dDNSNetworkStringParser.getParsed());
            if (this.pDom.getReverseMappingState() && !this.HostObj.isDynamic() && (stringArray = this.myHostPanel.getIPAddrList()) != null) {
                Serializable serializable;
                Object object;
                Vector<String> vector = new Vector<String>();
                int n = 0;
                while (n < stringArray.length) {
                    question = new Question(4, stringArray[n]);
                    int n2 = question.getIntFromString(this.MyParent.dataOut);
                    if (n2 != 1) {
                        if (n2 == 2) {
                            vector.addElement(ReverseHost.reverseDomainFromAddrClassC(stringArray[n]));
                            this.MyParent.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=MAP," + "addr=" + stringArray[n] + "," + "name=" + this.myHostPanel.getHostName() + "," + "state=" + 2 + "," + "dname=" + this.OwningDomainName + "," + "ptrttl=" + this.myHostPanel.getTTLForIPAddr() + "," + ReverseHost.EREVH_tag + ",");
                            dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                            this.MyParent.changed((Object)this, this.myHostPanel.getHostName(), ReverseHost.reverseDomainFromAddrClassC(stringArray[n]));
                        } else {
                            object = "";
                            this.MyParent.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=MAP," + "addr=" + stringArray[n] + "," + "name=" + this.myHostPanel.getHostName() + "," + "state=" + 0 + "," + "dname=" + this.OwningDomainName + "," + "ptrttl=" + this.myHostPanel.getTTLForIPAddr() + "," + ReverseHost.EREVH_tag + ",");
                            dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                            serializable = dDNSNetworkStringParser.getParsed();
                            ParsedObject parsedObject = ((ParsedVector)serializable).getElement("dname");
                            String string = null;
                            string = parsedObject != null ? new String((String)parsedObject.getValue()) : ReverseHost.reverseDomainFromAddrClassC(stringArray[n]);
                            if (object != null) {
                                this.MyParent.changed((Object)this, this.myHostPanel.getHostName(), string);
                            }
                        }
                    }
                    ++n;
                }
                if (!vector.isEmpty()) {
                    object = new String[vector.size()];
                    vector.copyInto((Object[])object);
                    serializable = new CreateDomainDialog(this.MyParent, this.resources.getString("APP_TITLE"), (String[])object);
                    ((CreateDomainDialog)serializable).getMinSize();
                    ((Component)serializable).setVisible(true);
                }
            }
            return true;
        }
        return false;
    }

    public void SaveAndExit(Object object) {
        BusyWaitFrame busyWaitFrame = null;
        BusyWaitFrame busyWaitFrame2 = null;
        if (this.haveSecDomain) {
            if (this.AliasHost != null) {
                this.myAliasPanel.dispose();
                this.myAliasPanel = null;
            } else if (this.HostObj != null) {
                this.myHostPanel.dispose();
                this.myHostPanel = null;
            } else if (this.revHost != null) {
                this.myReversePanel.dispose();
                this.myReversePanel = null;
            }
            this.MyParent.requestFocus();
            return;
        }
        if (this.SaveAllData()) {
            if (this.AliasHost != null) {
                if (this.NewObject) {
                    this.MyParent.dataOut.sendToServer(this.AliasHost.toString("ADD", "dname=" + this.OwningDomainName));
                    this.MyParent.dataOut.receiveFromServer();
                    this.MyParent.dataOut.sendToServer(this.AliasHost.toString("LNK", "dname=" + this.OwningDomainName));
                    this.MyParent.dataOut.receiveFromServer();
                } else if (this.convertingObject) {
                    busyWaitFrame = new BusyWaitFrame(this.resources, this.resources.getString("CVT_WAIT_MESSAGE"));
                    ((Component)busyWaitFrame).setSize(300, 75);
                    ((Component)busyWaitFrame).setVisible(true);
                    this.MyParent.dataOut.sendToServer("RN=DEL,name=" + this.AliasHost.getHostName() + "," + "dname=" + this.OwningDomainName + "," + "ERN" + ",");
                    this.MyParent.dataOut.receiveFromServer();
                    this.MyParent.dataOut.sendToServer(this.AliasHost.toString("ADD", "dname=" + this.OwningDomainName));
                    DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                    if (this.AliasHost.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
                        this.MyParent.dataOut.sendToServer(this.AliasHost.toString("LNK", "dname=" + this.OwningDomainName));
                        this.MyParent.dataOut.receiveFromServer();
                    } else {
                        this.tellUserConvertFailed();
                        this.putReservedNameBack();
                    }
                    busyWaitFrame.dispose();
                } else {
                    if (this.AliasHost.isDynamic()) {
                        busyWaitFrame2 = new BusyWaitFrame(this.resources, this.resources.getString("MOD_WAIT_MESSAGE"));
                        ((Component)busyWaitFrame2).setSize(300, 75);
                        ((Component)busyWaitFrame2).setVisible(true);
                    }
                    this.MyParent.dataOut.sendToServer(this.AliasHost.toString("MOD", "dname=" + this.OwningDomainName));
                    DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                    if (!this.AliasHost.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
                        this.tellUserModifyFailed();
                    }
                    if (busyWaitFrame2 != null) {
                        busyWaitFrame2.dispose();
                    }
                }
                this.MyParent.changed((Object)this, this.AliasHost.getHostName(), this.OwningDomainName);
                this.myAliasPanel.dispose();
                this.myAliasPanel = null;
                this.MyParent.requestFocus();
                return;
            }
            if (this.HostObj != null) {
                if (this.NewObject) {
                    this.MyParent.dataOut.sendToServer(this.HostObj.toString("ADD", "dname=" + this.OwningDomainName));
                    this.MyParent.dataOut.receiveFromServer();
                    this.MyParent.dataOut.sendToServer(this.HostObj.toString("LNK", "dname=" + this.OwningDomainName));
                    this.MyParent.dataOut.receiveFromServer();
                } else if (this.convertingObject) {
                    busyWaitFrame = new BusyWaitFrame(this.resources, this.resources.getString("CVT_WAIT_MESSAGE"));
                    ((Component)busyWaitFrame).setSize(300, 75);
                    ((Component)busyWaitFrame).setVisible(true);
                    this.MyParent.dataOut.sendToServer("RN=DEL,name=" + this.HostObj.getHostName() + "," + "dname=" + this.OwningDomainName + "," + "ERN" + ",");
                    this.MyParent.dataOut.receiveFromServer();
                    this.MyParent.dataOut.sendToServer(this.HostObj.toString("ADD", "dname=" + this.OwningDomainName));
                    DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                    if (this.HostObj.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
                        this.MyParent.dataOut.sendToServer(this.HostObj.toString("LNK", "dname=" + this.OwningDomainName));
                        this.MyParent.dataOut.receiveFromServer();
                    } else {
                        this.tellUserConvertFailed();
                        this.putReservedNameBack();
                    }
                    busyWaitFrame.dispose();
                } else {
                    if (this.HostObj.isDynamic()) {
                        busyWaitFrame2 = new BusyWaitFrame(this.resources, this.resources.getString("MOD_WAIT_MESSAGE"));
                        ((Component)busyWaitFrame2).setSize(300, 75);
                        ((Component)busyWaitFrame2).setVisible(true);
                    }
                    this.MyParent.dataOut.sendToServer(this.HostObj.toString("MOD", "dname=" + this.OwningDomainName));
                    DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                    if (!this.HostObj.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
                        this.tellUserModifyFailed();
                    }
                    if (busyWaitFrame2 != null) {
                        busyWaitFrame2.dispose();
                    }
                }
                this.MyParent.changed((Object)this, this.HostObj.getHostName(), this.OwningDomainName);
                this.myHostPanel.dispose();
                this.myHostPanel = null;
                this.MyParent.requestFocus();
                return;
            }
            if (this.NewObject) {
                this.MyParent.dataOut.sendToServer(this.revHost.toString("ADD", "dname=" + this.OwningDomainName));
                this.MyParent.dataOut.receiveFromServer();
                this.MyParent.dataOut.sendToServer(this.revHost.toString("LNK", "dname=" + this.OwningDomainName));
                this.MyParent.dataOut.receiveFromServer();
            } else if (this.convertingObject) {
                busyWaitFrame = new BusyWaitFrame(this.resources, this.resources.getString("CVT_WAIT_MESSAGE"));
                ((Component)busyWaitFrame).setSize(300, 75);
                ((Component)busyWaitFrame).setVisible(true);
                this.MyParent.dataOut.sendToServer("RN=DEL,name=" + ReverseHost.addrFromReverseDom(this.OwningDomainName) + "." + this.revHost.getHostName() + "," + "dname=" + this.OwningDomainName + "," + "ERN" + ",");
                this.MyParent.dataOut.receiveFromServer();
                this.MyParent.dataOut.sendToServer(this.revHost.toString("ADD", "dname=" + this.OwningDomainName));
                DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                if (this.revHost.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
                    this.MyParent.dataOut.sendToServer(this.revHost.toString("LNK", "dname=" + this.OwningDomainName));
                    this.MyParent.dataOut.receiveFromServer();
                } else {
                    this.tellUserConvertFailed();
                    this.putReservedNameBack();
                }
                busyWaitFrame.dispose();
            } else {
                if (this.revHost.isDynamic()) {
                    busyWaitFrame2 = new BusyWaitFrame(this.resources, this.resources.getString("MOD_WAIT_MESSAGE"));
                    ((Component)busyWaitFrame2).setSize(300, 75);
                    ((Component)busyWaitFrame2).setVisible(true);
                }
                this.MyParent.dataOut.sendToServer(this.revHost.toString("MOD", "dname=" + this.OwningDomainName));
                DDNSNetworkStringParser dDNSNetworkStringParser = this.MyParent.dataOut.receiveFromServer();
                if (!this.revHost.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
                    this.tellUserModifyFailed();
                }
                if (busyWaitFrame2 != null) {
                    busyWaitFrame2.dispose();
                }
            }
            this.MyParent.changed((Object)this, this.revHost.getHostName(), this.OwningDomainName);
            this.myReversePanel.dispose();
            this.myReversePanel = null;
            this.MyParent.requestFocus();
        }
    }

    public void CancelAndExit(Object object) {
        if (this.AliasHost != null) {
            this.myAliasPanel.setEnabled(false);
            this.myAliasPanel.setEnabledButtons(false);
            this.myAliasPanel.dispose();
            this.myAliasPanel = null;
        } else if (this.HostObj != null) {
            this.myHostPanel.setEnabled(false);
            this.myHostPanel.setEnabledButtons(false);
            this.myHostPanel.dispose();
            this.myHostPanel = null;
        } else if (this.revHost != null) {
            this.myReversePanel.setEnabled(false);
            this.myReversePanel.setEnabledButtons(false);
            this.myReversePanel.dispose();
            this.myReversePanel = null;
        }
        this.MyParent.changed(this);
        this.MyParent.requestFocus();
    }

    private String[] makeCommentsValid(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = !stringArray[n].startsWith(";") ? new String(";" + stringArray[n]) : stringArray[n];
                ++n;
            }
        }
        return stringArray2;
    }

    private String[] makeCommentsDisplayable(String[] stringArray) {
        String[] stringArray2 = null;
        if (stringArray != null && stringArray.length > 0) {
            stringArray2 = new String[stringArray.length];
            int n = 0;
            while (n < stringArray.length) {
                stringArray2[n] = !stringArray[n].startsWith(";") ? stringArray[n] : stringArray[n].substring(1);
                ++n;
            }
        }
        return stringArray2;
    }

    private void tellUserModifyFailed() {
        String string = this.MyParent.getNameServerName();
        if (this.AliasHost != null) {
            Object[] objectArray = new Object[]{this.myAliasPanel.getAliasName(), string};
            msgBox msgBox2 = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("MOD_FAILED_MSG"), objectArray), 1, true, this.myAliasPanel);
            return;
        }
        if (this.HostObj != null) {
            Object[] objectArray = new Object[]{this.myHostPanel.getHostName(), string};
            msgBox msgBox3 = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("MOD_FAILED_MSG"), objectArray), 1, true, this.myHostPanel);
            return;
        }
        if (this.revHost != null) {
            Object[] objectArray = new Object[]{this.myReversePanel.getIPaddress(), string};
            msgBox msgBox4 = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("MOD_FAILED_MSG"), objectArray), 1, true, this.myReversePanel);
        }
    }

    private void tellUserConvertFailed() {
        if (this.AliasHost != null) {
            Object[] objectArray = new Object[]{this.myAliasPanel.getAliasName()};
            msgBox msgBox2 = new msgBox(this.resources, this.resources.getString("ALIAS_HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("CVT_ALIAS_FAILED_MSG"), objectArray), 1, true, this.myAliasPanel);
            return;
        }
        if (this.HostObj != null) {
            Object[] objectArray = new Object[]{this.myHostPanel.getHostName()};
            msgBox msgBox3 = new msgBox(this.resources, this.resources.getString("HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("CVT_HOST_FAILED_MSG"), objectArray), 1, true, this.myHostPanel);
            return;
        }
        if (this.revHost != null) {
            Object[] objectArray = new Object[]{this.myReversePanel.getIPaddress()};
            msgBox msgBox4 = new msgBox(this.resources, this.resources.getString("REVERSE_HOST_FRAME_NAME"), MessageFormat.format(this.resources.getString("CVT_REV_HOST_FAILED_MSG"), objectArray), 1, true, this.myReversePanel);
        }
    }

    private void putReservedNameBack() {
        this.MyParent.dataOut.sendToServer(this.saveReservedName.toString("ADD", "dname=" + this.OwningDomainName));
        this.MyParent.dataOut.receiveFromServer();
        this.MyParent.dataOut.sendToServer(this.saveReservedName.toString("LNK", "dname=" + this.OwningDomainName));
        this.MyParent.dataOut.receiveFromServer();
    }
}

