/*
 * Decompiled with CFR 0.152.
 */
package COM.ibm.raleigh.ddnssgui.client;

import COM.ibm.eNetwork.jdi.gui.attribView.AttribField;
import COM.ibm.eNetwork.jdi.gui.common.ColorsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.FontsForCanvas;
import COM.ibm.eNetwork.jdi.gui.common.ImagesForCanvas;
import COM.ibm.eNetwork.jdi.gui.detailsView.DetailsView;
import COM.ibm.eNetwork.jdi.gui.detailsView.DetailsViewEventListener;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeView;
import COM.ibm.eNetwork.jdi.gui.treeView.TreeViewEventListener;
import COM.ibm.eNetwork.jdi.gui.treeView.addableToTreeView;
import COM.ibm.raleigh.ddnssgui.client.HostRecordsFrame;
import COM.ibm.raleigh.ddnssgui.client.MainFrame;
import COM.ibm.raleigh.ddnssgui.common.BusyWaitFrame;
import COM.ibm.raleigh.ddnssgui.common.DDNSNetworkStringParser;
import COM.ibm.raleigh.ddnssgui.common.DDNSTreeViewScheme;
import COM.ibm.raleigh.ddnssgui.common.HostList;
import COM.ibm.raleigh.ddnssgui.common.HostOrAlias;
import COM.ibm.raleigh.ddnssgui.common.MsgBoxListener;
import COM.ibm.raleigh.ddnssgui.common.ReverseHost;
import COM.ibm.raleigh.ddnssgui.common.Tree;
import COM.ibm.raleigh.ddnssgui.common.TreeNode;
import COM.ibm.raleigh.ddnssgui.common.msgBox;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.MenuItem;
import java.awt.Panel;
import java.awt.PopupMenu;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;

class HostTreeView
extends Panel
implements DetailsViewEventListener,
MsgBoxListener,
ActionListener {
    private static final String cStmt1 = "(c) Copyright IBM Corp 1997. All rights reserved.\n";
    public static final int UNDETERMINED = 0;
    public static final int A_HOST = 1;
    public static final int A_ALIAS = 2;
    public static final int A_REVERSE = 3;
    public static final int A_RESERVED = 4;
    ImagesForCanvas gfcImage;
    FontsForCanvas ffcFont = new FontsForCanvas(new Font("Helvetica", 0, 12), new Font("Helvetica", 1, 12));
    ColorsForCanvas cfcColor = new ColorsForCanvas(Color.white, Color.black, Color.cyan);
    private ResourceBundle resources;
    DetailsView tv;
    String Root;
    addableToTreeView RootTreeNode;
    MainFrame myParent;
    Applet myApplet;
    PopupMenu hostOptions;
    PopupMenu secHostOptions;
    PopupMenu ReservedOptions;
    PopupMenu SecReservedOptions;
    PopupMenu RevReservedOptions;
    PopupMenu pDomOptions;
    PopupMenu sDomOptions;
    PopupMenu rPDomOptions;
    String NodeSelected;
    int theWidth = 200;
    int theHeight = 200;
    int totNumNodes;
    int startPoint;
    int numNodesHave;
    msgBox yesNoBox;
    DDNSTreeViewScheme pDomain_scheme;
    DDNSTreeViewScheme rpDomain_scheme;
    DDNSTreeViewScheme sDomain_scheme;
    DDNSTreeViewScheme DYHOSTSCH_scheme;
    DDNSTreeViewScheme DYALIASSCH_scheme;
    DDNSTreeViewScheme STHOSTSCH_scheme;
    DDNSTreeViewScheme STALIASSCH_scheme;
    DDNSTreeViewScheme SECHOSTSCH_scheme;
    DDNSTreeViewScheme SECALIASSCH_scheme;
    DDNSTreeViewScheme DYREVSCH_scheme;
    DDNSTreeViewScheme SECREVSCH_scheme;
    DDNSTreeViewScheme STREVSCH_scheme;
    DDNSTreeViewScheme RESNMSCH_scheme;
    DDNSTreeViewScheme RRESNMSCH_scheme;
    DDNSTreeViewScheme SECRESNSCH_scheme;
    Hashtable theSchemes;
    AttribField afNode1;
    AttribField afNode2;
    static final int WIDTH = 200;
    static final int HEIGHT = 200;
    private MenuItem POP_EDIT_HOST;
    private MenuItem POP_EDIT_HOST_SEC;
    private MenuItem POP_EDIT_PDOM;
    private MenuItem POP_EDIT_R_PDOM;
    private MenuItem POP_EDIT_SDOM;
    private MenuItem POP_VIEW_REC_HOST;
    private MenuItem POP_VIEW_REC_SEC_HOST;
    private MenuItem POP_VIEW_REC_PRI_RSRVD;
    private MenuItem POP_VIEW_REC_REV_RSRVD;
    private MenuItem POP_VIEW_REC_SEC_RSRVD;
    private MenuItem POP_DELETE;
    private MenuItem POP_ADD_H_PRI;
    private MenuItem POP_ADD_H_R_PRI;
    private MenuItem POP_ADD_A;
    private MenuItem POP_VIEW_SOA_PRI;
    private MenuItem POP_VIEW_SOA_R_PRI;
    private MenuItem POP_VIEW_SOA_SEC;
    private MenuItem POP_CON_A;
    private MenuItem POP_CON_H;
    private MenuItem POP_CON_R;
    static final String DYHOSTSCH = "dynhostscheme";
    static final String DYALIASSCH = "dynaliasscheme";
    static final String STHOSTSCH = "stahostscheme";
    static final String STALIASSCH = "staaliasscheme";
    static final String SECHOSTSCH = "sechostscheme";
    static final String SECALIASSCH = "secaliasscheme";
    static final String DYREVSCH = "dynrevscheme";
    static final String SECREVSCH = "secrevscheme";
    static final String STREVSCH = "starevscheme";
    static final String RESNMSCH = "reservnamscheme";
    static final String RRESNMSCH = "revrsrvnamscheme";
    static final String SECRESNSCH = "secreservnscheme";
    static final String RPDOMAINSCH = "rpdomainscheme";
    static final String PDOMAINSCH = "pdomainscheme";
    static final String SDOMAINSCH = "sdomainscheme";
    Image image1;
    Image image2;
    Image image3;
    Image image4;
    Image image5;
    Image image6;
    Image image7;
    Image image8;
    Image image9;
    Image image10;
    Image image11;
    Image image13;
    Image image14;
    Image image15;
    Image image16;
    Image image17;
    boolean primaryDomain = false;

    public HostTreeView(String string, MainFrame mainFrame, Applet applet, boolean bl) {
        this.Root = string;
        this.myParent = mainFrame;
        this.myApplet = applet;
        this.primaryDomain = bl;
        this.resources = mainFrame.clientResources;
    }

    public void addComponents() {
        this.theSchemes = new Hashtable();
        this.loadTreeImages();
        this.createPopupMenus();
        this.createSchemes();
        ImagesForCanvas imagesForCanvas = new ImagesForCanvas(null, null);
        if (this.primaryDomain) {
            if (this.Root.endsWith("in-addr.arpa")) {
                this.RootTreeNode = new TreeNode(this.Root, "Some", RPDOMAINSCH);
                ((TreeNode)this.RootTreeNode).setScheme(this.rpDomain_scheme);
            } else {
                this.RootTreeNode = new TreeNode(this.Root, "Some", PDOMAINSCH);
                ((TreeNode)this.RootTreeNode).setScheme(this.pDomain_scheme);
            }
            this.tv = new DetailsView(this.RootTreeNode, new Dimension(this.theWidth, this.theHeight), this.cfcColor, this.ffcFont, imagesForCanvas, this.image8, this.image9);
        } else {
            this.RootTreeNode = new TreeNode(this.Root, "Some", SDOMAINSCH);
            ((TreeNode)this.RootTreeNode).setScheme(this.sDomain_scheme);
            this.tv = new DetailsView(this.RootTreeNode, new Dimension(this.theWidth, this.theHeight), this.cfcColor, this.ffcFont, imagesForCanvas, this.image8, this.image9);
        }
        this.tv.addDetailsViewEventListener((TreeViewEventListener)this);
        this.createTrees(this.RootTreeNode);
        this.afNode1 = new AttribField();
        ColorsForCanvas colorsForCanvas = new ColorsForCanvas(Color.lightGray, Color.black, Color.cyan);
        this.afNode1.setColors(colorsForCanvas);
        this.afNode1.setFonts(this.ffcFont);
        this.afNode1.setText(this.resources.getString("HTV_SNAMECOLUMNHEADING"));
        this.afNode1.setWidth(140);
        this.tv.addAttribField(this.afNode1);
        this.afNode2 = new AttribField();
        this.afNode2.setColors(colorsForCanvas);
        this.afNode2.setFonts(this.ffcFont);
        this.afNode2.setText(this.resources.getString("HTV_SIPADDRCOLUMNHEADING"));
        this.afNode2.setWidth(125);
        this.tv.addAttribField(this.afNode2);
        this.tv.committ(true);
        this.setLayout(new BorderLayout());
        this.add("Center", (Component)this.tv);
    }

    protected void createTrees(addableToTreeView addableToTreeView2) {
        new Tree((TreeNode)addableToTreeView2);
    }

    public int getTotalNumber() {
        return this.totNumNodes;
    }

    public int getNumberReceived() {
        return this.numNodesHave;
    }

    public int getStartingPoint() {
        return this.startPoint;
    }

    public void doTree(String string, int n, int n2) {
        if (n > 100) {
            this.doTreeInPieces(string, n, n2);
            return;
        }
        HostList hostList = new HostList(string, n2, n);
        this.myParent.dataOut.sendToServer(hostList.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
        HostList hostList2 = new HostList(dDNSNetworkStringParser.getParsed(), this.theSchemes);
        this.totNumNodes = hostList2.getAllNo();
        this.startPoint = hostList2.getStartNo();
        this.numNodesHave = hostList2.getReturnedNo();
        Vector vector = hostList2.getTheList();
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        if (vector != null) {
            Enumeration enumeration = vector.elements();
            Tree tree = treeNode.getChild();
            if (tree != null) {
                tree.removeAllNodes();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = (TreeNode)enumeration.nextElement();
                    tree.addNode(treeNode2);
                }
            }
        }
        if (this.totNumNodes != this.numNodesHave && this.totNumNodes != 0) {
            this.myParent.partialTreeRetrieved();
        } else {
            this.myParent.wholeTreeRetrieved();
        }
        this.tv.committ(true);
    }

    public void doTreeInPieces(String string, int n, int n2) {
        Enumeration enumeration;
        HostList hostList = new HostList(string, n2, 100);
        this.myParent.dataOut.sendToServer(hostList.toString());
        DDNSNetworkStringParser dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
        HostList hostList2 = new HostList(dDNSNetworkStringParser.getParsed(), this.theSchemes);
        this.totNumNodes = hostList2.getAllNo();
        this.startPoint = hostList2.getStartNo();
        this.numNodesHave = hostList2.getReturnedNo();
        Vector vector = hostList2.getTheList();
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        if (n == 999999) {
            n = this.totNumNodes;
        }
        n -= this.numNodesHave;
        while (n > 0 && this.numNodesHave != this.totNumNodes - this.startPoint) {
            hostList = new HostList(string, n2 + this.numNodesHave, 100);
            this.myParent.dataOut.sendToServer(hostList.toString());
            dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
            hostList2 = new HostList(dDNSNetworkStringParser.getParsed(), this.theSchemes);
            if (hostList2 != null) {
                Vector vector2 = hostList2.getTheList();
                enumeration = vector2.elements();
                while (enumeration.hasMoreElements()) {
                    vector.addElement(enumeration.nextElement());
                }
                this.numNodesHave += vector2.size();
                n -= vector2.size();
                continue;
            }
            n = 0;
        }
        if (vector != null) {
            enumeration = vector.elements();
            Tree tree = treeNode.getChild();
            if (tree != null) {
                tree.removeAllNodes();
                while (enumeration.hasMoreElements()) {
                    TreeNode treeNode2 = (TreeNode)enumeration.nextElement();
                    tree.addNode(treeNode2);
                }
            }
        }
        if (this.totNumNodes != this.numNodesHave && this.totNumNodes != 0) {
            this.myParent.partialTreeRetrieved();
        } else {
            this.myParent.wholeTreeRetrieved();
        }
        this.tv.committ(true);
    }

    public String getSelectedName() {
        return this.NodeSelected;
    }

    public String getRootName() {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        return treeNode.sText;
    }

    public void msgBoxSelection(int n, int n2) {
        if (n2 == 2) {
            this.deleteIt();
        }
    }

    public boolean treeIsPrimary() {
        return this.primaryDomain;
    }

    public int getSelectedNodeType(String string) {
        TreeNode treeNode = (TreeNode)this.RootTreeNode;
        Tree tree = treeNode.getChild();
        TreeNode treeNode2 = tree.getNode(string);
        if (treeNode2 != null) {
            DDNSTreeViewScheme dDNSTreeViewScheme = (DDNSTreeViewScheme)treeNode2.getScheme();
            if (dDNSTreeViewScheme.getSchemeName().equals(DYHOSTSCH) || dDNSTreeViewScheme.getSchemeName().equals(STHOSTSCH) || dDNSTreeViewScheme.getSchemeName().equals(SECHOSTSCH)) {
                return 1;
            }
            if (dDNSTreeViewScheme.getSchemeName().equals(DYALIASSCH) || dDNSTreeViewScheme.getSchemeName().equals(STALIASSCH) || dDNSTreeViewScheme.getSchemeName().equals(SECALIASSCH)) {
                return 2;
            }
            if (dDNSTreeViewScheme.getSchemeName().equals(DYREVSCH) || dDNSTreeViewScheme.getSchemeName().equals(SECREVSCH) || dDNSTreeViewScheme.getSchemeName().equals(STREVSCH)) {
                return 3;
            }
            if (dDNSTreeViewScheme.getSchemeName().equals(RESNMSCH) || dDNSTreeViewScheme.getSchemeName().equals(SECRESNSCH) || dDNSTreeViewScheme.getSchemeName().equals(RRESNMSCH)) {
                return 4;
            }
        }
        return 0;
    }

    public void unSelectItem() {
        TreeNode treeNode;
        Tree tree;
        TreeNode treeNode2;
        if (this.NodeSelected != null && ((treeNode2 = (tree = (treeNode = (TreeNode)this.RootTreeNode).getChild()).getNode(this.NodeSelected)) != null || this.NodeSelected.equals(this.getRootName()))) {
            this.tv.unSelectTreeViewNode();
            this.tv.committ(true);
        }
    }

    public void expandAllTree() {
        this.tv.expandAllNodes();
    }

    public void collapseAllTree() {
        this.tv.collapseAllNodes();
    }

    private void createPopupMenus() {
        this.hostOptions = new PopupMenu();
        this.POP_EDIT_HOST = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_VIEW_REC_HOST = new MenuItem(this.resources.getString("HTV_SPOPVIEWREC"));
        this.POP_DELETE = new MenuItem(this.resources.getString("SPOPDELETE"));
        this.hostOptions.add(this.POP_EDIT_HOST);
        this.hostOptions.addSeparator();
        this.hostOptions.add(this.POP_VIEW_REC_HOST);
        this.hostOptions.addSeparator();
        this.hostOptions.add(this.POP_DELETE);
        this.secHostOptions = new PopupMenu();
        this.POP_EDIT_HOST_SEC = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_VIEW_REC_SEC_HOST = new MenuItem(this.resources.getString("HTV_SPOPVIEWREC"));
        this.secHostOptions.add(this.POP_EDIT_HOST_SEC);
        this.secHostOptions.addSeparator();
        this.secHostOptions.add(this.POP_VIEW_REC_SEC_HOST);
        this.SecReservedOptions = new PopupMenu();
        this.POP_VIEW_REC_SEC_RSRVD = new MenuItem(this.resources.getString("HTV_SPOPVIEWREC"));
        this.SecReservedOptions.add(this.POP_VIEW_REC_SEC_RSRVD);
        this.ReservedOptions = new PopupMenu();
        this.POP_CON_A = new MenuItem(this.resources.getString("HTV_SPOPCONVA"));
        this.POP_CON_H = new MenuItem(this.resources.getString("HTV_SPOPCONVH"));
        this.POP_VIEW_REC_PRI_RSRVD = new MenuItem(this.resources.getString("HTV_SPOPVIEWREC"));
        this.ReservedOptions.add(this.POP_CON_A);
        this.ReservedOptions.add(this.POP_CON_H);
        this.ReservedOptions.addSeparator();
        this.ReservedOptions.add(this.POP_VIEW_REC_PRI_RSRVD);
        this.RevReservedOptions = new PopupMenu();
        this.POP_CON_R = new MenuItem(this.resources.getString("HTV_SPOPCONVR"));
        this.POP_VIEW_REC_REV_RSRVD = new MenuItem(this.resources.getString("HTV_SPOPVIEWREC"));
        this.RevReservedOptions.add(this.POP_CON_R);
        this.RevReservedOptions.addSeparator();
        this.RevReservedOptions.add(this.POP_VIEW_REC_REV_RSRVD);
        this.pDomOptions = new PopupMenu();
        this.POP_EDIT_PDOM = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_ADD_H_PRI = new MenuItem(this.resources.getString("SPOPADDH"));
        this.POP_ADD_A = new MenuItem(this.resources.getString("SPOPADDA"));
        this.POP_VIEW_SOA_PRI = new MenuItem(this.resources.getString("HTV_SPOPVIEWSOA"));
        this.pDomOptions.add(this.POP_EDIT_PDOM);
        this.pDomOptions.addSeparator();
        this.pDomOptions.add(this.POP_ADD_H_PRI);
        this.pDomOptions.add(this.POP_ADD_A);
        this.pDomOptions.addSeparator();
        this.pDomOptions.add(this.POP_VIEW_SOA_PRI);
        this.rPDomOptions = new PopupMenu();
        this.POP_EDIT_R_PDOM = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_ADD_H_R_PRI = new MenuItem(this.resources.getString("SPOPADDH"));
        this.POP_VIEW_SOA_R_PRI = new MenuItem(this.resources.getString("HTV_SPOPVIEWSOA"));
        this.rPDomOptions.add(this.POP_EDIT_R_PDOM);
        this.rPDomOptions.addSeparator();
        this.rPDomOptions.add(this.POP_ADD_H_R_PRI);
        this.rPDomOptions.addSeparator();
        this.rPDomOptions.add(this.POP_VIEW_SOA_R_PRI);
        this.sDomOptions = new PopupMenu();
        this.POP_EDIT_SDOM = new MenuItem(this.resources.getString("SPOPMOD"));
        this.POP_VIEW_SOA_SEC = new MenuItem(this.resources.getString("HTV_SPOPVIEWSOA"));
        this.sDomOptions.add(this.POP_EDIT_SDOM);
        this.sDomOptions.addSeparator();
        this.sDomOptions.add(this.POP_VIEW_SOA_SEC);
        this.POP_EDIT_HOST.addActionListener(this);
        this.POP_EDIT_HOST_SEC.addActionListener(this);
        this.POP_EDIT_PDOM.addActionListener(this);
        this.POP_EDIT_R_PDOM.addActionListener(this);
        this.POP_EDIT_SDOM.addActionListener(this);
        this.POP_VIEW_REC_HOST.addActionListener(this);
        this.POP_VIEW_REC_SEC_HOST.addActionListener(this);
        this.POP_VIEW_REC_PRI_RSRVD.addActionListener(this);
        this.POP_VIEW_REC_REV_RSRVD.addActionListener(this);
        this.POP_VIEW_REC_SEC_RSRVD.addActionListener(this);
        this.POP_DELETE.addActionListener(this);
        this.POP_ADD_H_PRI.addActionListener(this);
        this.POP_ADD_H_R_PRI.addActionListener(this);
        this.POP_ADD_A.addActionListener(this);
        this.POP_VIEW_SOA_R_PRI.addActionListener(this);
        this.POP_VIEW_SOA_PRI.addActionListener(this);
        this.POP_VIEW_SOA_SEC.addActionListener(this);
        this.POP_CON_A.addActionListener(this);
        this.POP_CON_H.addActionListener(this);
        this.POP_CON_R.addActionListener(this);
    }

    private void updateItem(String string) {
        int n = this.getSelectedNodeType(string);
        if (n == 1) {
            this.myParent.HostSelected(string);
            return;
        }
        if (n == 2) {
            this.myParent.AliasSelected(string);
            return;
        }
        if (n == 3) {
            this.myParent.ReverseHostSelected(string);
        }
    }

    protected void handlePopupMenu(MenuItem menuItem) {
        String string = new String(((TreeNode)this.RootTreeNode).sText);
        if (menuItem == this.POP_EDIT_HOST || menuItem == this.POP_EDIT_HOST_SEC) {
            this.updateItem(this.NodeSelected);
            return;
        }
        if (menuItem == this.POP_EDIT_PDOM || menuItem == this.POP_EDIT_R_PDOM) {
            this.myParent.PrimaryDomainSelected(this.NodeSelected);
            return;
        }
        if (menuItem == this.POP_EDIT_SDOM) {
            this.myParent.SecondaryDomainSelected(this.NodeSelected);
            return;
        }
        if (menuItem == this.POP_ADD_H_PRI) {
            this.myParent.AddHost();
            return;
        }
        if (menuItem == this.POP_ADD_H_R_PRI) {
            this.myParent.AddReverseHost(string);
            return;
        }
        if (menuItem == this.POP_ADD_A) {
            this.myParent.AddAliasHost();
            return;
        }
        if (menuItem == this.POP_CON_A) {
            this.myParent.convertToAlias(this.NodeSelected, string);
            return;
        }
        if (menuItem == this.POP_CON_H) {
            this.myParent.convertToHost(this.NodeSelected, string);
            return;
        }
        if (menuItem == this.POP_CON_R) {
            this.myParent.convertToReverse(ReverseHost.reverseAddr(this.NodeSelected, string), string);
            return;
        }
        if (menuItem == this.POP_VIEW_SOA_PRI || menuItem == this.POP_VIEW_SOA_R_PRI) {
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            hostRecordsFrame.showPrimarySOAData(string, this.myParent, this.myParent.getNameServerName());
            return;
        }
        if (menuItem == this.POP_VIEW_SOA_SEC) {
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            hostRecordsFrame.showSecondarySOAData(string, this.myParent, this.myParent.getNameServerName());
            return;
        }
        if (menuItem == this.POP_DELETE) {
            this.yesNoBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("HTV_SDELETEMSG"), 2, true, this);
            return;
        }
        if (menuItem == this.POP_VIEW_REC_HOST || menuItem == this.POP_VIEW_REC_SEC_HOST || menuItem == this.POP_VIEW_REC_PRI_RSRVD || menuItem == this.POP_VIEW_REC_REV_RSRVD || menuItem == this.POP_VIEW_REC_SEC_RSRVD) {
            TreeNode treeNode;
            TreeNode treeNode2;
            Tree tree;
            HostRecordsFrame hostRecordsFrame = new HostRecordsFrame(this.resources);
            int n = this.getSelectedNodeType(this.NodeSelected);
            if (n == 1) {
                hostRecordsFrame.showHostRecords(this.NodeSelected, this.myParent, string);
                return;
            }
            if (n == 2) {
                hostRecordsFrame.showAliasRecords(this.NodeSelected, this.myParent, string);
                return;
            }
            if (n == 3) {
                hostRecordsFrame.showReverseRecords(this.NodeSelected, this.myParent, string);
                return;
            }
            if (n == 4 && (tree = (treeNode2 = (TreeNode)this.RootTreeNode).getChild()) != null && (treeNode = tree.getNode(this.NodeSelected)) != null) {
                DDNSTreeViewScheme dDNSTreeViewScheme = (DDNSTreeViewScheme)treeNode.getScheme();
                if (dDNSTreeViewScheme.getSchemeName().equals(RRESNMSCH)) {
                    hostRecordsFrame.showReverseReservedRecords(this.NodeSelected, this.myParent, string);
                    return;
                }
                hostRecordsFrame.showReservedRecords(this.NodeSelected, this.myParent, string);
            }
        }
    }

    private void loadTreeImages() {
        URL uRL = null;
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        MediaTracker mediaTracker = new MediaTracker(this);
        if (this.myApplet != null) {
            URL uRL2;
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "hostdyn.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image1 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "hoststat.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image2 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "hostsec.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image3 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "plus.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image8 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "minus.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image9 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "open.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image10 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "closed.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image11 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "aliassec.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image13 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "aliasdyn.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image14 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "aliasst.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image15 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "hostress.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image16 = toolkit.getImage(uRL);
            try {
                uRL2 = this.myApplet.getCodeBase();
                uRL = new URL(String.valueOf(uRL2.toString()) + ".." + MainFrame.theFileSeparator + "hostres.gif");
            }
            catch (MalformedURLException malformedURLException) {
                this.myParent.tracer.traceTime("HostTreeView", "Bad URL: " + uRL);
            }
            this.image17 = toolkit.getImage(uRL);
        } else {
            String string = this.getDirectory();
            this.image1 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "hostdyn.gif");
            this.image2 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "hoststat.gif");
            this.image3 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "hostsec.gif");
            this.image8 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "plus.gif");
            this.image9 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "minus.gif");
            this.image10 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "open.gif");
            this.image11 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "closed.gif");
            this.image13 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "aliassec.gif");
            this.image14 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "aliasdyn.gif");
            this.image15 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "aliasst.gif");
            this.image16 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "hostress.gif");
            this.image17 = toolkit.getImage(String.valueOf(string) + MainFrame.theFileSeparator + ".." + MainFrame.theFileSeparator + "java" + MainFrame.theFileSeparator + "hostres.gif");
        }
        mediaTracker.addImage(this.image1, 1);
        mediaTracker.addImage(this.image2, 1);
        mediaTracker.addImage(this.image3, 1);
        mediaTracker.addImage(this.image8, 1);
        mediaTracker.addImage(this.image9, 1);
        mediaTracker.addImage(this.image10, 1);
        mediaTracker.addImage(this.image11, 1);
        mediaTracker.addImage(this.image13, 1);
        mediaTracker.addImage(this.image14, 1);
        mediaTracker.addImage(this.image15, 1);
        mediaTracker.addImage(this.image16, 1);
        mediaTracker.addImage(this.image17, 1);
        try {
            mediaTracker.waitForID(1);
            return;
        }
        catch (InterruptedException interruptedException) {
            this.myParent.tracer.traceTime("HostTreeView", "Images not loaded");
            return;
        }
    }

    private void createSchemes() {
        this.gfcImage = new ImagesForCanvas(this.image1, this.image1);
        ImagesForCanvas imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.DYHOSTSCH_scheme = new DDNSTreeViewScheme(DYHOSTSCH);
        this.DYHOSTSCH_scheme.registerPosition(0);
        this.DYHOSTSCH_scheme.registerPosition(1);
        this.DYHOSTSCH_scheme.setColors(-2, this.cfcColor);
        this.DYHOSTSCH_scheme.setFonts(-2, this.ffcFont);
        this.DYHOSTSCH_scheme.setImages(0, this.gfcImage);
        this.DYHOSTSCH_scheme.setPopupMenu(-2, this.hostOptions);
        this.theSchemes.put(DYHOSTSCH, this.DYHOSTSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image2, this.image2);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.STHOSTSCH_scheme = new DDNSTreeViewScheme(STHOSTSCH);
        this.STHOSTSCH_scheme.registerPosition(0);
        this.STHOSTSCH_scheme.registerPosition(1);
        this.STHOSTSCH_scheme.setColors(-2, this.cfcColor);
        this.STHOSTSCH_scheme.setFonts(-2, this.ffcFont);
        this.STHOSTSCH_scheme.setImages(0, this.gfcImage);
        this.STHOSTSCH_scheme.setPopupMenu(-2, this.hostOptions);
        this.theSchemes.put(STHOSTSCH, this.STHOSTSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image3, this.image3);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.SECHOSTSCH_scheme = new DDNSTreeViewScheme(SECHOSTSCH);
        this.SECHOSTSCH_scheme.registerPosition(0);
        this.SECHOSTSCH_scheme.registerPosition(1);
        this.SECHOSTSCH_scheme.setFolders(imagesForCanvas);
        this.SECHOSTSCH_scheme.setColors(-2, this.cfcColor);
        this.SECHOSTSCH_scheme.setFonts(-2, this.ffcFont);
        this.SECHOSTSCH_scheme.setImages(0, this.gfcImage);
        this.SECHOSTSCH_scheme.setPopupMenu(-2, this.secHostOptions);
        this.theSchemes.put(SECHOSTSCH, this.SECHOSTSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image1, this.image1);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.DYREVSCH_scheme = new DDNSTreeViewScheme(DYREVSCH);
        this.DYREVSCH_scheme.registerPosition(0);
        this.DYREVSCH_scheme.registerPosition(1);
        this.DYREVSCH_scheme.setFolders(imagesForCanvas);
        this.DYREVSCH_scheme.setColors(-2, this.cfcColor);
        this.DYREVSCH_scheme.setFonts(-2, this.ffcFont);
        this.DYREVSCH_scheme.setImages(0, this.gfcImage);
        this.DYREVSCH_scheme.setPopupMenu(-2, this.hostOptions);
        this.theSchemes.put(DYREVSCH, this.DYREVSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image2, this.image2);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.STREVSCH_scheme = new DDNSTreeViewScheme(STREVSCH);
        this.STREVSCH_scheme.registerPosition(0);
        this.STREVSCH_scheme.registerPosition(1);
        this.STREVSCH_scheme.setFolders(imagesForCanvas);
        this.STREVSCH_scheme.setColors(-2, this.cfcColor);
        this.STREVSCH_scheme.setFonts(-2, this.ffcFont);
        this.STREVSCH_scheme.setImages(0, this.gfcImage);
        this.STREVSCH_scheme.setPopupMenu(-2, this.hostOptions);
        this.theSchemes.put(STREVSCH, this.STREVSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image3, this.image3);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.SECREVSCH_scheme = new DDNSTreeViewScheme(SECREVSCH);
        this.SECREVSCH_scheme.registerPosition(0);
        this.SECREVSCH_scheme.registerPosition(1);
        this.SECREVSCH_scheme.setFolders(imagesForCanvas);
        this.SECREVSCH_scheme.setColors(-2, this.cfcColor);
        this.SECREVSCH_scheme.setFonts(-2, this.ffcFont);
        this.SECREVSCH_scheme.setImages(0, this.gfcImage);
        this.SECREVSCH_scheme.setPopupMenu(-2, this.secHostOptions);
        this.theSchemes.put(SECREVSCH, this.SECREVSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image13, this.image13);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.SECALIASSCH_scheme = new DDNSTreeViewScheme(SECALIASSCH);
        this.SECALIASSCH_scheme.registerPosition(0);
        this.SECALIASSCH_scheme.registerPosition(1);
        this.SECALIASSCH_scheme.setFolders(imagesForCanvas);
        this.SECALIASSCH_scheme.setColors(-2, this.cfcColor);
        this.SECALIASSCH_scheme.setFonts(-2, this.ffcFont);
        this.SECALIASSCH_scheme.setImages(0, this.gfcImage);
        this.SECALIASSCH_scheme.setPopupMenu(-2, this.secHostOptions);
        this.theSchemes.put(SECALIASSCH, this.SECALIASSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image14, this.image14);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.DYALIASSCH_scheme = new DDNSTreeViewScheme(DYALIASSCH);
        this.DYALIASSCH_scheme.registerPosition(0);
        this.DYALIASSCH_scheme.registerPosition(1);
        this.DYALIASSCH_scheme.setFolders(imagesForCanvas);
        this.DYALIASSCH_scheme.setColors(-2, this.cfcColor);
        this.DYALIASSCH_scheme.setFonts(-2, this.ffcFont);
        this.DYALIASSCH_scheme.setImages(0, this.gfcImage);
        this.DYALIASSCH_scheme.setPopupMenu(-2, this.hostOptions);
        this.theSchemes.put(DYALIASSCH, this.DYALIASSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image15, this.image15);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.STALIASSCH_scheme = new DDNSTreeViewScheme(STALIASSCH);
        this.STALIASSCH_scheme.registerPosition(0);
        this.STALIASSCH_scheme.registerPosition(1);
        this.STALIASSCH_scheme.setFolders(imagesForCanvas);
        this.STALIASSCH_scheme.setColors(-2, this.cfcColor);
        this.STALIASSCH_scheme.setFonts(-2, this.ffcFont);
        this.STALIASSCH_scheme.setImages(0, this.gfcImage);
        this.STALIASSCH_scheme.setPopupMenu(-2, this.hostOptions);
        this.theSchemes.put(STALIASSCH, this.STALIASSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image16, this.image16);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.SECRESNSCH_scheme = new DDNSTreeViewScheme(SECRESNSCH);
        this.SECRESNSCH_scheme.registerPosition(0);
        this.SECRESNSCH_scheme.registerPosition(1);
        this.SECRESNSCH_scheme.setFolders(imagesForCanvas);
        this.SECRESNSCH_scheme.setColors(-2, this.cfcColor);
        this.SECRESNSCH_scheme.setFonts(-2, this.ffcFont);
        this.SECRESNSCH_scheme.setImages(0, this.gfcImage);
        this.SECRESNSCH_scheme.setPopupMenu(-2, this.SecReservedOptions);
        this.theSchemes.put(SECRESNSCH, this.SECRESNSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image17, this.image17);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.RESNMSCH_scheme = new DDNSTreeViewScheme(RESNMSCH);
        this.RESNMSCH_scheme.registerPosition(0);
        this.RESNMSCH_scheme.registerPosition(1);
        this.RESNMSCH_scheme.setFolders(imagesForCanvas);
        this.RESNMSCH_scheme.setColors(-2, this.cfcColor);
        this.RESNMSCH_scheme.setFonts(-2, this.ffcFont);
        this.RESNMSCH_scheme.setImages(0, this.gfcImage);
        this.RESNMSCH_scheme.setPopupMenu(-2, this.ReservedOptions);
        this.theSchemes.put(RESNMSCH, this.RESNMSCH_scheme);
        this.gfcImage = new ImagesForCanvas(this.image17, this.image17);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.RRESNMSCH_scheme = new DDNSTreeViewScheme(RRESNMSCH);
        this.RRESNMSCH_scheme.registerPosition(0);
        this.RRESNMSCH_scheme.registerPosition(1);
        this.RRESNMSCH_scheme.setFolders(imagesForCanvas);
        this.RRESNMSCH_scheme.setColors(-2, this.cfcColor);
        this.RRESNMSCH_scheme.setFonts(-2, this.ffcFont);
        this.RRESNMSCH_scheme.setImages(0, this.gfcImage);
        this.RRESNMSCH_scheme.setPopupMenu(-2, this.RevReservedOptions);
        this.theSchemes.put(RRESNMSCH, this.RRESNMSCH_scheme);
        this.gfcImage = new ImagesForCanvas(null, null);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.pDomain_scheme = new DDNSTreeViewScheme(PDOMAINSCH);
        this.pDomain_scheme.registerPosition(0);
        this.pDomain_scheme.setFolders(imagesForCanvas);
        this.pDomain_scheme.setColors(0, this.cfcColor);
        this.pDomain_scheme.setFonts(0, this.ffcFont);
        this.pDomain_scheme.setImages(0, this.gfcImage);
        this.pDomain_scheme.setPopupMenu(0, this.pDomOptions);
        this.theSchemes.put(PDOMAINSCH, this.pDomain_scheme);
        this.gfcImage = new ImagesForCanvas(null, null);
        imagesForCanvas = new ImagesForCanvas(this.image11, this.image10);
        this.rpDomain_scheme = new DDNSTreeViewScheme(RPDOMAINSCH);
        this.rpDomain_scheme.registerPosition(0);
        this.rpDomain_scheme.setFolders(imagesForCanvas);
        this.rpDomain_scheme.setColors(0, this.cfcColor);
        this.rpDomain_scheme.setFonts(0, this.ffcFont);
        this.rpDomain_scheme.setImages(0, this.gfcImage);
        this.rpDomain_scheme.setPopupMenu(0, this.rPDomOptions);
        this.theSchemes.put(RPDOMAINSCH, this.rpDomain_scheme);
        this.sDomain_scheme = new DDNSTreeViewScheme(SDOMAINSCH);
        this.sDomain_scheme.registerPosition(0);
        this.sDomain_scheme.setFolders(imagesForCanvas);
        this.sDomain_scheme.setColors(0, this.cfcColor);
        this.sDomain_scheme.setFonts(0, this.ffcFont);
        this.sDomain_scheme.setImages(0, this.gfcImage);
        this.sDomain_scheme.setPopupMenu(0, this.sDomOptions);
        this.theSchemes.put(SDOMAINSCH, this.sDomain_scheme);
    }

    public void deleteSelectedObject() {
        if (!this.NodeSelected.equals(this.getRootName())) {
            this.yesNoBox = new msgBox(this.resources, this.resources.getString("APP_TITLE"), this.resources.getString("HTV_SDELETEMSG"), 2, true, this);
        }
    }

    public boolean canDeleteSelected() {
        int n = this.getSelectedNodeType(this.NodeSelected);
        return n != 4 && !this.NodeSelected.equals(((TreeNode)this.RootTreeNode).sText) && this.primaryDomain;
    }

    private void deleteIt() {
        DDNSNetworkStringParser dDNSNetworkStringParser = null;
        String string = new String(((TreeNode)this.RootTreeNode).sText);
        int n = this.getSelectedNodeType(this.NodeSelected);
        Object[] objectArray = new Object[]{this.NodeSelected};
        BusyWaitFrame busyWaitFrame = new BusyWaitFrame(this.resources, MessageFormat.format(this.resources.getString("HTV_DELETE_WAIT_MESSAGE"), objectArray));
        ((Component)busyWaitFrame).setSize(300, 75);
        ((Component)busyWaitFrame).setVisible(true);
        HostOrAlias hostOrAlias = new HostOrAlias();
        if (n == 1) {
            this.myParent.dataOut.sendToServer("HOST=DEL,name=" + this.NodeSelected + "," + "dname=" + string + "," + "EHOST" + ",");
            dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
        } else if (n == 2) {
            this.myParent.dataOut.sendToServer("ALIAS=DEL,name=" + this.NodeSelected + "," + "dname=" + string + "," + "EALIAS" + ",");
            dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
        } else if (n == 3) {
            this.myParent.dataOut.sendToServer(String.valueOf(ReverseHost.REVH_tag) + "=DEL," + "name=" + this.NodeSelected + "," + "dname=" + string + "," + ReverseHost.EREVH_tag + ",");
            dDNSNetworkStringParser = this.myParent.dataOut.receiveFromServer();
        }
        if (dDNSNetworkStringParser != null && hostOrAlias.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
            TreeNode treeNode = (TreeNode)this.RootTreeNode;
            Tree tree = treeNode.getChild();
            if (tree != null) {
                TreeNode treeNode2 = tree.getNode(this.NodeSelected);
                if (treeNode2 != null) {
                    DDNSTreeViewScheme dDNSTreeViewScheme = (DDNSTreeViewScheme)treeNode2.getScheme();
                    if (dDNSTreeViewScheme.getSchemeName().equals(DYHOSTSCH) || dDNSTreeViewScheme.getSchemeName().equals(DYALIASSCH) || dDNSTreeViewScheme.getSchemeName().equals(DYREVSCH)) {
                        DDNSTreeViewScheme dDNSTreeViewScheme2 = string.endsWith("in-addr.arpa") ? (DDNSTreeViewScheme)((Object)this.theSchemes.get(RESNMSCH)) : (DDNSTreeViewScheme)((Object)this.theSchemes.get(RRESNMSCH));
                        treeNode2.setScheme(dDNSTreeViewScheme2);
                        treeNode2.addText(1, "");
                    } else {
                        tree.removeNode(this.NodeSelected);
                    }
                }
                this.tv.committ(true);
            }
            busyWaitFrame.dispose();
            return;
        }
        if (dDNSNetworkStringParser != null && !hostOrAlias.getReturnCode(dDNSNetworkStringParser.getReturnCode())) {
            busyWaitFrame.dispose();
            Object[] objectArray2 = new Object[]{this.NodeSelected};
            new msgBox(this.resources, this.resources.getString("APP_TITLE"), MessageFormat.format(this.resources.getString("HTV_DELETE_FAILED_MSG1"), objectArray2), 1, true, this);
        }
    }

    public boolean preNodeSelected(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public boolean preNodeExpanded(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public boolean preNodeCollapsed(TreeView treeView, addableToTreeView addableToTreeView2) {
        return true;
    }

    public void postNodeSelected(TreeView treeView, addableToTreeView addableToTreeView2) {
        TreeNode treeNode = (TreeNode)addableToTreeView2;
        this.NodeSelected = new String(treeNode.sText);
        this.myParent.hostTreeItemSelected(this.NodeSelected);
    }

    public void postNodeExpanded(TreeView treeView, addableToTreeView addableToTreeView2) {
    }

    public void postNodeCollapsed(TreeView treeView, addableToTreeView addableToTreeView2) {
    }

    public void nodeDoubleClicked(TreeView treeView, addableToTreeView addableToTreeView2) {
        TreeNode treeNode = (TreeNode)addableToTreeView2;
        new String(this.getRootName());
        if (treeNode == this.RootTreeNode) {
            if (this.primaryDomain) {
                this.myParent.PrimaryDomainSelected(treeNode.sText);
                return;
            }
            this.myParent.SecondaryDomainSelected(treeNode.sText);
            return;
        }
        this.updateItem(treeNode.sText);
    }

    private String getDirectory() {
        try {
            String string = System.getProperty("java.class.path");
            string = string.toLowerCase();
            String string2 = System.getProperty("path.separator");
            StringTokenizer stringTokenizer = new StringTokenizer(string, string2, false);
            while (stringTokenizer.hasMoreElements()) {
                String string3 = (String)stringTokenizer.nextElement();
                if (!string3.endsWith("ddnssgui.jar")) continue;
                int n = string3.lastIndexOf("ddnssgui.jar");
                try {
                    return string3.substring(0, n - 1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    return ".";
                }
            }
        }
        catch (SecurityException securityException) {
            return ".";
        }
        return ".";
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof MenuItem) {
            this.handlePopupMenu((MenuItem)object);
        }
    }
}

